/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.config;

import net.lavabucket.hourglass.client.gui.ScreenAlignment;
import net.lavabucket.hourglass.message.TemplateMessage;
import net.lavabucket.hourglass.time.Time;
import net.lavabucket.hourglass.time.effects.EffectCondition;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

public class HourglassConfig {
    public static final ServerConfig SERVER_CONFIG = new ServerConfig(new ForgeConfigSpec.Builder());
    public static final ClientConfig CLIENT_CONFIG = new ClientConfig(new ForgeConfigSpec.Builder());

    @SubscribeEvent
    public static void onConstructModEvent(FMLConstructModEvent event) {
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)HourglassConfig.SERVER_CONFIG.spec);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)HourglassConfig.CLIENT_CONFIG.spec);
    }

    public static class ServerConfig {
        public final ForgeConfigSpec spec;
        public final ForgeConfigSpec.DoubleValue daySpeed;
        public final ForgeConfigSpec.DoubleValue nightSpeed;
        public final ForgeConfigSpec.EnumValue<EffectCondition> weatherEffect;
        public final ForgeConfigSpec.EnumValue<EffectCondition> randomTickEffect;
        public final ForgeConfigSpec.IntValue baseRandomTickSpeed;
        public final ForgeConfigSpec.EnumValue<EffectCondition> potionEffect;
        public final ForgeConfigSpec.EnumValue<EffectCondition> hungerEffect;
        public final ForgeConfigSpec.EnumValue<EffectCondition> blockEntityEffect;
        public final ForgeConfigSpec.BooleanValue enableSleepFeature;
        public final ForgeConfigSpec.DoubleValue sleepSpeedMin;
        public final ForgeConfigSpec.DoubleValue sleepSpeedMax;
        public final ForgeConfigSpec.DoubleValue sleepSpeedAll;
        public final ForgeConfigSpec.DoubleValue sleepSpeedCurve;
        public final ForgeConfigSpec.BooleanValue clearWeatherOnWake;
        public final ForgeConfigSpec.BooleanValue displayBedClock;
        public final ForgeConfigSpec.BooleanValue allowDaySleep;
        public final ForgeConfigSpec.ConfigValue<String> morningMessage;
        public final ForgeConfigSpec.EnumValue<ChatTypeOptions> morningMessageType;
        public final ForgeConfigSpec.EnumValue<TemplateMessage.MessageTarget> morningMessageTarget;
        public final ForgeConfigSpec.ConfigValue<String> enterBedMessage;
        public final ForgeConfigSpec.EnumValue<ChatTypeOptions> enterBedMessageType;
        public final ForgeConfigSpec.EnumValue<TemplateMessage.MessageTarget> enterBedMessageTarget;
        public final ForgeConfigSpec.ConfigValue<String> leaveBedMessage;
        public final ForgeConfigSpec.EnumValue<ChatTypeOptions> leaveBedMessageType;
        public final ForgeConfigSpec.EnumValue<TemplateMessage.MessageTarget> leaveBedMessageTarget;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("time");
            this.daySpeed = builder.comment(new String[]{"The speed at which time passes during the day.", "Day is defined as any time between 23500 (middle of dawn) and 12500 (middle of dusk) the next day.", "Vanilla speed: 1.0"}).defineInRange("daySpeed", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.nightSpeed = builder.comment(new String[]{"The speed at which time passes during the night.", "Night is defined as any time between 12500 (middle of dusk) and 23500 (middle of dawn).", "Vanilla speed: 1.0"}).defineInRange("nightSpeed", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            builder.push("effects");
            this.weatherEffect = builder.comment(new String[]{"When applied, this effect syncs the passage of weather with the current speed of time.", "I.e., as time moves faster, rain stops faster. Clear weather is not affected.", "When set to SLEEPING, this effect only applies when at least one player is sleeping in a dimension.", "Note: This setting is not applicable if game rule doWeatherCycle is false."}).defineEnum("weatherEffect", (Enum)EffectCondition.SLEEPING);
            this.randomTickEffect = builder.comment(new String[]{"When applied, this effect syncs the random tick speed with the current speed of time, forcing", "crop, tree, and grass growth to occur at baseRandomTickSpeed multiplied by the current time-speed.", "When set to SLEEPING, randomTickSpeed is set to baseRandomTickSpeed unless at least one player is sleeping in a dimension.", "More information on the effects of random tick speed can be found here: https://minecraft.fandom.com/wiki/Tick#Random_tick", "WARNING: This setting overwrites the randomTickSpeed game rule. To modify the base random tick speed,", "use the baseRandomTickSpeed setting instead of changing the game rule directly."}).defineEnum("randomTickEffect", (Enum)EffectCondition.NEVER);
            this.baseRandomTickSpeed = builder.comment("The base random tick speed used by the randomTickEffect time effect.").defineInRange("baseRandomTickSpeed", 3, 0, Integer.MAX_VALUE);
            this.potionEffect = builder.comment(new String[]{"When applied, this effect progresses potion effects to match the rate of the current time-speed.", "This effect does not apply if time speed is 1.0 or less.", "THIS MAY HAVE A NEGATIVE IMPACT ON PERFORMANCE IN SERVERS WITH MANY PLAYERS.", "When set to ALWAYS, this effect applies to all players in the dimension, day or night.", "When set to SLEEPING, this effect only applies to players who are sleeping."}).defineEnum("potionEffect", (Enum)EffectCondition.NEVER);
            this.hungerEffect = builder.comment(new String[]{"When applied, this effect progresses player hunger effects to match the rate of the current time-speed.", "This results in faster healing when food level is full, and faster harm when food level is too low.", "This effect does not apply if time speed is 1.0 or less.", "When set to ALWAYS, this effect applies to all players in the dimension, day or night. Not recommended on higher difficulty settings", "When set to SLEEPING, this effect only applies to players who are sleeping."}).defineEnum("hungerEffect", (Enum)EffectCondition.NEVER);
            this.blockEntityEffect = builder.comment(new String[]{"When applied, this effect progresses block entities like furnaces, hoppers, and spawners to match the rate of the current time-speed.", "WARNING: This time-effect has a significant impact on performance.", "This effect does not apply if time speed is 1.0 or less.", "When set to SLEEPING, this effect only applies when at least one player is sleeping in a dimension."}).defineEnum("blockEntityEffect", (Enum)EffectCondition.NEVER);
            builder.pop();
            builder.pop();
            builder.push("sleep");
            this.enableSleepFeature = builder.comment(new String[]{"Enables or disables the sleep feature of this mod. Enabling this setting will modify the vanilla sleep functionality", "and may conflict with other sleep mods. If disabled, all settings in the sleep section will not apply."}).define("enableSleepFeature", true);
            this.sleepSpeedMax = builder.comment(new String[]{"## THIS SETTING DEFINES THE SLEEP TIME-SPEED IN SINGLE-PLAYER GAMES ###", "The maximum speed at which time passes when all players are sleeping.", "A value of 110 is nearly equal to the time it takes to sleep in vanilla."}).defineInRange("sleepSpeedMax", 110.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedMin = builder.comment("The minimum speed at which time passes when only 1 player is sleeping in a full server.").defineInRange("sleepSpeedMin", 1.0, 0.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedAll = builder.comment(new String[]{"The speed at which time passes when all players are sleeping.", "Set to -1 to disable this feature (sleepSpeedMax will be used when all players are sleeping)."}).defineInRange("sleepSpeedAll", -1.0, -1.0, Time.DAY_LENGTH.doubleValue());
            this.sleepSpeedCurve = builder.comment(new String[]{"This parameter defines the curvature of the interpolation function that translates the sleeping player percentage into time-speed.", "The function used is a Normalized Tunable Sigmoid Function.", "A value of 0.5 represents a linear relationship.", "Smaller values bend the curve toward the X axis, while greater values bend it toward the Y axis.", "This graph may be used as a reference for tuning the curve: https://www.desmos.com/calculator/w8gntxzfow", "Credit to Dino Dini for the function: https://dinodini.wordpress.com/2010/04/05/normalized-tunable-sigmoid-functions/", "Credit to SmoothSleep for the idea: https://www.spigotmc.org/resources/smoothsleep.32043/"}).defineInRange("sleepSpeedCurve", 0.3, 0.0, 1.0);
            this.clearWeatherOnWake = builder.comment(new String[]{"Set to 'true' for the weather to clear when players wake up in the morning as it does in vanilla.", "Set to 'false' to force weather to pass naturally. Adds realism when accelerateWeather is enabled.", "Note: This setting is ignored if game rule doWeatherCycle is false."}).define("clearWeatherOnWake", true);
            this.allowDaySleep = builder.comment(new String[]{"When true, players are allowed to sleep at all times of day in dimensions controlled by Hourglass.", "Note: Other mods may override this ability."}).define("allowDaySleep", false);
            this.displayBedClock = builder.comment("When true, a clock is displayed in the sleep interface.").define("displayBedClock", true);
            builder.comment(new String[]{"This section defines settings for notification messages.", "All messages support Minecraft formatting codes (https://minecraft.fandom.com/wiki/Formatting_codes).", "All messages have variables that can be inserted using the following format: ${variableName}", "The type option controls where the message appears:", "\tSYSTEM: Appears as a message in the chat. (e.g., \"Respawn point set\")", "\tGAME_INFO: Game information that appears above the hotbar (e.g., \"You may not rest now, the bed is too far away\").", "The target option controls to whom the message is sent:", "\tALL: Sends the message to all players on the server.", "\tDIMENSION: Sends the message to all players in the current dimension.", "\tSLEEPING: Sends the message to all players in the current dimension who are sleeping."}).push("messages");
            builder.comment("This message is sent after a sleep cycle has completed.").push("morning");
            this.morningMessage = builder.comment(new String[]{"Available variables:", "sleepingPlayers -> the number of players in the current dimension who were sleeping.", "totalPlayers -> the number of players in the current dimension (spectators are not counted).", "sleepingPercentage -> the percentage of players in the current dimension who were sleeping (does not include % symbol)."}).define("message", (Object)"\u00a7e\u00a7oTempus fugit!");
            this.morningMessageType = builder.comment("Sets where this message appears.").defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO, (Enum[])new ChatTypeOptions[]{ChatTypeOptions.SYSTEM, ChatTypeOptions.GAME_INFO});
            this.morningMessageTarget = builder.comment(new String[]{"Sets to whom this message is sent.", "A target of 'SLEEPING' will send the message to all players who just woke up."}).defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.comment("This message is sent when a player enters their bed.").push("enterBed");
            this.enterBedMessage = builder.comment(new String[]{"Available variables:", "player -> the player who started sleeping.", "sleepingPlayers -> the number of players in the current dimension who are sleeping.", "totalPlayers -> the number of players in the current dimension (spectators are not counted).", "sleepingPercentage -> the percentage of players in the current dimension who are sleeping (does not include % symbol)."}).define("message", (Object)"${player} is now sleeping. [${sleepingPlayers}/${totalPlayers}]");
            this.enterBedMessageType = builder.comment("Sets where this message appears.").defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO, (Enum[])new ChatTypeOptions[]{ChatTypeOptions.SYSTEM, ChatTypeOptions.GAME_INFO});
            this.enterBedMessageTarget = builder.comment("Sets to whom this message is sent.").defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.comment("This message is sent when a player leaves their bed (without being woken up naturally by morning).").push("leaveBed");
            this.leaveBedMessage = builder.comment(new String[]{"Available variables:", "player -> the player who left their bed.", "sleepingPlayers -> the number of players in the current dimension who are sleeping.", "totalPlayers -> the number of players in the current dimension (spectators are not counted).", "sleepingPercentage -> the percentage of players in the current dimension who are sleeping (does not include % symbol)."}).define("message", (Object)"${player} has left their bed. [${sleepingPlayers}/${totalPlayers}]");
            this.leaveBedMessageType = builder.comment("Sets where this message appears.").defineEnum("type", (Enum)ChatTypeOptions.GAME_INFO, (Enum[])new ChatTypeOptions[]{ChatTypeOptions.SYSTEM, ChatTypeOptions.GAME_INFO});
            this.leaveBedMessageTarget = builder.comment("Sets to whom this message is sent.").defineEnum("target", (Enum)TemplateMessage.MessageTarget.DIMENSION);
            builder.pop();
            builder.pop();
            builder.pop();
            this.spec = builder.build();
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec spec;
        public final ForgeConfigSpec.EnumValue<ScreenAlignment> clockAlignment;
        public final ForgeConfigSpec.IntValue clockScale;
        public final ForgeConfigSpec.IntValue clockMargin;
        public final ForgeConfigSpec.BooleanValue preventClockWobble;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("gui");
            this.clockAlignment = builder.comment("Sets the screen alignment of the bed clock.").defineEnum("clockAlignment", (Enum)ScreenAlignment.TOP_RIGHT);
            this.clockScale = builder.comment("Sets the scale of the bed clock.").defineInRange("clockScale", 64, 1, Integer.MAX_VALUE);
            this.clockMargin = builder.comment(new String[]{"Sets the distance between the clock and the edge of the screen.", "Unused if clockAlignment is CENTER_CENTER."}).defineInRange("clockMargin", 16, 0, Integer.MAX_VALUE);
            this.preventClockWobble = builder.comment(new String[]{"This setting prevents clock wobble when getting in bed by updating the clock's position every tick.", "As a side-effect, the clock won't wobble when first viewed as it does in vanilla. This setting is", "unused if displayBedClock is false."}).define("preventClockWobble", true);
            builder.pop();
            this.spec = builder.build();
        }
    }

    public static enum ChatTypeOptions {
        SYSTEM(false),
        GAME_INFO(true);

        private final boolean overlay;

        private ChatTypeOptions(boolean overlay) {
            this.overlay = overlay;
        }

        public boolean isOverlay() {
            return this.overlay;
        }
    }
}

