/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time.effects;

import java.util.stream.Stream;
import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.time.TimeContext;
import net.lavabucket.hourglass.time.effects.AbstractTimeEffect;
import net.lavabucket.hourglass.time.effects.EffectCondition;
import net.lavabucket.hourglass.wrappers.ServerLevelWrapper;
import net.lavabucket.hourglass.wrappers.ServerPlayerWrapper;
import net.minecraft.server.level.ServerLevel;

public class PotionTimeEffect
extends AbstractTimeEffect {
    @Override
    public void onTimeTick(TimeContext context) {
        EffectCondition condition = (EffectCondition)((Object)HourglassConfig.SERVER_CONFIG.potionEffect.get());
        if (condition == EffectCondition.NEVER) {
            return;
        }
        ServerLevelWrapper level = context.getLevel();
        SleepStatus sleepStatus = context.getTimeService().sleepStatus;
        long extraTicks = context.getTimeDelta().longValue() - 1L;
        if (extraTicks <= 0L || condition == EffectCondition.SLEEPING && sleepStatus.allAwake()) {
            return;
        }
        Stream<ServerPlayerWrapper> playerStream = ((ServerLevel)level.get()).m_6907_().stream().map(ServerPlayerWrapper::new);
        if (condition == EffectCondition.SLEEPING) {
            playerStream = playerStream.filter(ServerPlayerWrapper::isSleeping);
        }
        playerStream.forEach(player -> PotionTimeEffect.tickEffects(player, extraTicks));
    }

    private static void tickEffects(ServerPlayerWrapper player, long ticks) {
        int i = 0;
        while ((long)i < ticks) {
            player.tickEffects();
            ++i;
        }
        player.sendMobEffectUpdatePackets();
    }
}

