/*
 * Decompiled with CFR 0.152.
 */
package net.lavabucket.hourglass.time.effects;

import net.lavabucket.hourglass.config.HourglassConfig;
import net.lavabucket.hourglass.time.SleepStatus;
import net.lavabucket.hourglass.time.TimeContext;
import net.lavabucket.hourglass.time.effects.AbstractTimeEffect;
import net.lavabucket.hourglass.time.effects.EffectCondition;

public class RandomTickSleepEffect
extends AbstractTimeEffect {
    @Override
    public void onTimeTick(TimeContext context) {
        this.updateRandomTickSpeed(context);
    }

    private void updateRandomTickSpeed(TimeContext context) {
        EffectCondition condition = (EffectCondition)((Object)HourglassConfig.SERVER_CONFIG.randomTickEffect.get());
        if (condition == EffectCondition.NEVER) {
            return;
        }
        int speed = (Integer)HourglassConfig.SERVER_CONFIG.baseRandomTickSpeed.get();
        SleepStatus sleepStatus = context.getTimeService().sleepStatus;
        if (condition == EffectCondition.ALWAYS || condition == EffectCondition.SLEEPING && !sleepStatus.allAwake()) {
            speed = (int)((long)speed * context.getTimeDelta().longValue());
        }
        context.getLevel().setRandomTickSpeed(speed);
    }
}

