/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.events;

import com.mojang.blaze3d.platform.InputConstants;
import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PFDebugHud;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import java.nio.file.Path;
import net.minecraft.client.KeyMapping;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="presencefootsteps", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModLifecycleEventSubscriber {
    private static final PresenceFootsteps presenceFootsteps = PresenceFootsteps.getInstance();

    @SubscribeEvent
    public static void onConstruct(FMLConstructModEvent event) {
        PresenceFootsteps.logger.info("Presence Footsteps starting");
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        Path pfFolder = FMLPaths.CONFIGDIR.get().resolve("presencefootsteps");
        presenceFootsteps.setConfig(new PFConfig(pfFolder.resolve("userconfig.json"), presenceFootsteps));
        presenceFootsteps.getConfig().load();
        presenceFootsteps.setEngine(new SoundEngine(presenceFootsteps.getConfig()));
        event.registerReloadListener((PreparableReloadListener)presenceFootsteps.getEngine());
    }

    @SubscribeEvent
    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        ModLifecycleEventSubscriber.presenceFootsteps.keyBinding = Lazy.of(() -> new KeyMapping("key.presencefootsteps.settings", InputConstants.Type.KEYSYM, 299, "key.categories.misc"));
        event.register((KeyMapping)ModLifecycleEventSubscriber.presenceFootsteps.keyBinding.get());
    }

    @SubscribeEvent
    public static void onInitializeClient(FMLClientSetupEvent event) {
        presenceFootsteps.setDebugHud(new PFDebugHud(presenceFootsteps.getEngine()));
    }
}

