/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MotionTracker {
    private double lastX;
    private double lastY;
    private double lastZ;
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    private final TerrestrialStepSoundGenerator generator;

    public MotionTracker(TerrestrialStepSoundGenerator generator) {
        this.generator = generator;
    }

    public double getMotionX() {
        return this.motionX;
    }

    public double getMotionY() {
        return this.motionY;
    }

    public double getMotionZ() {
        return this.motionZ;
    }

    public double getHorizontalSpeed() {
        return this.motionX * this.motionX + this.motionZ * this.motionZ;
    }

    public boolean isStationary() {
        return this.motionX == 0.0 && this.motionZ == 0.0;
    }

    public void simulateMotionData(LivingEntity ply) {
        if (PlayerUtil.isClientPlayer((Entity)ply)) {
            this.motionX = ply.m_20184_().f_82479_;
            this.motionY = ply.m_20184_().f_82480_;
            this.motionZ = ply.m_20184_().f_82481_;
        } else {
            this.motionX = ply.m_20185_() - this.lastX;
            this.lastX = ply.m_20185_();
            this.motionY = ply.m_20186_() - this.lastY;
            if (ply.m_20096_()) {
                this.motionY += 0.0784000015258789;
            }
            this.lastY = ply.m_20186_();
            this.motionZ = ply.m_20189_() - this.lastZ;
            this.lastZ = ply.m_20189_();
        }
        if (ply instanceof RemotePlayer && ply.f_19853_.m_46467_() % 1L == 0L) {
            ply.f_19788_ = this.motionX != 0.0 || this.motionZ != 0.0 ? (float)((double)ply.f_19788_ + Math.sqrt(Math.pow(this.motionX, 2.0) + Math.pow(this.motionY, 2.0) + Math.pow(this.motionZ, 2.0)) * 0.8) : (float)((double)ply.f_19788_ + Math.sqrt(Math.pow(this.motionX, 2.0) + Math.pow(this.motionZ, 2.0)) * 0.8);
            if (ply.m_20096_()) {
                ply.f_19789_ = 0.0f;
            } else if (this.motionY < 0.0) {
                ply.f_19789_ = (float)((double)ply.f_19789_ - this.motionY * 200.0);
            }
        }
    }

    public State pickState(LivingEntity ply, State walk, State run) {
        if (!PlayerUtil.isClientPlayer((Entity)ply)) {
            if (ply.m_20142_()) {
                return run;
            }
            return walk;
        }
        return this.getHorizontalSpeed() > (double)this.generator.variator.SPEED_TO_RUN ? run : walk;
    }

    public float getSpeedScalingRatio(LivingEntity entity) {
        this.generator.variator.RUNNING_RAMPUP_BEGIN = 0.011f;
        this.generator.variator.RUNNING_RAMPUP_END = 0.022f;
        double relativeSpeed = this.getHorizontalSpeed() + this.getMotionY() * this.getMotionY() - (double)this.generator.variator.RUNNING_RAMPUP_BEGIN;
        double maxSpeed = this.generator.variator.RUNNING_RAMPUP_END - this.generator.variator.RUNNING_RAMPUP_BEGIN;
        return (float)Mth.m_14008_((double)(relativeSpeed / maxSpeed), (double)0.0, (double)1.0);
    }
}

