/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsJsonParser;
import eu.ha3.presencefootsteps.util.MathUtil;
import java.util.Random;

public class Range {
    public float min;
    public float max;

    public Range(float value) {
        this(value, value);
    }

    public Range(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public void copy(Range from) {
        this.min = from.min;
        this.max = from.max;
    }

    public void read(String name, JsonObject json, AcousticsJsonParser context) {
        if (json.has(name + "_min")) {
            this.min = context.getPercentage(json, name + "_min");
        }
        if (json.has(name + "_max")) {
            this.max = context.getPercentage(json, name + "_max");
        }
        if (json.has(name)) {
            this.min = this.max = context.getPercentage(json, name);
        }
    }

    public float random(Random rand) {
        return MathUtil.randAB(rand, this.min, this.max);
    }

    public float on(float value) {
        return MathUtil.between(this.min, this.max, value);
    }
}

