/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.Nullable;

public class ModifiersTooltipComponent
implements TooltipComponent {
    protected static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @Override
    public void appendTooltipLines(List<Component> lines, ItemStack stack, @Nullable Player player, TooltipFlag tooltipFlag, Style style) {
        ArrayList list = Lists.newArrayList();
        ModifiersTooltipComponent.addOldStyleAttributes(list, stack, player, 0);
        for (Component component : list) {
            lines.add((Component)Component.m_237119_().m_7220_(component).m_130948_(style.m_131146_(component.m_7383_())));
        }
    }

    private static void addOldStyleAttributes(List<Component> list, ItemStack stack, @Nullable Player player, int startIndex) {
        Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> map = ModifiersTooltipComponent.getSlotToAttributeMap(stack);
        if (map.size() == 1) {
            ArrayList tmpList = Lists.newArrayList();
            ModifiersTooltipComponent.addAttributesToTooltip(tmpList, player, stack, map.values().iterator().next());
            if (!tmpList.isEmpty()) {
                if (startIndex != 0) {
                    tmpList.add(0, Component.m_237119_());
                }
                ModifiersTooltipComponent.addListToTooltip(list, tmpList, startIndex);
            }
        } else if (map.size() > 1) {
            int lastSize = 0;
            for (Map.Entry<EquipmentSlot, Multimap<Attribute, AttributeModifier>> entry : map.entrySet()) {
                ArrayList tmpList = Lists.newArrayList();
                ModifiersTooltipComponent.addAttributesToTooltip(tmpList, player, stack, entry.getValue());
                if (tmpList.isEmpty()) continue;
                if (startIndex != 0) {
                    tmpList.add(0, Component.m_237119_());
                }
                tmpList.add(1, Component.m_237115_((String)("item.modifiers." + entry.getKey().m_20751_())).m_130940_(ChatFormatting.GRAY));
                ModifiersTooltipComponent.addListToTooltip(list, tmpList, startIndex + (lastSize += tmpList.size()));
            }
        }
    }

    private static void addListToTooltip(List<Component> list, List<Component> tmpList, int startIndex) {
        if (startIndex < list.size()) {
            list.addAll(startIndex, tmpList);
        } else {
            list.addAll(tmpList);
        }
    }

    private static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> getSlotToAttributeMap(ItemStack stack) {
        HashMap map = Maps.newHashMap();
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            Multimap multimap = stack.m_41638_(equipmentslot);
            if (multimap.isEmpty()) continue;
            map.put(equipmentslot, multimap);
        }
        return map;
    }

    private static void addAttributesToTooltip(List<Component> list, @Nullable Player player, ItemStack stack, Multimap<Attribute, AttributeModifier> multimap) {
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
            double d0 = attributemodifier.m_22218_();
            boolean flag = false;
            if (player != null) {
                if (attributemodifier.m_22209_().equals(BASE_ATTACK_DAMAGE_UUID)) {
                    d0 += player.m_21172_(Attributes.f_22281_);
                    d0 += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
                    flag = true;
                } else if (attributemodifier.m_22209_().equals(BASE_ATTACK_SPEED_UUID)) {
                    d0 += player.m_21172_(Attributes.f_22283_);
                    flag = true;
                }
            }
            double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
            if (flag && d0 != 0.0 || d0 > 0.0) {
                list.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                continue;
            }
            if (!(d0 < 0.0)) continue;
            list.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
        }
    }
}

