/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import com.google.common.collect.ImmutableMap;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponent;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponents;
import fuzs.helditemtooltips.config.TooltipComponentConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.compress.utils.Lists;

public class TooltipComponentHolder {
    private static final Map<TooltipComponent, ItemStack.TooltipPart> TOOLTIP_COMPONENT_TO_PART = ImmutableMap.builder().put((Object)TooltipComponents.ENCHANTMENTS, (Object)ItemStack.TooltipPart.ENCHANTMENTS).put((Object)TooltipComponents.MODIFIERS, (Object)ItemStack.TooltipPart.MODIFIERS).put((Object)TooltipComponents.UNBREAKABLE, (Object)ItemStack.TooltipPart.UNBREAKABLE).put((Object)TooltipComponents.ADDITIONAL, (Object)ItemStack.TooltipPart.ADDITIONAL).put((Object)TooltipComponents.COLORING, (Object)ItemStack.TooltipPart.DYE).build();
    private final TooltipComponent component;
    private final TooltipComponentConfig settings;
    private List<Component> lines;
    private int maxLines = -1;

    public TooltipComponentHolder(TooltipComponent component, TooltipComponentConfig settings) {
        this.component = component;
        this.settings = settings;
    }

    public boolean include() {
        return this.settings.include;
    }

    public int ordering() {
        return this.settings.ordering;
    }

    public int priority() {
        return this.settings.priority;
    }

    public void clear() {
        this.lines = null;
    }

    public void tryRebuild(ItemStack stack, @Nullable Player player) {
        if (this.lines == null || this.component.alwaysUpdate()) {
            if (!this.settings.respectHideFlags || TooltipComponentHolder.shouldShowInTooltip(stack, this.component)) {
                ArrayList lines = Lists.newArrayList();
                TooltipFlag.Default tooltipFlag = this.settings.advancedTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
                Style style = this.settings.getStyle();
                this.component.appendTooltipLines(lines, stack, player, (TooltipFlag)tooltipFlag, style);
                lines.removeIf(component -> component.getString().isEmpty());
                this.lines = Collections.unmodifiableList(lines);
            } else {
                this.lines = List.of();
            }
        }
    }

    public int subtractLines(int maxLines) {
        this.maxLines = Math.min(this.size(), Math.max(maxLines, 0));
        return maxLines - this.size();
    }

    public List<Component> getLines() {
        Objects.requireNonNull(this.lines, "lines is null");
        return this.lines.subList(0, this.maxLines);
    }

    public int size() {
        Objects.requireNonNull(this.lines, "lines is null");
        return this.lines.size();
    }

    private static boolean shouldShowInTooltip(ItemStack stack, TooltipComponent component) {
        if (!TOOLTIP_COMPONENT_TO_PART.containsKey(component)) {
            return true;
        }
        int hideFlags = stack.m_41782_() && stack.m_41783_().m_128425_("HideFlags", 99) ? stack.m_41783_().m_128451_("HideFlags") : 0;
        return (hideFlags & TOOLTIP_COMPONENT_TO_PART.get(component).m_41809_()) == 0;
    }
}

