/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.helditemtooltips.HeldItemTooltips;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.HoverTextManager;
import fuzs.helditemtooltips.config.ClientConfig;
import fuzs.helditemtooltips.mixin.client.accessor.GuiAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SelectedItemHandler {
    public static final SelectedItemHandler INSTANCE = new SelectedItemHandler();
    private int remainingHighlightTicks;
    private ItemStack highlightingItemStack = ItemStack.f_41583_;
    private int maxLines;

    public void onClientTick$End(Minecraft minecraft) {
        if (minecraft.f_91074_ == null || minecraft.m_91104_()) {
            return;
        }
        ItemStack stack = minecraft.f_91074_.m_150109_().m_36056_();
        if (!this.highlightingItemStack.m_41619_() && stack.m_41656_(this.highlightingItemStack) && stack.m_41786_().equals(this.highlightingItemStack.m_41786_())) {
            if (this.highlightingItemStack != stack) {
                this.highlightingItemStack = stack;
                HoverTextManager.reset();
            }
            if (this.remainingHighlightTicks > 0) {
                --this.remainingHighlightTicks;
            }
        } else {
            this.highlightingItemStack = stack;
            if (this.highlightingItemStack.m_41619_()) {
                this.remainingHighlightTicks = 0;
            } else {
                this.remainingHighlightTicks = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayTime;
                HoverTextManager.reset();
            }
        }
    }

    public void onRenderGuiOverlay$ItemName(PoseStack poseStack, int width, int height) {
        int alpha;
        if (this.highlightingItemStack.m_41619_()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91307_().m_6180_("selectedItemName");
        int n = alpha = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayTime == 0 ? 255 : (int)Math.min(255.0f, (float)this.remainingHighlightTicks * 255.0f / 10.0f);
        if (alpha <= 0) {
            return;
        }
        List<Component> lines = this.getTooltipLines(minecraft);
        float currentScale = (float)((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayScale / 6.0f;
        int posX = this.getPosX(currentScale, width);
        int posY = this.getPosY(currentScale, height, lines.size(), minecraft);
        Font fontRenderer = minecraft.f_91062_;
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        poseStack.m_85841_(currentScale, currentScale, 1.0f);
        this.drawBackground(poseStack, posX, posY, alpha, lines, minecraft);
        for (int i = 0; i < lines.size(); ++i) {
            int n2;
            Component component = lines.get(i);
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)fontRenderer, (Component)component, (int)posX, (int)posY, (int)(0xFFFFFF + (alpha << 24)));
            if (i == 0) {
                Objects.requireNonNull(fontRenderer);
                n2 = 9 + 3;
            } else {
                Objects.requireNonNull(fontRenderer);
                n2 = 9 + 1;
            }
            posY += n2;
        }
        poseStack.m_85841_(1.0f / currentScale, 1.0f / currentScale, 1.0f);
        RenderSystem.m_69461_();
        poseStack.m_85849_();
        minecraft.m_91307_().m_7238_();
    }

    private int getPosX(float currentScale, int screenWidth) {
        int posX = (int)((float)screenWidth / (2.0f * currentScale));
        return posX += ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).offsetX;
    }

    private int getPosY(float currentScale, int screenHeight, int allLines, Minecraft minecraft) {
        int posY = (int)((float)screenHeight / currentScale);
        posY = (int)((float)posY - (float)((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).offsetY / currentScale);
        if (!minecraft.f_91072_.m_105205_()) {
            posY += 14;
        }
        return posY -= allLines > 1 ? (allLines - 1) * 10 + 2 : (allLines - 1) * 10;
    }

    private List<Component> getTooltipLines(Minecraft minecraft) {
        int maxLines;
        ClientConfig clientConfig = (ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class);
        if (clientConfig.itemBlacklist.contains((Object)this.highlightingItemStack.m_41720_())) {
            maxLines = 1;
        } else {
            int overlayMessageTime = ((GuiAccessor)minecraft.f_91065_).helditemtooltips$getOverlayMessageTime();
            int n = overlayMessageTime > 0 ? (minecraft.f_91072_.m_105205_() ? 1 : 2) : (maxLines = clientConfig.maxLines);
        }
        if ((clientConfig.displayTime - this.remainingHighlightTicks) % clientConfig.updateInterval == 0 || this.maxLines != maxLines) {
            HoverTextManager.reset();
        }
        this.maxLines = maxLines;
        return HoverTextManager.getTooltipLines(this.highlightingItemStack, (Player)minecraft.f_91074_, this.maxLines);
    }

    private void drawBackground(PoseStack poseStack, int posX, int posY, int alpha, List<Component> lines, Minecraft minecraft) {
        ClientConfig.HoverTextBackground background = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).background;
        Font font = minecraft.f_91062_;
        alpha = (int)((double)alpha * (Double)minecraft.f_91066_.m_232104_().m_231551_());
        if (background == ClientConfig.HoverTextBackground.RECTANGLE) {
            int maximumWidth = lines.stream().mapToInt(arg_0 -> ((Font)font).m_92852_(arg_0)).max().orElse(0) / 2;
            int size = lines.size();
            Objects.requireNonNull(font);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(posX - maximumWidth - 2), (int)(posY - 2), (int)(posX + maximumWidth + 2), (int)(posY + size * (9 + 1) + (size > 1 ? 1 : -1) + 2), (int)(alpha << 24));
        } else if (background == ClientConfig.HoverTextBackground.ADAPTIVE) {
            for (int i = 0; i < lines.size(); ++i) {
                int n;
                int top;
                int previousWidth = SelectedItemHandler.textWidth(font, lines, i - 1) / 2;
                int currentWidth = SelectedItemHandler.textWidth(font, lines, i) / 2;
                int nextWidth = SelectedItemHandler.textWidth(font, lines, i + 1) / 2;
                int n2 = currentWidth < previousWidth ? (i == 1 ? 1 : -1) : (top = 2);
                int bottom = currentWidth <= nextWidth ? (i == 0 ? 1 : -1) : 2;
                Objects.requireNonNull(font);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(posX - currentWidth - 2), (int)(posY - top), (int)(posX + currentWidth + 2), (int)(posY + 9 + bottom), (int)(alpha << 24));
                if (i == 0) {
                    Objects.requireNonNull(font);
                    n = 9 + 3;
                } else {
                    Objects.requireNonNull(font);
                    n = 9 + 1;
                }
                posY += n;
            }
        }
    }

    private static int textWidth(Font font, List<Component> lines, int index) {
        int clampedIndex = Mth.m_14045_((int)index, (int)0, (int)(lines.size() - 1));
        return clampedIndex == index ? font.m_92852_((FormattedText)lines.get(index)) : 0;
    }
}

