/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public class ShulkerHoverTextUtil {
    public static void appendHoverText(List<Component> lines, ItemStack stack, int rows, boolean lastLine) {
        if (rows == 0) {
            return;
        }
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag == null) {
            return;
        }
        ShulkerHoverTextUtil.appendEmptyText(lines, tag);
        List<ItemStack> contents = ShulkerHoverTextUtil.loadAllItems(tag);
        if (contents.size() > rows && rows != -1) {
            for (ItemStack itemstack : contents.subList(0, rows - 1)) {
                MutableComponent component = itemstack.m_41786_().m_6881_();
                lines.add((Component)component.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_())));
            }
            if (lastLine) {
                lines.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{contents.size() - rows + 1}).m_130940_(ChatFormatting.ITALIC));
            }
        } else {
            for (ItemStack content : contents) {
                MutableComponent component = content.m_41786_().m_6881_();
                component.m_130946_(" x").m_130946_(String.valueOf(content.m_41613_()));
                lines.add((Component)component);
            }
        }
    }

    private static void appendEmptyText(List<Component> lines, CompoundTag tag) {
        if (tag.m_128425_("LootTable", 8)) {
            lines.add((Component)Component.m_237113_((String)"???????"));
        }
    }

    private static List<ItemStack> loadAllItems(CompoundTag tag) {
        if (tag.m_128425_("Items", 9)) {
            NonNullList nonnulllist = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)nonnulllist);
            return ShulkerHoverTextUtil.mergeSameItems((List<ItemStack>)nonnulllist);
        }
        return Lists.newArrayList();
    }

    private static List<ItemStack> mergeSameItems(List<ItemStack> items) {
        ArrayList contents = Lists.newArrayList();
        for (ItemStack current : items) {
            if (contents.stream().anyMatch(it -> ItemStack.m_41746_((ItemStack)it, (ItemStack)current))) {
                contents.forEach(stack -> {
                    if (ItemStack.m_41746_((ItemStack)stack, (ItemStack)current)) {
                        stack.m_41764_(stack.m_41613_() + current.m_41613_());
                    }
                });
                continue;
            }
            if (current.m_41619_()) continue;
            contents.add(current);
        }
        return contents;
    }
}

