/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.config;

import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.annotation.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class TooltipComponentConfig
implements ConfigCore {
    @Config(description={"Should this tooltip component be included when rendering held item tooltips."})
    public boolean include;
    @Config(description={"The order in which this tooltip component appears in relation to other components. Smaller values appear first."})
    public int ordering;
    @Config(description={"Priority for rendering this tooltip. When not enough lines are available (like an item with enchantments), components with a low priority will be skipped."})
    public int priority;
    @Config(description={"Represent information for this component as if advanced tooltips were enabled independently of the actual setting."})
    public boolean advancedTooltips;
    @Config(description={"Should this tooltip component be hidden when vanilla's respective \"HideFlags\" property is set."})
    public boolean respectHideFlags = true;
    @Config(description={"Text formatting settings for this component's text appearance."})
    private final FormattingConfig formatting;

    public static TooltipComponentConfig simple(boolean include, int ordering, int priority) {
        return TooltipComponentConfig.simple(include, ordering, priority, null);
    }

    public static TooltipComponentConfig simple(boolean include, int ordering, int priority, @Nullable ChatFormatting textColor) {
        return new TooltipComponentConfig(include, ordering, priority, false, textColor);
    }

    public static TooltipComponentConfig advanced(boolean include, int ordering, int priority) {
        return new TooltipComponentConfig(include, ordering, priority, true, null);
    }

    private TooltipComponentConfig(boolean include, int ordering, int priority, boolean advancedTooltips, @Nullable ChatFormatting textColor) {
        this.include = include;
        this.ordering = ordering;
        this.priority = priority;
        this.advancedTooltips = advancedTooltips;
        this.formatting = new FormattingConfig(textColor);
    }

    public Style getStyle() {
        return FormattingConfig.toStyle(this.formatting);
    }

    private static class FormattingConfig
    implements ConfigCore {
        private static final String DEFAULT_FORMATTING = "default";
        @Config(name="text_color", description={"The color of this component's text."})
        @Config.AllowedValues(values={"default", "black", "dark_blue", "dark_green", "dark_aqua", "dark_red", "dark_purple", "gold", "gray", "dark_gray", "blue", "green", "aqua", "red", "light_purple", "yellow", "white"})
        String textColorRaw;
        @Config(description={"Should the text in this component be replaced by random characters."})
        public boolean obfuscated;
        @Config(description={"Should the text in this component appear bold."})
        public boolean bold;
        @Config(description={"Should the text in this component appear struck-through."})
        public boolean strikethrough;
        @Config(description={"Should the text in this component appear with an underline."})
        public boolean underline;
        @Config(description={"Should the text in this component appear italic."})
        public boolean italic;
        @Nullable
        public ChatFormatting textColor;

        public FormattingConfig(@Nullable ChatFormatting textColor) {
            this.textColorRaw = textColor == null ? DEFAULT_FORMATTING : textColor.m_7912_();
        }

        public void afterConfigReload() {
            this.textColor = ChatFormatting.m_126657_((String)this.textColorRaw);
        }

        public static Style toStyle(FormattingConfig formatting) {
            Style style = Style.f_131099_;
            if (formatting.textColor != null) {
                style = style.m_131140_(formatting.textColor);
            }
            if (formatting.obfuscated) {
                style = style.m_178524_(Boolean.valueOf(true));
            }
            if (formatting.bold) {
                style = style.m_131136_(Boolean.valueOf(true));
            }
            if (formatting.strikethrough) {
                style = style.m_178522_(Boolean.valueOf(true));
            }
            if (formatting.underline) {
                style = style.m_131162_(Boolean.valueOf(true));
            }
            if (formatting.italic) {
                style = style.m_131155_(Boolean.valueOf(true));
            }
            return style;
        }
    }
}

