/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.customstars.mixin;

import com.bespectacled.customstars.CustomStars;
import com.bespectacled.customstars.config.CustomStarsConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientLevel {
    @Unique
    private static final CustomStarsConfig STARS_CONFIG = CustomStars.STARS_CONFIG;
    @Unique
    private float customStarsSkyAngle;

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")})
    private void injectGetSkyColor(Vec3 pos, float tickDelta, CallbackInfoReturnable<Vec3> info) {
        this.customStarsSkyAngle = ((LevelTimeAccess)this).m_46942_(tickDelta);
        this.customStarsSkyAngle = Mth.m_14089_((float)(this.customStarsSkyAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        this.customStarsSkyAngle = Mth.m_14036_((float)this.customStarsSkyAngle, (float)0.0f, (float)1.0f);
    }

    @ModifyVariable(method={"getSkyColor"}, at=@At(value="STORE"), ordinal=3)
    private float injectSkyR(float r) {
        float nightSkyR = MixinClientLevel.STARS_CONFIG.skyColor.normalR();
        return r + (nightSkyR *= 1.0f - this.customStarsSkyAngle);
    }

    @ModifyVariable(method={"getSkyColor"}, at=@At(value="STORE"), ordinal=4)
    private float injectSkyG(float g) {
        float nightSkyG = MixinClientLevel.STARS_CONFIG.skyColor.normalG();
        return g + (nightSkyG *= 1.0f - this.customStarsSkyAngle);
    }

    @ModifyVariable(method={"getSkyColor"}, at=@At(value="STORE"), ordinal=5)
    private float injectSkyB(float b) {
        float nightSkyB = MixinClientLevel.STARS_CONFIG.skyColor.normalB();
        return b + (nightSkyB *= 1.0f - this.customStarsSkyAngle);
    }
}

