/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.customstars.mixin;

import com.bespectacled.customstars.CustomStars;
import com.bespectacled.customstars.config.CustomStarsConfig;
import com.bespectacled.customstars.sky.SkyHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelRenderer.class}, priority=1)
public abstract class MixinWorldRenderer {
    @Unique
    private static final CustomStarsConfig STARS_CONFIG = CustomStars.STARS_CONFIG;
    @Shadow
    private VertexBuffer f_109471_;

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderColor(FFFF)V", ordinal=3))
    private void modifyStarColor(float r, float g, float b, float a) {
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)(a * MixinWorldRenderer.STARS_CONFIG.starBrightness));
    }

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;getPositionShader()Lnet/minecraft/client/renderer/ShaderInstance;"))
    private ShaderInstance modifyStarDraw(PoseStack matrices, Matrix4f projectionMatrix, float tickDelta, Camera arg3, boolean bl, Runnable runnable) {
        return GameRenderer.m_172811_();
    }

    @Inject(method={"renderSky"}, at={@At(value="HEAD")})
    private void reloadStars(CallbackInfo info) {
        if (CustomStars.shouldReloadStars()) {
            CustomStars.LOGGER.info("Settings modified, reloading sky buffer...");
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder builder = tess.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            this.f_109471_ = new VertexBuffer();
            BufferBuilder.RenderedBuffer builtBuffer = SkyHelper.renderCustomStars(builder);
            this.f_109471_.m_85921_();
            this.f_109471_.m_231221_(builtBuffer);
            VertexBuffer.m_85931_();
        }
    }

    @Inject(method={"drawStars"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectRenderStars(BufferBuilder builder, CallbackInfoReturnable<BufferBuilder.RenderedBuffer> info) {
        BufferBuilder.RenderedBuffer builtBuffer = SkyHelper.renderCustomStars(builder);
        info.setReturnValue((Object)builtBuffer);
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V", ordinal=1)})
    private void injectMoonColor(CallbackInfo info) {
        CustomStarsConfig.ColorRGBA color = MixinWorldRenderer.STARS_CONFIG.moonColor;
        RenderSystem.m_157429_((float)color.normalR(), (float)color.normalG(), (float)color.normalB(), (float)color.alpha);
    }

    @Redirect(method={"renderEndSky"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;color(IIII)Lcom/mojang/blaze3d/vertex/VertexConsumer;"))
    private VertexConsumer modifyEndSkyColor(VertexConsumer self, int r, int g, int b, int a) {
        CustomStarsConfig.ColorRGBA color = MixinWorldRenderer.STARS_CONFIG.endColor;
        return self.m_6122_(color.red, color.green, color.blue, (int)(255.0f * color.alpha));
    }

    @ModifyConstant(method={"renderEndSky"}, constant={@Constant(floatValue=16.0f)})
    private float modifyTextureSize(float size) {
        return size * MixinWorldRenderer.STARS_CONFIG.endSize;
    }
}

