/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.customstars.noise;

import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class OctaveSimplexNoise {
    private final SimplexNoise[] generators;
    private final int octaves;

    public OctaveSimplexNoise(RandomSource random, int octaves) {
        this.octaves = octaves;
        this.generators = new SimplexNoise[octaves];
        for (int i = 0; i < octaves; ++i) {
            this.generators[i] = new SimplexNoise(random);
        }
    }

    public double sample(double x, double y, double z) {
        double total = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        double persistence = 0.5;
        double lacunarity = 2.0;
        for (int i = 0; i < this.octaves; ++i) {
            total += this.generators[i].m_75467_(x * frequency, y * frequency, z * frequency) * amplitude;
            amplitude *= persistence;
            frequency *= lacunarity;
        }
        return total;
    }
}

