/*
 * Decompiled with CFR 0.152.
 */
package com.bespectacled.customstars.sky;

import com.bespectacled.customstars.CustomStars;
import com.bespectacled.customstars.color.StarColorPicker;
import com.bespectacled.customstars.config.CustomStarsConfig;
import com.bespectacled.customstars.noise.OctaveSimplexNoise;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public class SkyHelper {
    public static BufferBuilder.RenderedBuffer renderCustomStars(BufferBuilder buffer) {
        int starCount = CustomStars.STARS_CONFIG.starCount;
        float baseSize = CustomStars.STARS_CONFIG.baseSize;
        float sizeModifier = CustomStars.STARS_CONFIG.maxSizeMultiplier;
        long seed = CustomStars.STARS_CONFIG.starNoiseSeed;
        int noisePercentage = CustomStars.STARS_CONFIG.starNoisePercentage;
        double noiseThreshold = CustomStars.STARS_CONFIG.starNoiseThreshold;
        Random random = new Random(10842L);
        double[] ipts = new double[starCount];
        double[] jpts = new double[starCount];
        double[] kpts = new double[starCount];
        XoroshiroRandomSource fieldRandom = new XoroshiroRandomSource(seed);
        OctaveSimplexNoise fieldSampler = new OctaveSimplexNoise((RandomSource)fieldRandom, 3);
        if (noiseThreshold > 1.0) {
            noiseThreshold = 1.0;
        }
        int stars = 0;
        if (CustomStars.STARS_CONFIG.starNoise) {
            int noiseStarCount = (int)Math.floor((double)(starCount * noisePercentage) / 100.0);
            while (stars < noiseStarCount) {
                double fuzzWeight;
                double fuzz;
                double k;
                double j;
                double i = fieldRandom.m_188501_() * 2.0f - 1.0f;
                double weight = fieldSampler.sample(i, j = (double)(fieldRandom.m_188501_() * 2.0f - 1.0f), k = (double)(fieldRandom.m_188501_() * 2.0f - 1.0f));
                if (!(weight + (fuzz = (fieldRandom.m_188500_() - 0.5) * 3.0) * (fuzzWeight = CustomStars.STARS_CONFIG.starNoiseFuzzWeight) > noiseThreshold)) continue;
                ipts[stars] = i;
                jpts[stars] = j;
                kpts[stars] = k;
                ++stars;
            }
        }
        while (stars < starCount) {
            ipts[stars] = random.nextFloat() * 2.0f - 1.0f;
            jpts[stars] = random.nextFloat() * 2.0f - 1.0f;
            kpts[stars] = random.nextFloat() * 2.0f - 1.0f;
            ++stars;
        }
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        double[] xCoords = new double[4];
        double[] yCoords = new double[4];
        double[] zCoords = new double[4];
        for (int i = 0; i < starCount; ++i) {
            int v;
            double double5 = ipts[i];
            double double7 = jpts[i];
            double double9 = kpts[i];
            double double11 = baseSize + random.nextFloat() * sizeModifier;
            double double13 = double5 * double5 + double7 * double7 + double9 * double9;
            if (!(double13 < 1.0) || !(double13 > 0.01)) continue;
            double13 = 1.0 / Math.sqrt(double13);
            double double15 = (double5 *= double13) * 100.0;
            double double17 = (double7 *= double13) * 100.0;
            double double19 = (double9 *= double13) * 100.0;
            double double21 = Math.atan2(double5, double9);
            double double23 = Math.sin(double21);
            double double25 = Math.cos(double21);
            double double27 = Math.atan2(Math.sqrt(double5 * double5 + double9 * double9), double7);
            double double29 = Math.sin(double27);
            double double31 = Math.cos(double27);
            double double33 = random.nextDouble() * Math.PI * 2.0;
            double double35 = Math.sin(double33);
            double double37 = Math.cos(double33);
            CustomStarsConfig.ColorRGBA starColor = StarColorPicker.nextColor(random);
            float r = (float)starColor.red / 255.0f;
            float g = (float)starColor.green / 255.0f;
            float b = (float)starColor.blue / 255.0f;
            float a = starColor.alpha;
            boolean inMoon = false;
            for (v = 0; v < 4; ++v) {
                double double42 = (double)((v & 2) - 1) * double11;
                double double44 = (double)((v + 1 & 2) - 1) * double11;
                double double48 = double42 * double37 - double44 * double35;
                double double52 = double44 * double37 + double42 * double35;
                double double54 = double48 * double29 + 0.0 * double31;
                double double56 = 0.0 * double29 - double48 * double31;
                double double58 = double56 * double23 - double52 * double25;
                double double60 = double54;
                double double62 = double52 * double23 + double56 * double25;
                double x = double15 + double58;
                double y = double17 + double60;
                double z = double19 + double62;
                if (SkyHelper.inMoon(x, z)) {
                    inMoon = true;
                    break;
                }
                xCoords[v] = x;
                yCoords[v] = y;
                zCoords[v] = z;
            }
            if (inMoon) continue;
            for (v = 0; v < 4; ++v) {
                double x = xCoords[v];
                double y = yCoords[v];
                double z = zCoords[v];
                buffer.m_5483_(x, y, z).m_85950_(r, g, b, a).m_5752_();
            }
        }
        return buffer.m_231175_();
    }

    private static boolean inMoon(double x, double z) {
        double size = CustomStars.STARS_CONFIG.moonDeadzoneSize;
        if (!CustomStars.STARS_CONFIG.moonDeadzone) {
            return false;
        }
        return CustomStars.STARS_CONFIG.moonDeadzoneShape.test(x, z, size);
    }
}

