/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks;

import com.ordana.spelunkery.utils.LevelHelper;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class PortalFluidCauldronBlock
extends AbstractCauldronBlock {
    public static final int MIN_FILL_LEVEL = 1;
    public static final int MAX_FILL_LEVEL = 3;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61418_;
    private static final int BASE_CONTENT_HEIGHT = 6;
    private static final double HEIGHT_PER_LEVEL = 3.0;

    public PortalFluidCauldronBlock(BlockBehaviour.Properties properties, Map<Item, CauldronInteraction> map) {
        super(properties, map);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    protected double m_142446_(BlockState state) {
        return (6.0 + (double)((Integer)state.m_61143_((Property)LEVEL)).intValue() * 3.0) / 16.0;
    }

    public boolean m_142596_(BlockState state) {
        return (Integer)state.m_61143_((Property)LEVEL) == 3;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (this.m_151979_(state, pos, entity) && !entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                LevelHelper.teleportToSpawnPosition(player);
                this.handleEntityTeleport(state, level, pos);
            } else {
                LevelHelper.teleportToWorldspawn(level, entity);
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11757_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected boolean m_142087_(Fluid fluid) {
        return fluid == Fluids.f_76193_;
    }

    protected void handleEntityTeleport(BlockState state, Level level, BlockPos pos) {
        PortalFluidCauldronBlock.lowerFillLevel(state, level, pos);
    }

    public static void lowerFillLevel(BlockState state, Level level, BlockPos pos) {
        int i = (Integer)state.m_61143_((Property)LEVEL) - 1;
        BlockState blockState = i == 0 ? Blocks.f_50256_.m_49966_() : (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(i));
        level.m_46597_(pos, blockState);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockState));
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LEVEL);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL});
    }

    protected void m_142310_(BlockState state, Level level, BlockPos pos, Fluid fluid) {
        if (!this.m_142596_(state)) {
            BlockState blockState = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LEVEL) + 1));
            level.m_46597_(pos, blockState);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockState));
            level.m_46796_(1047, pos, 0);
        }
    }
}

