/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks;

import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RopeLadderBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final int TICK_DELAY = 1;
    private static final VoxelShape BELOW_BLOCK = Shapes.m_83144_().m_83216_(0.0, -1.0, 0.0);
    public static final DirectionProperty FACING;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty TOP;
    public static final BooleanProperty END;
    protected static final float AABB_OFFSET = 3.0f;
    protected static final VoxelShape EAST_AABB;
    protected static final VoxelShape WEST_AABB;
    protected static final VoxelShape SOUTH_AABB;
    protected static final VoxelShape NORTH_AABB;

    public RopeLadderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)END, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, TOP, END, FACING});
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_43722_().m_150930_(this.m_5456_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] directions;
        BlockPos blockPos = context.m_8083_();
        BlockState aboveState = context.m_43725_().m_8055_(blockPos.m_7494_());
        Level levelReader = context.m_43725_();
        BlockState blockState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TOP, (Comparable)Boolean.valueOf(this.isTop((BlockGetter)levelReader, blockPos)))).m_61124_((Property)END, (Comparable)Boolean.valueOf(this.isEnd((BlockGetter)levelReader, blockPos)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelReader.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
        Direction[] var6 = directions = context.m_6232_();
        int var7 = directions.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction direction2;
            Direction direction = var6[var8];
            if (!direction.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(direction2 = direction.m_122424_()))).m_60710_((LevelReader)levelReader, blockPos)) continue;
            if (((Boolean)blockState.m_61143_((Property)TOP)).booleanValue()) {
                return blockState;
            }
            if (!(aboveState.m_60734_() instanceof RopeLadderBlock)) continue;
            return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)((Direction)aboveState.m_61143_((Property)FACING)));
        }
        return null;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (!level.m_5776_()) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            default -> EAST_AABB;
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockState = (BlockState)((BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(this.isTop((BlockGetter)level, pos)))).m_61124_((Property)END, (Comparable)Boolean.valueOf(this.isEnd((BlockGetter)level, pos)));
        if (!((Boolean)state.m_61143_((Property)TOP)).booleanValue() && !level.m_8055_(pos.m_7494_()).m_60713_((Block)this)) {
            level.m_46961_(pos, true);
        } else if (state != blockState) {
            level.m_7731_(pos, blockState, 3);
        }
    }

    private boolean canAttachTo(BlockGetter blockReader, BlockPos pos, Direction direction) {
        BlockState blockState = blockReader.m_8055_(pos);
        return blockState.m_60783_(blockReader, pos, direction);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)level, pos.m_121945_(direction.m_122424_()), direction) || level.m_8055_(pos.m_7494_()).m_60713_((Block)this);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    private boolean isTop(BlockGetter level, BlockPos pos) {
        return !level.m_8055_(pos.m_7494_()).m_60713_((Block)this);
    }

    private boolean isEnd(BlockGetter level, BlockPos pos) {
        return !level.m_8055_(pos.m_7495_()).m_60713_((Block)this) && !this.isTop(level, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.isTop((BlockGetter)level, pos) && player.m_6047_()) {
            for (int i = 0; i < 32; ++i) {
                BlockState belowState = level.m_8055_(pos.m_6625_(i + 1));
                if (belowState.m_60713_((Block)this)) continue;
                level.m_46961_(pos.m_6625_(i), false);
                if (player.m_7500_()) break;
                player.m_36356_(new ItemStack((ItemLike)ModItems.ROPE_LADDER.get()));
                break;
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    static {
        WATERLOGGED = BlockStateProperties.f_61362_;
        TOP = ModBlockProperties.TOP;
        END = ModBlockProperties.END;
        FACING = HorizontalDirectionalBlock.f_54117_;
        EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
        WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

