/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModGameEvents;
import com.ordana.spelunkery.utils.TranslationUtils;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MagneticCompassItem
extends Item
implements Vanishable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_LODESTONE_POS = "LodestonePos";
    public static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    public static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";
    private int tickCounter = 0;

    public MagneticCompassItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@NotNull ItemStack stack, @javax.annotation.Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            CompoundTag compoundTag = stack.m_41784_();
            tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.player_pos", (Object[])new Object[]{this.getPlayerX(stack), this.getPlayerZ(stack)}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_GREEN)));
            if (compoundTag.m_128441_("magnetitePos")) {
                BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("magnetitePos"));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.magnetite_pos", (Object[])new Object[]{blockPos.m_123341_(), blockPos.m_123343_()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_GREEN)));
            }
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.magnetic_compass_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.magnetic_compass_3").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)TranslationUtils.MAGNETIC_COMPASS_4.component());
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    public void setPlayerX(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_("ex", amount);
    }

    public int getPlayerX(ItemStack stack) {
        return stack.m_41784_().m_128451_("ex");
    }

    public void setPlayerZ(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_("zed", amount);
    }

    public int getPlayerZ(ItemStack stack) {
        return stack.m_41784_().m_128451_("zed");
    }

    @PlatformOnly(value={"forge"})
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag compoundTag = stack.m_41784_();
        if (compoundTag.m_128441_("magnetitePos")) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("magnetitePos"));
            player.m_5661_((Component)Component.m_237110_((String)"tooltip.spelunkery.magnetite_pos", (Object[])new Object[]{blockPos.m_123341_(), blockPos.m_123343_()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_GREEN)), true);
        } else {
            player.m_5661_((Component)Component.m_237110_((String)"tooltip.spelunkery.player_pos", (Object[])new Object[]{this.getPlayerX(stack), this.getPlayerZ(stack)}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_GREEN)), true);
        }
        if (player.m_36341_()) {
            compoundTag.m_128473_("magnetitePos");
            level.m_142346_((Entity)player, ModGameEvents.COMPASS_PING_EVENT.get(), player.m_20183_());
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private static Optional<ResourceKey<Level>> getDimension(CompoundTag compoundTag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_("magnetiteDimension")).result();
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_()) {
            BlockPos blockPos;
            Optional<ResourceKey<Level>> optional;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                this.setPlayerX(stack, player.m_146903_());
                this.setPlayerZ(stack, player.m_146907_());
            }
            CompoundTag compoundTag = stack.m_41784_();
            ++this.tickCounter;
            if (this.tickCounter == 100) {
                if (!compoundTag.m_128441_("magnetitePos")) {
                    level.m_142346_(entity, ModGameEvents.COMPASS_PING_EVENT.get(), entity.m_20183_());
                }
                this.setTickCounter(0);
            }
            if ((optional = MagneticCompassItem.getDimension(compoundTag)).isPresent() && optional.get() == level.m_46472_() && compoundTag.m_128441_("magnetitePos") && (!level.m_46739_(blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("magnetitePos"))) || !level.m_8055_(blockPos).m_60713_(ModBlocks.MAGNETITE.get()))) {
                compoundTag.m_128473_("magnetitePos");
                level.m_142346_(entity, ModGameEvents.COMPASS_PING_EVENT.get(), entity.m_20183_());
            }
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return MagneticCompassItem.isMagnetiteNearby(stack) || super.m_5812_(stack);
    }

    public static void addMagnetiteTags(ResourceKey<Level> lodestoneDimension, BlockPos pos, CompoundTag compoundTag) {
        if (!compoundTag.m_128441_("magnetitePos")) {
            compoundTag.m_128365_("magnetitePos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        }
        DataResult var10000 = Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, lodestoneDimension);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_("magnetiteDimension", tag));
    }

    public static boolean isMagnetiteNearby(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        return compoundTag != null && compoundTag.m_128441_("magnetitePos");
    }

    @Nullable
    public static GlobalPos getNorthPosition(Level level) {
        return level.m_6042_().f_63858_() ? GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)new BlockPos(0, 0, -10000000)) : null;
    }

    @Nullable
    public static GlobalPos getMagnetitePos(CompoundTag compoundTag) {
        Optional<ResourceKey<Level>> optional;
        boolean bl = compoundTag.m_128441_("magnetitePos");
        boolean bl2 = compoundTag.m_128441_("magnetiteDimension");
        if (bl && bl2 && (optional = MagneticCompassItem.getDimension(compoundTag)).isPresent()) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("magnetitePos"));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockPos);
        }
        return null;
    }
}

