/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.utils.EnchantmentUtils;
import com.ordana.spelunkery.utils.TranslationUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class NephriteCharmItem
extends Item {
    public NephriteCharmItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.nephrite_charm_1", (Object[])new Object[]{this.getStoredXP(stack), "1395"}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_GREEN)));
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.nephrite_charm_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)TranslationUtils.NEPHRITE_CHARM_3.component());
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return this.getStoredXP(stack) == 1395;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int storedXP = this.getStoredXP(stack);
        if (level instanceof ServerLevel) {
            if (player.m_6047_()) {
                if (storedXP < 1395 && storedXP >= 0 && (player.f_36079_ > 0 || player.f_36079_ == 0 && player.f_36078_ > 0)) {
                    int totalXp = EnchantmentUtils.getPlayerXP(player);
                    if (totalXp == 0) {
                        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
                    }
                    int actuallyStored = this.addXP(stack, totalXp);
                    if (actuallyStored > 0) {
                        EnchantmentUtils.addPlayerXP(player, -actuallyStored);
                    }
                    float f = level.f_46441_.m_188501_();
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.BLOCKS, f * 0.9f, (f + 1.0f) / 2.0f - 0.3f);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
                }
            } else if (!player.m_6047_() && storedXP > 0 && storedXP <= 1395) {
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)level), (Vec3)player.m_20182_(), (int)storedXP);
                this.setStoredXP(stack, 0);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public int addXP(ItemStack stack, int amount) {
        int maxStorage;
        if (amount <= 0) {
            return 0;
        }
        int stored = this.getStoredXP(stack);
        if (stored >= (maxStorage = 1395)) {
            return 0;
        }
        if (stored + amount <= maxStorage) {
            this.setStoredXP(stack, stored + amount);
            return amount;
        }
        this.setStoredXP(stack, maxStorage);
        return maxStorage - stored;
    }

    public void setStoredXP(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_("xp", amount);
    }

    public int getStoredXP(ItemStack stack) {
        return stack.m_41784_().m_128451_("xp");
    }
}

