/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModTags;
import com.ordana.spelunkery.utils.IParachuteEntity;
import com.ordana.spelunkery.utils.TranslationUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.misc.DualWeildState;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ParachuteItem
extends Item
implements IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    private int tickCounter = 0;
    private boolean sound1 = false;
    private boolean sound2 = false;
    private boolean sound3 = false;

    public ParachuteItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getParachute(LivingEntity entity) {
        if (!(entity instanceof Player) && entity instanceof IParachuteEntity) {
            IParachuteEntity e = (IParachuteEntity)entity;
            return e.getParachute();
        }
        if (entity instanceof Player) {
            Player p = (Player)entity;
            for (ItemStack s : p.m_150109_().f_35974_) {
                if (s.m_41720_() != ModItems.PARACHUTE.get()) continue;
                return s;
            }
        }
        return ItemStack.f_41583_;
    }

    public static void set3DModel(ItemStack stack, boolean model) {
        stack.m_41784_().m_128379_("model", model);
    }

    public void setUsed(ItemStack stack, boolean used) {
        stack.m_41784_().m_128379_("used", used);
    }

    public boolean getUsed(ItemStack stack) {
        return stack.m_41784_().m_128471_("used");
    }

    public void setActive(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_("active", active);
    }

    public static boolean getActive(ItemStack stack) {
        return stack.m_41784_().m_128471_("active");
    }

    public void setTickCounter(int tick) {
        this.tickCounter = tick;
    }

    public boolean m_6832_(ItemStack stack, @NotNull ItemStack repairCandidate) {
        return repairCandidate.m_204117_(ModTags.PARACHUE_REPAIR);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.parachute_1").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.parachute_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.parachute_3").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level instanceof ServerLevel) {
            if (player.m_6144_() && this.getUsed(stack)) {
                ItemStack itemStack = player.m_21120_(hand);
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)itemStack);
            }
            if (!player.m_6144_() && !this.getUsed(stack) && !ParachuteItem.getActive(stack) && player.m_20075_().m_60795_()) {
                this.setActive(stack, true);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (!level.f_46443_) {
            SoundEvent soundEvent = SoundEvents.f_12087_;
            SoundEvent soundEvent2 = SoundEvents.f_11842_;
            float f = (float)(stack.m_41779_() - remainingUseDuration) / 20.0f;
            if (f < 0.2f) {
                this.sound1 = false;
                this.sound2 = false;
                this.sound3 = false;
            }
            if (f >= 0.5f && !this.sound1) {
                this.sound1 = true;
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), soundEvent, SoundSource.PLAYERS, 0.5f, 0.2f);
            }
            if (f >= 1.5f && soundEvent2 != null && !this.sound2) {
                this.sound2 = true;
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), soundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 2.5f && soundEvent2 != null && !this.sound3) {
                this.sound3 = true;
                level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), soundEvent, SoundSource.PLAYERS, 0.5f, 2.0f);
            }
            if (f > 2.5f) {
                livingEntity.m_21253_();
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        int i;
        if (livingEntity instanceof Player && (i = this.m_8105_(stack) - timeCharged) >= 50) {
            this.setUsed(stack, false);
        }
    }

    public void m_6883_(ItemStack stack, Level levelIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ServerPlayer player;
        super.m_6883_(stack, levelIn, entityIn, itemSlot, isSelected);
        if (!levelIn.m_5776_() && !this.getUsed(stack) && entityIn instanceof ServerPlayer && !(player = (ServerPlayer)entityIn).m_21023_(MobEffects.f_19591_)) {
            if (player.m_20184_().f_82480_ < -1.0 && !ParachuteItem.getActive(stack)) {
                ++this.tickCounter;
                if (this.tickCounter >= CommonConfigs.PARACHUTE_DELAY.get()) {
                    this.setActive(stack, true);
                    levelIn.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.setTickCounter(0);
                }
            }
            if (ParachuteItem.getActive(stack)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 5, 0, true, false, true));
                if (!player.m_20075_().m_60795_()) {
                    this.setActive(stack, false);
                    this.setUsed(stack, true);
                    if (!player.m_7500_()) {
                        if (stack.m_41773_() < stack.m_41776_()) {
                            stack.m_220157_(1, RandomSource.m_216327_(), player);
                        } else {
                            stack.m_41774_(1);
                            player.m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
                            levelIn.m_5594_(null, player.m_20183_(), SoundEvents.f_12033_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                }
            }
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, DualWeildState twoHanded) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this && entity.m_21252_() < 50) {
            model.f_102812_.f_104204_ = MthUtils.wrapRad((float)(0.1f + model.f_102808_.f_104204_));
            model.f_102812_.f_104203_ = MthUtils.wrapRad((float)(-1.5707964f + model.f_102808_.f_104203_));
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, DualWeildState twoHanded) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this && entity.m_21252_() < 50) {
            model.f_102811_.f_104204_ = MthUtils.wrapRad((float)(-0.1f + model.f_102808_.f_104204_));
            model.f_102811_.f_104203_ = MthUtils.wrapRad((float)(-1.5707964f + model.f_102808_.f_104203_));
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(LivingEntity entity, ItemStack stack, InteractionHand hand, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.m_6117_() && entity.m_21212_() > 0 && entity.m_7655_() == hand && entity.m_21252_() < 60) {
            float timeLeft = (float)stack.m_41779_() - ((float)entity.m_21212_() - partialTicks + 1.0f);
            float f12 = 1.0f;
            float f15 = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
            float f18 = f12 - 0.1f;
            float f20 = f15 * f18;
            matrixStack.m_85837_(0.0, (double)(f20 * 0.007f), 0.0);
            matrixStack.m_85837_(0.0, 0.0, (double)(f12 * 0.04f));
            matrixStack.m_85841_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
        }
    }
}

