/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.blaze3d.platform.InputConstants;
import com.ordana.spelunkery.blocks.PortalFluidCauldronBlock;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.utils.TranslationUtils;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class PortalFluidBucketItem
extends BucketItem {
    private static final Field CONTENT = PlatformHelper.findField(BucketItem.class, (String)"content");
    private int tickCounter = 0;

    public PortalFluidBucketItem(Fluid fluid, Item.Properties properties) {
        super(fluid, properties);
    }

    @PlatformOnly(value={"forge"})
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level levelIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, levelIn, entityIn, itemSlot, isSelected);
        ++this.tickCounter;
        if (this.tickCounter >= 200) {
            this.setBoolean(stack, !this.getBoolean(stack));
            this.setTickCounter(0);
        }
    }

    public void setBoolean(@NotNull ItemStack stack, boolean tears) {
        stack.m_41784_().m_128379_("bool", tears);
    }

    public boolean getBoolean(@NotNull ItemStack stack) {
        return stack.m_41784_().m_128471_("bool");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            if (this.getBoolean(stack)) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.rhymes_with_tears_0").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE)));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.spelunkery.rhymes_with_tears_1", (Object[])new Object[]{this.getBoolean(stack)}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE)));
            }
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.f_90816_.m_84873_())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.portal_fluid_bucket_1").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.portal_fluid_bucket_2").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.spelunkery.portal_fluid_bucket_3").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY)));
            } else {
                tooltip.add((Component)TranslationUtils.CROUCH.component());
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (state.m_60734_() instanceof CauldronBlock || state.m_60734_() instanceof PortalFluidCauldronBlock && (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) < 3) {
            level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42446_.m_7968_());
                player.m_21008_(context.m_43724_(), itemStack2);
                level.m_46597_(pos, (BlockState)ModBlocks.PORTAL_CAULDRON.get().m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
                CriteriaTriggers.f_10562_.m_220040_(serverPlayer, pos, stack);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

