/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items.magnetic_compass;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class MagneticCompassItemPropertyFunction
implements ClampedItemPropertyFunction {
    public static final int DEFAULT_ROTATION = 0;
    private final CompassWobble wobble = new CompassWobble();
    private final CompassWobble wobbleRandom = new CompassWobble();
    public final CompassTarget compassTarget;

    public MagneticCompassItemPropertyFunction(CompassTarget compassTarget) {
        this.compassTarget = compassTarget;
    }

    public float m_142187_(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int i) {
        LivingEntity entity;
        Object object = entity = livingEntity != null ? livingEntity : itemStack.m_41609_();
        if (entity == null) {
            return 0.0f;
        }
        return (clientLevel = this.tryFetchLevelIfMissing((Entity)entity, clientLevel)) == null ? 0.0f : this.getCompassRotation(itemStack, clientLevel, i, (Entity)entity);
    }

    private float getCompassRotation(ItemStack itemStack, ClientLevel clientLevel, int i, Entity entity) {
        GlobalPos globalPos = this.compassTarget.getPos(clientLevel, itemStack, entity);
        long l = clientLevel.m_46467_();
        return !this.isValidCompassTargetPos(entity, globalPos) ? this.getRandomlySpinningRotation(i, l) : this.getRotationTowardsCompassTarget(entity, l, globalPos.m_122646_());
    }

    private float getRandomlySpinningRotation(int i, long l) {
        if (this.wobbleRandom.shouldUpdate(l)) {
            this.wobbleRandom.update(l, Math.random());
        }
        double d = this.wobbleRandom.rotation + (double)((float)this.hash(i) / 2.1474836E9f);
        return Mth.m_14091_((float)((float)d), (float)1.0f);
    }

    private float getRotationTowardsNorth(Entity entity, long l) {
        Player player;
        double d = this.getAngleFromEntityToNorth(entity);
        double e = this.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).m_7578_()) {
            if (this.wobble.shouldUpdate(l)) {
                this.wobble.update(l, 0.5 - (e - 0.25));
            }
            double f = d + this.wobble.rotation;
            return Mth.m_14091_((float)((float)f), (float)1.0f);
        }
        double f = 0.5 - (e - 0.25 - d);
        return Mth.m_14091_((float)((float)f), (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(Entity entity, long l, BlockPos blockPos) {
        Player player;
        double d = this.getAngleFromEntityToPos(entity, blockPos);
        double e = this.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).m_7578_()) {
            if (this.wobble.shouldUpdate(l)) {
                this.wobble.update(l, 0.5 - (e - 0.25));
            }
            double f = d + this.wobble.rotation;
            return Mth.m_14091_((float)((float)f), (float)1.0f);
        }
        double f = 0.5 - (e - 0.25 - d);
        return Mth.m_14091_((float)((float)f), (float)1.0f);
    }

    @Nullable
    private ClientLevel tryFetchLevelIfMissing(Entity entity, @Nullable ClientLevel clientLevel) {
        return clientLevel == null && entity.f_19853_ instanceof ClientLevel ? (ClientLevel)entity.f_19853_ : clientLevel;
    }

    private boolean isValidCompassTargetPos(Entity entity, @Nullable GlobalPos globalPos) {
        return globalPos != null && globalPos.m_122640_() == entity.f_19853_.m_46472_() && !(globalPos.m_122646_().m_203193_((Position)entity.m_20182_()) < (double)1.0E-5f);
    }

    private double getAngleFromEntityToPos(Entity entity, BlockPos blockPos) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)blockPos);
        return Math.atan2(vec3.m_7094_() - entity.m_20189_(), vec3.m_7096_() - entity.m_20185_()) / 6.2831854820251465;
    }

    private double getAngleFromEntityToNorth(Entity entity) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)entity.m_20097_().m_122012_());
        return Math.atan2(vec3.m_7094_() - entity.m_20189_(), vec3.m_7096_() - entity.m_20185_()) / 6.2831854820251465;
    }

    private double getWrappedVisualRotationY(Entity entity) {
        return Mth.m_14109_((double)(entity.m_213816_() / 360.0f), (double)1.0);
    }

    private int hash(int i) {
        return i * 1327217883;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long l) {
            return this.lastUpdateTick != l;
        }

        void update(long l, double d) {
            this.lastUpdateTick = l;
            double e = d - this.rotation;
            e = Mth.m_14109_((double)(e + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += e * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CompassTarget {
        @Nullable
        public GlobalPos getPos(ClientLevel var1, ItemStack var2, Entity var3);
    }
}

