/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.mixins;

import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Slime.class})
public abstract class SlimeMixin
extends Mob {
    @Shadow
    public abstract int m_33632_();

    @Shadow
    public abstract void m_7839_(int var1, boolean var2);

    public boolean m_21531_() {
        return true;
    }

    protected SlimeMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"checkSlimeSpawnRules"}, at={@At(value="HEAD")}, cancellable=true)
    private static void caveSlimeSpawns(EntityType<Slime> slime, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random, CallbackInfoReturnable<Boolean> cir) {
        if (CommonConfigs.INCREASED_SLIME_SPAWN_RATE.get().booleanValue() && level.m_204166_(pos).m_203656_(BiomeTags.f_215817_) && pos.m_123342_() < 60 && random.m_188503_(124) > pos.m_123342_() + 64 && (level.m_7146_(pos) == 0 || level.m_8055_(pos).m_60713_(Blocks.f_152550_))) {
            cir.setReturnValue((Object)SlimeMixin.m_217057_(slime, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random));
        }
    }

    @Inject(method={"dealDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void damage(LivingEntity livingEntity, CallbackInfo ci) {
        if (livingEntity.m_21023_(MobEffects.f_19605_) && CommonConfigs.SLIMES_FRIENDLY_REGEN.get().booleanValue() || CommonConfigs.SLIMES_ALWAYS_FRIENDLY.get().booleanValue()) {
            ci.cancel();
        }
    }

    protected void m_7581_(ItemEntity itemEntity) {
        if (this.f_19796_.m_188503_(CommonConfigs.SLIME_EAT_COOLDOWN.get().intValue()) == 1 && itemEntity.m_32055_().m_204117_(ModTags.SLIME_FOOD)) {
            ItemStack itemStack = itemEntity.m_32055_();
            itemStack.m_41764_(itemStack.m_41613_() - 1);
            itemEntity.m_32045_(itemStack);
            this.m_5496_(SoundEvents.f_12388_, 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11947_, 1.0f, 1.0f);
            int i = 1 + this.f_19796_.m_188503_(this.m_33632_());
            for (int j = 0; j < i; ++j) {
                if (this.f_19796_.m_188503_(3) > this.m_33632_()) continue;
                this.m_19998_((ItemLike)Items.f_42518_);
            }
            if (this.f_19796_.m_188503_(CommonConfigs.SLIME_GROWTH_CHANCE.get().intValue()) == 1 && this.m_33632_() <= CommonConfigs.SLIME_GROWTH_MAX.get() && CommonConfigs.SLIME_GROWTH.get().booleanValue()) {
                this.m_7839_(this.m_33632_() + 1, false);
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_204117_(ModTags.SLIME_FOOD)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10565_.m_61494_(serverPlayer, itemStack, (Entity)this);
            }
            player.m_5496_(SoundEvents.f_12388_, 1.0f, 1.0f);
            player.m_5496_(SoundEvents.f_11947_, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            int i = 1 + this.f_19796_.m_188503_(this.m_33632_());
            for (int j = 0; j < i; ++j) {
                ItemEntity itemEntity;
                if (this.f_19796_.m_188503_(3) > this.m_33632_() || (itemEntity = this.m_19998_((ItemLike)Items.f_42518_)) == null) continue;
                itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }
}

