/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.utils;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LevelHelper {
    public static Pair<Vec3, ServerLevel> getSpawnData(ServerPlayer player) {
        float angle;
        Optional spawnPosition;
        BlockPos respawnPosition = player.m_8961_();
        ServerLevel serverLevel = player.f_8924_.m_129880_(player.m_8963_());
        Vec3 exactSpawnPosition = null;
        if (serverLevel == null) {
            return new Pair((Object)Vec3.f_82478_, null);
        }
        if (respawnPosition != null && (spawnPosition = Player.m_36130_((ServerLevel)serverLevel, (BlockPos)respawnPosition, (float)(angle = player.m_8962_()), (boolean)true, (boolean)true)).isPresent()) {
            exactSpawnPosition = (Vec3)spawnPosition.get();
        }
        if (exactSpawnPosition == null) {
            serverLevel = player.f_8924_.m_129880_(Level.f_46428_);
            assert (serverLevel != null);
            exactSpawnPosition = LevelHelper.vec3(serverLevel.m_220360_());
        }
        return new Pair(exactSpawnPosition, (Object)serverLevel);
    }

    public static void teleportToSpawnPosition(ServerPlayer player) {
        Pair<Vec3, ServerLevel> spawnData = LevelHelper.getSpawnData(player);
        Vec3 spawnPosition = (Vec3)spawnData.getFirst();
        ServerLevel serverLevel = (ServerLevel)spawnData.getSecond();
        player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11757_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_8999_(serverLevel, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, player.m_146908_(), player.m_146909_());
    }

    public static void teleportToAnchorPosition(ServerPlayer player, GlobalPos pos) {
        player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11757_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_8999_(Objects.requireNonNull(player.f_8924_.m_129880_(pos.m_122640_())), (double)pos.m_122646_().m_123341_() + 0.5, (double)(pos.m_122646_().m_123342_() + 1), (double)pos.m_122646_().m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
    }

    public static void teleportToWorldspawn(Level level, Entity entity) {
        Vec3 spawnPosition = LevelHelper.vec3(level.m_220360_());
        entity.m_6021_(spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_);
    }

    public static Vec3 vec3(BlockPos blockPosition) {
        return new Vec3((double)blockPosition.m_123341_() + 0.5, (double)blockPosition.m_123342_() + 0.5, (double)blockPosition.m_123343_() + 0.5);
    }

    public static BlockPos blockPos(Vec3 vec3) {
        return new BlockPos(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }
}

