/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModSoundEvents;

public class Camel
extends AbstractChestedHorse {
    public Camel(EntityType<? extends AbstractChestedHorse> type, Level level) {
        super(type, level);
    }

    public static boolean checkCamelSpawnRules(EntityType<Camel> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13029_) && Camel.m_186209_((BlockAndTintGetter)level, (BlockPos)pos);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Camel.m_30501_().m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)ModEntityTypes.CAMEL.get().m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_(Items.f_41866_) || pStack.m_150930_(Items.f_41982_) || pStack.m_150930_(ModItems.PRICKLY_PEAR.get());
    }

    public boolean m_7559_() {
        return false;
    }

    public int m_7555_() {
        return 30;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return pOtherAnimal instanceof Camel && this.m_30628_() && ((Camel)pOtherAnimal).m_30628_();
    }

    protected boolean m_5994_(Player pPlayer, ItemStack pStack) {
        int increaseAgeAmount = 0;
        int increaseTemperAmount = 0;
        float healAmount = 0.0f;
        boolean willEat = false;
        if (pStack.m_150930_(Items.f_41866_) || pStack.m_150930_(Items.f_41982_)) {
            increaseAgeAmount = 10;
            increaseTemperAmount = 3;
            healAmount = 2.0f;
        } else if (pStack.m_150930_(ModItems.PRICKLY_PEAR.get())) {
            increaseAgeAmount = 90;
            increaseTemperAmount = 6;
            healAmount = 10.0f;
            if (this.m_30614_() && this.m_146764_() == 0 && this.m_5957_()) {
                willEat = true;
                this.m_27595_(pPlayer);
            }
        }
        if (this.m_21223_() < this.m_21233_() && healAmount > 0.0f) {
            this.m_5634_(healAmount);
            willEat = true;
        }
        if (this.m_6162_() && increaseAgeAmount > 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.f_19853_.f_46443_) {
                this.m_146758_(increaseAgeAmount);
            }
            willEat = true;
        }
        if (increaseTemperAmount > 0 && (willEat || !this.m_30614_()) && this.m_30624_() < this.m_7555_()) {
            willEat = true;
            if (!this.f_19853_.f_46443_) {
                this.m_30653_(increaseTemperAmount);
            }
        }
        if (willEat) {
            SoundEvent soundevent;
            this.m_146850_(GameEvent.f_157806_);
            if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7872_(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
        }
        return willEat;
    }

    public float m_6113_() {
        return this.m_20197_().size() < 2 ? 0.175f : 0.16f;
    }

    public boolean m_7132_() {
        return false;
    }

    protected boolean m_7310_(Entity pPassenger) {
        return this.m_20197_().size() < 2;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!this.m_6162_()) {
            if (this.m_30614_() && pPlayer.m_36341_()) {
                this.m_213583_(pPlayer);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.m_20160_() && this.m_20197_().size() >= 2) {
                return super.m_6071_(pPlayer, pHand);
            }
        }
        if (!itemstack.m_41619_()) {
            if (this.m_6898_(itemstack)) {
                return this.m_30580_(pPlayer, itemstack);
            }
            if (!this.m_30614_()) {
                this.m_7564_();
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.m_30502_() && itemstack.m_150930_(Blocks.f_50087_.m_5456_())) {
                this.m_30504_(true);
                this.m_7609_();
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_30625_();
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.m_6162_() && !this.m_6254_() && itemstack.m_150930_(Items.f_42450_)) {
                this.m_213583_(pPlayer);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        if (this.m_6162_()) {
            return super.m_6071_(pPlayer, pHand);
        }
        this.m_6835_(pPlayer);
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public void m_7332_(Entity pPassenger) {
        if (this.m_20363_(pPassenger)) {
            float lengthwiseOffset = 0.0f;
            double heightwiseOffset = this.m_6048_() + pPassenger.m_6049_();
            if (this.m_20197_().size() > 0) {
                lengthwiseOffset = this.m_20197_().indexOf(pPassenger) == 0 ? 0.2f : -0.6f;
            }
            Vec3 vec = new Vec3((double)lengthwiseOffset, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            pPassenger.m_6034_(this.m_20185_() + vec.f_82479_, this.m_20186_() + heightwiseOffset, this.m_20189_() + vec.f_82481_);
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.8;
    }

    public int m_7488_() {
        return 5;
    }

    protected int m_7506_() {
        return this.m_30502_() ? 2 + 3 * this.m_7488_() : super.m_7506_();
    }

    protected float m_6121_() {
        return 0.8f;
    }

    protected SoundEvent m_7871_() {
        return ModSoundEvents.CAMEL_ANGRY.get();
    }

    protected SoundEvent m_7515_() {
        return ModSoundEvents.CAMEL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return ModSoundEvents.CAMEL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSoundEvents.CAMEL_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return ModSoundEvents.CAMEL_EAT.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(ModSoundEvents.CAMEL_STEP.get(), 0.15f, 1.0f);
    }

    protected void m_7609_() {
        this.m_5496_(ModSoundEvents.CAMEL_CHEST.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }
}

