/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.ModConfigSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FileUtils;

public class WorldSelectionScreen
extends ListMenuScreen {
    private static final LevelResource SERVER_CONFIG_FOLDER = new LevelResource("serverconfig");
    private static final ResourceLocation MISSING_ICON = new ResourceLocation("textures/misc/unknown_server.png");
    private final IModConfig config;

    public WorldSelectionScreen(Screen parent, ResourceLocation background, IModConfig config, Component title) {
        super(parent, (Component)Component.m_237110_((String)"configured.gui.edit_world_config", (Object[])new Object[]{title.m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD})}), background, 30);
        this.config = config;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        try {
            LevelStorageSource source = Minecraft.m_91087_().m_91392_();
            ArrayList levels = new ArrayList((Collection)source.m_230813_(source.m_230833_()).join());
            if (levels.size() > 6) {
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"configured.gui.title.recently_played").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
                List<LevelSummary> recent = levels.stream().sorted(Comparator.comparing(s -> -s.m_78366_())).limit(3L).toList();
                recent.forEach(summary -> entries.add(new WorldItem((LevelSummary)summary)));
                levels.removeAll(recent);
                entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem((Component)Component.m_237115_((String)"configured.gui.title.other_worlds").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW})));
            }
            levels.stream().sorted(Comparator.comparing(LevelSummary::m_78361_)).forEach(summary -> entries.add(new WorldItem((LevelSummary)summary)));
        }
        catch (LevelStorageException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 29, 150, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_((double)(this.f_96543_ - 30), 15.0, 0.0);
        poseStack.m_85841_(2.5f, 2.5f, 2.5f);
        Screen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)"?").m_130940_(ChatFormatting.BOLD), (int)0, (int)0, (int)0xFFFFFF);
        poseStack.m_85849_();
    }

    @Override
    protected void updateTooltip(int mouseX, int mouseY) {
        super.updateTooltip(mouseX, mouseY);
        if (ScreenUtil.isMouseWithin(this.f_96543_ - 30, 15, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.m_237115_((String)"configured.gui.server_config_info"));
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.entries.forEach(item -> {
            if (item instanceof WorldItem) {
                ((WorldItem)item).disposeIcon();
            }
        });
    }

    public class WorldItem
    extends ListMenuScreen.Item {
        private final Component worldName;
        private final Component folderName;
        private final ResourceLocation iconId;
        private Path iconFile;
        private final DynamicTexture texture;
        private final Button modifyButton;

        public WorldItem(LevelSummary summary) {
            super(summary.m_78361_());
            this.worldName = Component.m_237113_((String)summary.m_78361_());
            this.folderName = Component.m_237113_((String)summary.m_78358_()).m_130940_(ChatFormatting.DARK_GRAY);
            this.iconId = new ResourceLocation("minecraft", "worlds/" + Util.m_137483_((String)summary.m_78358_(), ResourceLocation::m_135828_) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)summary.m_78358_()) + "/icon");
            this.iconFile = summary.m_230875_();
            if (!Files.isRegularFile(this.iconFile, new LinkOption[0])) {
                this.iconFile = null;
            }
            this.texture = this.loadWorldIcon();
            this.modifyButton = new IconButton(0, 0, 0, this.getIconV(), 60, this.getButtonLabel(), onPress -> this.loadWorldConfig(summary.m_78358_(), summary.m_78361_()));
        }

        private Component getButtonLabel() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return Component.m_237115_((String)"configured.gui.view");
            }
            return Component.m_237115_((String)"configured.gui.select");
        }

        private int getIconV() {
            if (WorldSelectionScreen.this.config.isReadOnly()) {
                return 33;
            }
            return 22;
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.modifyButton);
        }

        @Override
        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            if (x % 2 != 0) {
                Screen.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + 24), (int)0x55000000);
            }
            if (this.modifyButton.m_5953_((double)mouseX, (double)mouseY)) {
                Screen.m_93172_((PoseStack)poseStack, (int)(left - 1), (int)(top - 1), (int)(left + 25), (int)(top + 25), (int)-1);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)(this.texture != null ? this.iconId : MISSING_ICON));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)left, (int)top, (int)24, (int)24, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
            Screen.m_93243_((PoseStack)poseStack, (Font)((WorldSelectionScreen)WorldSelectionScreen.this).f_96541_.f_91062_, (Component)this.worldName, (int)(left + 30), (int)(top + 3), (int)0xFFFFFF);
            Screen.m_93243_((PoseStack)poseStack, (Font)((WorldSelectionScreen)WorldSelectionScreen.this).f_96541_.f_91062_, (Component)this.folderName, (int)(left + 30), (int)(top + 13), (int)0xFFFFFF);
            this.modifyButton.f_93620_ = left + width - 61;
            this.modifyButton.f_93621_ = top + 2;
            this.modifyButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private DynamicTexture loadWorldIcon() {
            if (this.iconFile == null) {
                return null;
            }
            try (InputStream is = Files.newInputStream(this.iconFile, new OpenOption[0]);){
                DynamicTexture dynamicTexture;
                block19: {
                    NativeImage image;
                    block17: {
                        DynamicTexture dynamicTexture2;
                        block18: {
                            image = NativeImage.m_85058_((InputStream)is);
                            try {
                                if (image.m_84982_() == 64 && image.m_85084_() == 64) break block17;
                                dynamicTexture2 = null;
                                if (image == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (image != null) {
                                    try {
                                        image.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            image.close();
                        }
                        return dynamicTexture2;
                    }
                    DynamicTexture texture = new DynamicTexture(image);
                    WorldSelectionScreen.this.f_96541_.m_91097_().m_118495_(this.iconId, (AbstractTexture)texture);
                    dynamicTexture = texture;
                    if (image == null) break block19;
                    image.close();
                }
                return dynamicTexture;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public void disposeIcon() {
            if (this.texture != null) {
                this.texture.close();
            }
        }

        private void loadWorldConfig(String worldFileName, String worldName) {
            try (LevelStorageSource.LevelStorageAccess storageAccess = Minecraft.m_91087_().m_91392_().m_78260_(worldFileName);){
                Path worldConfigPath = storageAccess.m_78283_(SERVER_CONFIG_FOLDER);
                FileUtils.getOrCreateDirectory((Path)worldConfigPath, (String)"serverconfig");
                WorldSelectionScreen.this.config.loadWorldConfig(worldConfigPath, (IModConfig T) -> ModList.get().getModContainerById(T.getModId()).ifPresent(container -> {
                    MutableComponent configName = Component.m_237113_((String)ModConfigSelectionScreen.createLabelFromModConfig(WorldSelectionScreen.this.config));
                    MutableComponent newTitle = Component.m_237113_((String)worldName).m_6881_().m_7220_((Component)Component.m_237113_((String)" > ").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})).m_7220_((Component)configName);
                    WorldSelectionScreen.this.f_96541_.m_91152_((Screen)new ConfigScreen(WorldSelectionScreen.this.parent, (Component)newTitle, (IModConfig)T, WorldSelectionScreen.this.background));
                }));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

