/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import me.flashyreese.mods.reeses_sodium_options.client.gui.Dim2iExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.OptionExtended;
import me.flashyreese.mods.reeses_sodium_options.client.gui.frame.AbstractFrame;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.Validate;

public class OptionPageFrame
extends AbstractFrame {
    protected final Dim2i originalDim;
    protected final OptionPage page;
    private long lastTime = 0L;
    private ControlElement<?> lastHoveredElement = null;

    public OptionPageFrame(Dim2i dim, boolean renderOutline, OptionPage page) {
        super(dim, renderOutline);
        this.originalDim = new Dim2i(dim.x(), dim.y(), dim.width(), dim.height());
        this.page = page;
        this.setupFrame();
        this.buildFrame();
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public void setupFrame() {
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        if (!this.page.getGroups().isEmpty()) {
            OptionGroup lastGroup = (OptionGroup)this.page.getGroups().get(this.page.getGroups().size() - 1);
            for (OptionGroup group2 : this.page.getGroups()) {
                y += group2.getOptions().size() * 18;
                if (group2 == lastGroup) continue;
                y += 4;
            }
        }
        ((Dim2iExtended)this.dim).setHeight(y);
        this.page.getGroups().forEach(group -> group.getOptions().forEach(option -> {
            if (option instanceof OptionExtended) {
                OptionExtended optionExtended = (OptionExtended)option;
                optionExtended.setParentDimension(this.dim);
            }
        }));
    }

    @Override
    public void buildFrame() {
        if (this.page == null) {
            return;
        }
        this.children.clear();
        this.drawable.clear();
        this.controlElements.clear();
        int y = 0;
        for (OptionGroup group : this.page.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(this.dim.x(), this.dim.y() + y, this.dim.width(), 18));
                this.children.add(element);
                y += 18;
            }
            y += 4;
        }
        super.buildFrame();
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float delta) {
        ControlElement hoveredElement = this.controlElements.stream().filter(controlElement -> ((Dim2iExtended)controlElement.getDimensions()).overlapWith(this.originalDim)).filter(ControlElement::isHovered).findFirst().orElse(null);
        super.m_6305_(matrixStack, mouseX, mouseY, delta);
        if (hoveredElement != null && this.lastHoveredElement == hoveredElement && this.originalDim.containsCursor((double)mouseX, (double)mouseY) && hoveredElement.isHovered() && hoveredElement.m_5953_((double)mouseX, (double)mouseY)) {
            if (this.lastTime == 0L) {
                this.lastTime = System.currentTimeMillis();
            }
            this.renderOptionTooltip(matrixStack, hoveredElement);
        } else {
            this.lastTime = 0L;
            this.lastHoveredElement = hoveredElement;
        }
    }

    private void renderOptionTooltip(PoseStack matrixStack, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        if (this.lastTime + 500L > System.currentTimeMillis()) {
            return;
        }
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = dim.width();
        int boxY = dim.getLimitY();
        int boxX = dim.x();
        Option option = element.getOption();
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>(Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(Language.m_128107_().m_5536_((FormattedText)Component.m_237110_((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).m_130940_(ChatFormatting.GRAY)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.originalDim.getLimitY())) {
            boxY -= boxHeight + dim.height();
        }
        if (boxY < 0) {
            boxY = dim.getLimitY();
        }
        this.drawRect(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912);
        this.drawRectOutline(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -7019309);
        for (int i = 0; i < tooltip.size(); ++i) {
            Minecraft.m_91087_().f_91062_.m_92744_(matrixStack, (FormattedCharSequence)tooltip.get(i), (float)(boxX + textPadding), (float)(boxY + textPadding + i * 12), -1);
        }
    }

    public static class Builder {
        private Dim2i dim;
        private boolean renderOutline;
        private OptionPage page;

        public Builder setDimension(Dim2i dim) {
            this.dim = dim;
            return this;
        }

        public Builder shouldRenderOutline(boolean renderOutline) {
            this.renderOutline = renderOutline;
            return this;
        }

        public Builder setOptionPage(OptionPage page) {
            this.page = page;
            return this;
        }

        public OptionPageFrame build() {
            Validate.notNull((Object)this.dim, (String)"Dimension must be specified", (Object[])new Object[0]);
            Validate.notNull((Object)this.page, (String)"Option Page must be specified", (Object[])new Object[0]);
            return new OptionPageFrame(this.dim, this.renderOutline, this.page);
        }
    }
}

