/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.separatedleaves;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import nl.teamdiopside.separatedleaves.SeparatedLeaves;

public class Reload {
    public static final List<LeavesRule> LEAVES_RULES = new ArrayList<LeavesRule>();

    public static void reload(ResourceManager resourceManager) {
        Reload.apply(Reload.getJsons(resourceManager));
    }

    public static void apply(Map<ResourceLocation, JsonElement> jsons) {
        LEAVES_RULES.clear();
        ArrayList<LeavesRule> temp = new ArrayList<LeavesRule>();
        ArrayList<JsonFile> files = new ArrayList<JsonFile>();
        jsons.forEach((key, json) -> files.add(new JsonFile((ResourceLocation)key, (JsonElement)json)));
        files.sort(Comparator.comparing(jsonFile -> jsonFile.key().toString()));
        for (JsonFile file : files) {
            ResourceLocation key2 = file.key();
            JsonElement json2 = file.json();
            if (!Platform.getModIds().contains(key2.m_135827_())) continue;
            try {
                Set<Block> leaves = Reload.getBlocks(key2, json2, "leaves");
                Set<Block> logs = Reload.getBlocks(key2, json2, "logs");
                if (leaves.isEmpty() || logs.isEmpty()) continue;
                temp.add(new LeavesRule(leaves, logs));
                SeparatedLeaves.LOGGER.info("Loaded Separated Leaves file " + key2);
            }
            catch (Exception e) {
                SeparatedLeaves.LOGGER.error("Failed to parse JSON object for leaves rule " + key2 + ".json, Error: " + e);
            }
        }
        LEAVES_RULES.addAll(temp);
    }

    public static Set<Block> getBlocks(ResourceLocation key, JsonElement json, String string) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (JsonElement jsonElement : json.getAsJsonObject().get(string).getAsJsonArray()) {
            if (jsonElement.getAsString().startsWith("#")) {
                TagKey blockTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(jsonElement.getAsString().replace("#", "")));
                for (Holder blockHolder : Registry.f_122824_.m_203561_(blockTagKey)) {
                    blocks.add((Block)blockHolder.m_203334_());
                }
                continue;
            }
            Block block = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(jsonElement.getAsString()));
            if (block == Blocks.f_50016_ && !jsonElement.getAsString().replace("minecraft:", "").equals("air")) {
                SeparatedLeaves.LOGGER.error("Block \"" + jsonElement.getAsString() + "\" from " + key + " does not exist!");
                continue;
            }
            blocks.add(block);
        }
        return blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<ResourceLocation, JsonElement> getJsons(ResourceManager resourceManager) {
        String directory = "separated_leaves";
        Gson gson = new Gson();
        HashMap map = Maps.newHashMap();
        int i = directory.length() + 1;
        for (Map.Entry entry : resourceManager.m_214159_(directory, resourceLocation -> resourceLocation.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation resourceLocation2 = (ResourceLocation)entry.getKey();
            String string = resourceLocation2.m_135815_();
            ResourceLocation resourceLocation22 = new ResourceLocation(resourceLocation2.m_135827_(), string.substring(i, string.length() - ".json".length()));
            try (BufferedReader reader = ((Resource)entry.getValue()).m_215508_();){
                JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonElement.class);
                if (jsonElement != null) {
                    JsonElement jsonElement2 = map.put(resourceLocation22, jsonElement);
                    if (jsonElement2 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + resourceLocation22);
                }
                SeparatedLeaves.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceLocation22, (Object)resourceLocation2);
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                SeparatedLeaves.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{resourceLocation22, resourceLocation2, exception});
            }
        }
        return map;
    }

    public record JsonFile(ResourceLocation key, JsonElement json) {
    }

    public record LeavesRule(Set<Block> leaves, Set<Block> logs) {
    }
}

