/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.separatedleaves.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import nl.teamdiopside.separatedleaves.Reload;
import nl.teamdiopside.separatedleaves.SeparatedLeaves;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LeavesBlock.class})
public abstract class LeavesBlockMixin {
    @Shadow
    @Final
    public static IntegerProperty f_54418_;

    @Inject(method={"updateDistance"}, at={@At(value="HEAD")}, cancellable=true)
    private static void updateDistance(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, CallbackInfoReturnable<BlockState> cir) {
        ServerLevel serverLevel;
        StructureManager structureManager;
        StructureStart detectedStructure;
        if (levelAccessor instanceof ServerLevel && (detectedStructure = (structureManager = (serverLevel = (ServerLevel)levelAccessor).m_215010_()).m_220491_(blockPos, SeparatedLeaves.ALLOW_MISMATCHED_LEAVES_STRUCTURES)).m_73603_()) {
            return;
        }
        if (levelAccessor.m_204166_(blockPos).m_203656_(SeparatedLeaves.ALLOW_MISMATCHED_LEAVES_BIOMES)) {
            return;
        }
        boolean hasFile = false;
        int i = 7;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Block thisBlock = levelAccessor.m_8055_(blockPos).m_60734_();
        for (Direction direction : Direction.values()) {
            mutableBlockPos.m_122159_((Vec3i)blockPos, direction);
            BlockState targetState = levelAccessor.m_8055_((BlockPos)mutableBlockPos);
            Block targetBlock = targetState.m_60734_();
            for (Reload.LeavesRule rule : Reload.LEAVES_RULES) {
                if (!rule.leaves().contains(thisBlock)) continue;
                hasFile = true;
                if (rule.logs().contains(targetBlock)) {
                    i = 1;
                    break;
                }
                if (!(targetBlock instanceof LeavesBlock) || !rule.leaves().contains(targetBlock)) continue;
                i = Math.min(i, (Integer)targetState.m_61143_((Property)f_54418_) + 1);
            }
            if (i == 1) break;
        }
        if (hasFile) {
            cir.setReturnValue((Object)((BlockState)blockState.m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(i))));
        }
    }
}

