/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.fermion.core;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="fermion")
public class FermionConfig {
    public static final Client CLIENT;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        COMMON = (Common)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
    }

    public static class Common {
        public final Map<CreativeModeTab, ForgeConfigSpec.ConfigValue<String>> tabOverrides = new HashMap<CreativeModeTab, ForgeConfigSpec.ConfigValue<String>>();
        public final ForgeConfigSpec.ConfigValue<Boolean> hideModdedItemTabs;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> hiddenItems;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> tabModifiers;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> hiddenEnchantments;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> hiddenPotions;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> blockSoundTypes;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Creative Mode Tab Tweaks").push("tab-tweaks");
            builder.comment("Replace the Item Icon for the vanilla Creative Mode Tabs").push("tab-icons");
            this.tabOverrides.put(CreativeModeTab.f_40749_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Building Blocks Tab Icon", (Object)"minecraft:bricks"));
            this.tabOverrides.put(CreativeModeTab.f_40750_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Decorations Tab Icon", (Object)"minecraft:peony"));
            this.tabOverrides.put(CreativeModeTab.f_40751_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Redstone Tab Icon", (Object)"minecraft:redstone"));
            this.tabOverrides.put(CreativeModeTab.f_40752_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Transportation Tab Icon", (Object)"minecraft:powered_rail"));
            this.tabOverrides.put(CreativeModeTab.f_40753_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Misc Tab Icon", (Object)"minecraft:lava_bucket"));
            this.tabOverrides.put(CreativeModeTab.f_40755_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Foodstuffs Tab Icon", (Object)"minecraft:apple"));
            this.tabOverrides.put(CreativeModeTab.f_40756_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Tools Tab Icon", (Object)"minecraft:iron_axe"));
            this.tabOverrides.put(CreativeModeTab.f_40757_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Combat Tab Icon", (Object)"minecraft:golden_sword"));
            this.tabOverrides.put(CreativeModeTab.f_40758_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Brewing Tab Icon", (Object)"minecraft:potion"));
            this.tabOverrides.put(CreativeModeTab.f_40761_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Inventory Tab Icon", (Object)"minecraft:chest"));
            this.tabOverrides.put(CreativeModeTab.f_40754_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Search Tab Icon", (Object)"minecraft:compass"));
            this.tabOverrides.put(CreativeModeTab.f_40760_, (ForgeConfigSpec.ConfigValue<String>)builder.define("Saved Hotbar Tab Icon", (Object)"minecraft:bookshelf"));
            builder.pop();
            this.hideModdedItemTabs = builder.comment("Hides all modded Creative Mode Tabs. (REQUIRES RESTART)").define("Hide Modded Tabs", false);
            this.hiddenItems = builder.comment("Hides any item in this list from the Creative Mode Inventories. (REQUIRES RESTART)").define("Hidden Items", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:petrified_oak_slab"}));
            this.tabModifiers = builder.comment("Moves any item in this list to any specified item tab (REQUIRES RESTART). \nValues: building_blocks, decorations, redstone, transport, misc, food, tools, combat, brewing").define("Item Tab Modifiers", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:command_block=redstone", "minecraft:repeating_command_block=redstone", "minecraft:chain_command_block=redstone", "minecraft:command_block_minecart=transport", "minecraft:dragon_egg=misc", "minecraft:spawner=misc", "minecraft:structure_block=redstone"}));
            this.hiddenEnchantments = builder.comment("Hides any enchantment from this list from the Creative Mode Inventories.").define("Hidden Enchanted Books", (Object)Lists.newArrayList());
            this.hiddenPotions = builder.comment("Hides any registered potions (NOT EFFECTS) from this list from the Creative Mode Inventories.").define("Hidden Potions", (Object)Lists.newArrayList());
            builder.pop();
            builder.comment("Block Tweaks").push("block-tweaks");
            this.blockSoundTypes = builder.comment("Allows the modification of any blocks SoundType (REQUIRES RESTART). \nValues: wood, gravel, grass, lily_pad, stone, metal, glass, wool, sand, snow, powder_snow, ladder, anvil, slime, honey, wet_grass, coral, bamboo, bamboo_sapling, scaffolding, sweet_berry_bush, crop, hard_crop, vine, nether_wart, lantern, stem, nylium, fungus, roots, shroomlight, weeping_vines, twisting_vines, soul_sand, soul_soil, basalt, wart_block, netherrack, nether_bricks, nether_sprouts, nether_ore, bone_block, netherite_block, ancient_debris, lodestone, chain, nether_gold_ore, gilded_blackstone, candle, amethyst, amethyst_cluster, small_amethyst_bud, medium_amethyst_bud, large_amethyst_bud, tuff, calcite, dripstone, pointed_dripstone, copper, cave_vines, spore_blossom, azalea, flowering_azalea, moss_carpet, moss, big_dripleaf, small_dripleaf, rooted_dirt, hanging_roots, azalea_leaves, sculk_sensor, sculk_catalyst, sculk, sculk_vein, sculk_shrieker, glow_lichen, deepslate, deepslate_bricks, deepslate_tiles, polished_deepslate, froglight, frogspawn, mangrove_roots, muddy_mangrove_roots, mud, mud_bricks, packed_mud").define("Block SoundType Overrides", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:cobweb=wool"}));
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> dyeableTooltip;
        public final ForgeConfigSpec.ConfigValue<Boolean> horseArmourTooltip;
        public final ForgeConfigSpec.ConfigValue<Boolean> foodEffectTooltip;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foodEffectBlackList;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> customTooltips;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Extra tooltips for items that displays helpful information").push("tooltips");
            this.dyeableTooltip = builder.comment("Items that are dyeable with have a tooltip displaying this").define("Dyeable Tooltip", true);
            this.horseArmourTooltip = builder.comment("All Horse Armour items will display their armor stat").define("Horse Armour Tooltip", true);
            this.foodEffectTooltip = builder.comment("Food Item Tooltips display which effects they provide").define("Food Effect Tooltip", true);
            this.foodEffectBlackList = builder.comment("Blacklist of items to display food effects tooltips").define("Food Effect Tooltip BlackList", (Object)Lists.newArrayList((Object[])new String[]{"farmersdelight:apple_cider", "farmersdelight:cooked_rice", "farmersdelight:bone_broth", "farmersdelight:beef_stew", "farmersdelight:chicken_soup", "farmersdelight:vegetable_soup", "farmersdelight:fish_stew", "farmersdelight:fried_rice", "farmersdelight:pumpkin_soup", "farmersdelight:baked_cod_stew", "farmersdelight:noodle_soup", "farmersdelight:bacon_and_eggs", "farmersdelight:pasta_with_meatballs", "farmersdelight:pasta_with_mutton_chop", "farmersdelight:mushroom_rice", "farmersdelight:roasted_mutton_chops", "farmersdelight:vegetable_noodles", "farmersdelight:steak_and_potatoes", "farmersdelight:ratatouille", "farmersdelight:squid_ink_pasta", "farmersdelight:grilled_salmon", "farmersdelight:roast_chicken", "farmersdelight:stuffed_pumpkin", "farmersdelight:honey_glazed_ham", "farmersdelight:shepherds_pie", "farmersdelight:fruit_salad", "farmersdelight:mixed_salad", "abnormals_delight:slabdish"}));
            this.customTooltips = builder.comment("Items In this list will have a custom tooltip you will have to add a translation for").define("Custom Tooltip List", (Object)Lists.newArrayList());
            builder.pop();
        }
    }
}

