/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader;

import java.nio.file.Path;
import net.darkhax.openloader.Constants;
import net.darkhax.openloader.OpenLoaderCommon;
import net.darkhax.openloader.config.ConfigSchema;
import net.darkhax.openloader.packs.OpenLoaderRepositorySource;
import net.darkhax.openloader.packs.RepoType;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="openloader")
public class OpenLoaderForge {
    public OpenLoaderForge() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::injectPackRepositories);
    }

    private void injectPackRepositories(AddPackFindersEvent event) {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("openloader");
        ConfigSchema config = OpenLoaderCommon.loadConfig(configDir);
        if (config == null) {
            Constants.LOG.error("Failed to read OpenLoader config file. Your file is missing, invalid, or corrupt. Another mod may be loading packs incorrectly.");
            return;
        }
        switch (event.getPackType()) {
            case CLIENT_RESOURCES: {
                event.addRepositorySource((RepositorySource)new OpenLoaderRepositorySource(RepoType.RESOURCES, config.resourcePacks, configDir));
                break;
            }
            case SERVER_DATA: {
                event.addRepositorySource((RepositorySource)new OpenLoaderRepositorySource(RepoType.DATA, config.dataPacks, configDir));
                break;
            }
            default: {
                Constants.LOG.warn("Encountered unknown pack type {}. Nothing will be loaded for this type.", (Object)event.getPackType().name());
            }
        }
    }
}

