/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.client.AtlasTracking;
import com.unascribed.fabrication.client.AtlasViewerScreen;
import com.unascribed.fabrication.client.FabricationConfigScreen;
import com.unascribed.fabrication.client.FabricationSummaryScreen;
import com.unascribed.fabrication.client.OptionalFScriptScreen;
import com.unascribed.fabrication.client.OptionalPrideFlag;
import com.unascribed.fabrication.features.FeatureFabricationCommand;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.OptionalFScript;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class FabricationClientCommands {
    private static final CommandDispatcher<SharedSuggestionProvider> dispatcher = new CommandDispatcher();
    public static String rootCommand = MixinConfigPlugin.MOD_NAME_LOWER + ":client";

    public static void registerCommands() {
        FabricationClientCommands.registerCommands(dispatcher);
    }

    public static boolean runCommand(String command) {
        if (command.isEmpty() || !command.startsWith(rootCommand)) {
            return false;
        }
        try {
            dispatcher.execute(command, (Object)Minecraft.m_91087_().m_91403_().m_105137_());
        }
        catch (CommandRuntimeException ignore) {
            FabricationClientCommands.sendFeedback(ignore.m_79226_());
        }
        catch (Exception e) {
            FabLog.error("Failed to execute client command: " + command, e);
            FabricationClientCommands.sendFeedback((Component)Component.m_237113_((String)("\u00a7c" + e)));
        }
        return true;
    }

    public static <T extends SharedSuggestionProvider> void addSuggestions(CommandDispatcher<T> dispatcher) {
        FabricationClientCommands.registerCommands(dispatcher);
    }

    private static <T extends SharedSuggestionProvider> void registerCommands(CommandDispatcher<T> dispatcher) {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)rootCommand);
        if (EarlyAgnos.isModLoaded("fscript")) {
            FabricationClientCommands.addFScript(root);
        }
        FeatureFabricationCommand.addConfig(root, false);
        root.then(LiteralArgumentBuilder.literal((String)"ui").executes(c -> {
            Minecraft.m_91087_().m_6937_(() -> Minecraft.m_91087_().m_91152_((Screen)new FabricationConfigScreen(null)));
            return 1;
        }));
        root.then(LiteralArgumentBuilder.literal((String)"summary_ui").executes(c -> {
            Minecraft.m_91087_().m_6937_(() -> {
                FabricationSummaryScreen screen = FabricationSummaryScreen.tryCreate(null);
                if (screen == null) {
                    FabricationClientCommands.sendFeedback(Component.m_130674_((String)("Server isn't running " + MixinConfigPlugin.MOD_NAME)));
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)screen);
                }
            });
            return 1;
        }));
        if (!FabConf.isFailed("atlas_viewer")) {
            root.then(LiteralArgumentBuilder.literal((String)"atlas").then(LiteralArgumentBuilder.literal((String)"view").then(RequiredArgumentBuilder.argument((String)"atlas", (ArgumentType)new AtlasArgumentType()).executes(c -> {
                Minecraft.m_91087_().m_6937_(() -> Minecraft.m_91087_().m_91152_((Screen)new AtlasViewerScreen((ResourceLocation)c.getArgument("atlas", ResourceLocation.class))));
                return 1;
            }))));
        }
        dispatcher.register(root);
    }

    public static <T extends SharedSuggestionProvider> void addFScript(LiteralArgumentBuilder<T> root) {
        LiteralArgumentBuilder script = LiteralArgumentBuilder.literal((String)"fscript");
        LiteralArgumentBuilder ui = LiteralArgumentBuilder.literal((String)"ui");
        for (String s : OptionalFScript.predicateProviders.keySet()) {
            LiteralArgumentBuilder key = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)s).executes(c -> {
                Minecraft.m_91087_().m_6937_(() -> Minecraft.m_91087_().m_91152_(OptionalFScriptScreen.construct(null, OptionalPrideFlag.get(), FeaturesFile.get((String)s).name, s)));
                return 1;
            });
            ui.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s, alt -> ui.then(LiteralArgumentBuilder.literal((String)alt).executes(key.getCommand())));
        }
        script.then((ArgumentBuilder)ui);
        root.then((ArgumentBuilder)script);
    }

    public static void sendFeedback(Component text) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)"\u00a7b[CLIENT]\u00a7r ").m_7220_(text));
    }

    public static class AtlasArgumentType
    implements ArgumentType<ResourceLocation> {
        public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
            ResourceLocation id = ResourceLocation.m_135818_((StringReader)reader);
            for (TextureAtlas sat : AtlasTracking.allAtlases) {
                if (!sat.m_118330_().equals((Object)id)) continue;
                return id;
            }
            throw new CommandRuntimeException((Component)Component.m_237113_((String)("There is no atlas with ID " + id)));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            for (TextureAtlas sat : AtlasTracking.allAtlases) {
                builder.suggest(sat.m_118330_().toString());
            }
            return builder.buildFuture();
        }

        public Collection<String> getExamples() {
            return Collections.singleton(InventoryMenu.f_39692_.toString());
        }
    }
}

