/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FabricationResourcePack
implements PackResources {
    private final String path;
    private final JsonObject meta;

    public FabricationResourcePack(String path) {
        JsonObject meta;
        this.path = path;
        try {
            meta = (JsonObject)new Gson().fromJson(Resources.toString((URL)this.url("pack.mcmeta"), (Charset)Charsets.UTF_8), JsonObject.class);
        }
        catch (Throwable t) {
            FabLog.warn("Failed to load meta for internal resource pack " + path);
            meta = new JsonObject();
        }
        this.meta = meta;
    }

    @OnlyIn(value=Dist.CLIENT)
    public InputStream m_5542_(String fileName) throws IOException {
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if ("pack.png".equals(fileName)) {
            return this.getClass().getClassLoader().getResourceAsStream("assets/fabrication/icon.png");
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.path + "/" + fileName);
        if (is == null) {
            throw new FileNotFoundException(fileName);
        }
        return is;
    }

    private URL url(PackType type, ResourceLocation id) {
        return this.url(type.m_10305_() + "/" + id.m_135827_() + "/" + id.m_135815_());
    }

    private URL url(String path) {
        return this.getClass().getClassLoader().getResource("packs/" + this.path + "/" + path);
    }

    public InputStream m_8031_(PackType type, ResourceLocation id) throws IOException {
        URL u = this.url(type, id);
        if (u == null) {
            throw new FileNotFoundException(id.toString());
        }
        return u.openStream();
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String namespace, String prefix, Predicate<ResourceLocation> allowedPathPredicate) {
        return Collections.emptySet();
    }

    public boolean m_7211_(PackType type, ResourceLocation id) {
        return this.url(type, id) != null;
    }

    public Set<String> m_5698_(PackType type) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.meta.getAsJsonObject("fabrication").getAsJsonArray("namespaces"), JsonElement::getAsString));
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) throws IOException {
        if (!this.meta.has(metaReader.m_7991_())) {
            return null;
        }
        return (T)metaReader.m_6322_(this.meta.getAsJsonObject(metaReader.m_7991_()));
    }

    public String m_8017_() {
        return MixinConfigPlugin.MOD_NAME;
    }

    public void close() {
    }
}

