/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.fabrication.FabLog;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class FeaturesFile {
    private static final ImmutableMap<String, FeatureEntry> data;
    private static final FeatureEntry defaultEntry;

    public static FeatureEntry get(String key) {
        return (FeatureEntry)data.getOrDefault((Object)key, (Object)defaultEntry);
    }

    public static ImmutableMap<String, FeatureEntry> getAll() {
        return data;
    }

    static {
        ImmutableMap.Builder bldr = ImmutableMap.builder();
        try (Reader r = Resources.asCharSource((URL)FeaturesFile.class.getClassLoader().getResource("features.json"), (Charset)Charsets.UTF_8).openStream();){
            JsonObject obj = (JsonObject)new Gson().fromJson(r, JsonObject.class);
            for (Map.Entry en : obj.entrySet()) {
                bldr.put((Object)((String)en.getKey()), (Object)new FeatureEntry((String)en.getKey(), ((JsonElement)en.getValue()).getAsJsonObject()));
            }
        }
        catch (Throwable t) {
            FabLog.warn("Failed to load features.json", t);
        }
        data = bldr.build();
        defaultEntry = new FeatureEntry("", new JsonObject());
    }

    public static final class FeatureEntry {
        public final String key;
        public final String name;
        public final String shortName;
        public final boolean meta;
        public final boolean section;
        public final boolean extra;
        public final String since;
        public final int sinceCode;
        public final Sides sides;
        public final ImmutableSet<String> needs;
        public final String parent;
        public final String media;
        public final String mediaText;
        public final String extraMedia;
        public final String extraMediaText;
        public final String linkUrl;
        public final String linkText;
        public final String desc;
        public final String fscript;
        public final ImmutableMap<String, Map.Entry<String, String>> extraFscript;
        public final String fscriptDefault;
        public final String extend;

        public FeatureEntry(String key, JsonObject obj) {
            this.key = key;
            this.name = FeatureEntry.get(obj, "name", JsonElement::getAsString, null);
            this.shortName = FeatureEntry.get(obj, "short_name", JsonElement::getAsString, null);
            this.meta = FeatureEntry.get(obj, "meta", JsonElement::getAsBoolean, false);
            this.section = FeatureEntry.get(obj, "section", JsonElement::getAsBoolean, false);
            this.extra = FeatureEntry.get(obj, "extra", JsonElement::getAsBoolean, false);
            this.since = FeatureEntry.get(obj, "since", JsonElement::getAsString, null);
            this.sinceCode = FeatureEntry.get(obj, "since_code", JsonElement::getAsInt, -1);
            this.sides = Sides.valueOf(FeatureEntry.get(obj, "sides", JsonElement::getAsString, "irrelevant").toUpperCase(Locale.ROOT));
            this.needs = ImmutableSet.copyOf((Collection)FeatureEntry.get(obj, "needs", FeatureEntry::getAsStringSet, Collections.emptySet()));
            this.parent = FeatureEntry.get(obj, "parent", JsonElement::getAsString, null);
            this.media = FeatureEntry.get(obj, "media", JsonElement::getAsString, null);
            this.mediaText = FeatureEntry.get(obj, "media_text", JsonElement::getAsString, null);
            this.extraMedia = FeatureEntry.get(obj, "extra_media", JsonElement::getAsString, null);
            this.extraMediaText = FeatureEntry.get(obj, "extra_media_text", JsonElement::getAsString, null);
            this.linkUrl = FeatureEntry.get(obj, "link_url", JsonElement::getAsString, null);
            this.linkText = FeatureEntry.get(obj, "link_text", JsonElement::getAsString, null);
            this.desc = FeatureEntry.get(obj, "desc", JsonElement::getAsString, "No description");
            this.fscript = FeatureEntry.get(obj, "fscript", s -> s.getAsString().toUpperCase(Locale.ROOT), null);
            this.extraFscript = FeatureEntry.get(obj, "extra_fscript", s -> {
                HashMap<String, AbstractMap.SimpleEntry<String, String>> map = new HashMap<String, AbstractMap.SimpleEntry<String, String>>();
                String[] strs = s.getAsString().split("\\+");
                for (int i = 0; i < strs.length; i += 3) {
                    map.put(strs[i].toUpperCase(Locale.ROOT), new AbstractMap.SimpleEntry<String, String>(strs[i + 1], strs[i + 2]));
                }
                return ImmutableMap.copyOf(map);
            }, ImmutableMap.of());
            this.fscriptDefault = FeatureEntry.get(obj, "fscript_default", JsonElement::getAsString, null);
            this.extend = FeatureEntry.get(obj, "extend", JsonElement::getAsString, null);
        }

        private static <T> T get(JsonObject obj, String key, Function<JsonElement, T> func, T def) {
            JsonElement ele = obj.get(key);
            if (ele == null || ele.isJsonNull()) {
                return def;
            }
            return func.apply(ele);
        }

        private static Set<String> getAsStringSet(JsonElement ele) {
            return Sets.newHashSet((Iterable)Iterables.transform((Iterable)ele.getAsJsonArray(), JsonElement::getAsString));
        }

        public String toString() {
            return "FeatureEntry [key=" + this.key + ", name=" + this.name + ", shortName=" + this.shortName + ", meta=" + this.meta + ", section=" + this.section + ", extra=" + this.extra + ", since=" + this.since + ", sinceCode=" + this.sinceCode + ", sides=" + this.sides + ", needs=" + this.needs + ", parent=" + this.parent + ", media=" + this.media + ", mediaText=" + this.mediaText + ", extraMedia=" + this.extraMedia + ", extraMediaText=" + this.extraMediaText + ", linkUrl=" + this.linkUrl + ", linkText=" + this.linkText + ", desc=" + this.desc + ", fscript=" + this.fscript + ", extraFscript" + this.extraFscript + ", fscriptDefault=" + this.fscriptDefault + ", extend=" + this.extend + "]";
        }
    }

    public static enum Sides {
        IRRELEVANT,
        EITHER,
        CLIENT_ONLY,
        SERVER_ONLY,
        SERVER_ONLY_WITH_CLIENT_HELPER,
        SERVER_AND_CLIENT;

    }
}

