/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.client.FabricationConfigScreen;
import com.unascribed.fabrication.client.PrideFlagRenderer;
import com.unascribed.fabrication.client.ScrollBar;
import com.unascribed.fabrication.loaders.LoaderBlockLogo;
import com.unascribed.fabrication.util.BlockLogoRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockLogoScreen
extends Screen {
    int selected = 0;
    int num = 0;
    int startY = LoaderBlockLogo.image.m_85084_() + 90;
    ScrollBar leftBar = new ScrollBar(this.f_96544_ - this.startY);
    ScrollBar rightBar;
    final Set<ResourceLocation> registryBlocks;
    Integer selectedColor;
    BlockLogoRenderer blockLogo;
    Pattern filter;
    boolean canFilter;
    Screen parent;
    PrideFlagRenderer prideFlag;
    boolean didClick;
    boolean didRClick;
    double lastMouseX;
    double lastMouseY;

    public BlockLogoScreen(Screen parent, PrideFlagRenderer prideFlag, String title, String configKey) {
        super((Component)Component.m_237113_((String)"Fabrication Block Logo"));
        this.rightBar = new ScrollBar(this.leftBar.displayHeight);
        this.registryBlocks = Registry.f_122824_.m_6566_();
        this.selectedColor = null;
        this.blockLogo = new BlockLogoRenderer();
        this.filter = Pattern.compile("");
        this.canFilter = false;
        this.parent = parent;
        this.prideFlag = prideFlag;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        BlockLogoScreen.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)this.f_96543_, (int)30, (int)(FabConf.isEnabled("general.dark_mode") ? 0x44FFFFFF : 0x55000000));
        BlockLogoScreen.m_93172_((PoseStack)matrices, (int)0, (int)this.startY, (int)(this.f_96543_ / 2), (int)this.f_96544_, (int)(FabConf.isEnabled("general.dark_mode") ? 0x44FFFFFF : 0x55000000));
        if (this.drawToggleButton(matrices, 5, 5, 60, 20, "Sound", mouseX, mouseY, LoaderBlockLogo.sound)) {
            LoaderBlockLogo.sound = !LoaderBlockLogo.sound;
            LoaderBlockLogo.instance.set("general.sound", String.valueOf(LoaderBlockLogo.sound));
        }
        if (this.drawToggleButton(matrices, 70, 5, 90, 20, "Reverse: " + LoaderBlockLogo.rawReverse.name(), mouseX, mouseY, false)) {
            int i2 = LoaderBlockLogo.rawReverse.ordinal() + 1;
            if (i2 >= LoaderBlockLogo.Reverse.values().length) {
                i2 = 0;
            }
            LoaderBlockLogo.rawReverse = LoaderBlockLogo.Reverse.values()[i2];
            LoaderBlockLogo.getReverse = LoaderBlockLogo.rawReverse.sup;
            LoaderBlockLogo.instance.set("general.reverse", LoaderBlockLogo.rawReverse.name().toLowerCase(Locale.ROOT));
        }
        this.f_96547_.m_92883_(matrices, "Shadow Color:", (float)(this.f_96543_ - 160), 2.0f, -1);
        if (this.filter.pattern().length() > 0) {
            this.f_96547_.m_92883_(matrices, "Filter:", (float)this.f_96543_ / 2.0f - 20.0f, 2.0f, -1);
            this.f_96547_.m_92883_(matrices, this.filter.toString(), (float)this.f_96543_ / 2.0f - 20.0f, 12.0f, -1);
        }
        if (this.drawNumSelectable(matrices, this.f_96543_ - 160, 12, 35, 15, "R: ", LoaderBlockLogo.rawShadowRed, mouseX, mouseY, 1)) {
            LoaderBlockLogo.rawShadowRed = this.num;
            LoaderBlockLogo.shadowRed = (float)this.num / 255.0f;
            this.num = 0;
            LoaderBlockLogo.instance.set("shadow.red", String.valueOf(LoaderBlockLogo.rawShadowRed));
        }
        if (this.drawNumSelectable(matrices, this.f_96543_ - 120, 12, 35, 15, "G: ", LoaderBlockLogo.rawShadowGreen, mouseX, mouseY, 2)) {
            LoaderBlockLogo.rawShadowGreen = this.num;
            LoaderBlockLogo.shadowGreen = (float)this.num / 255.0f;
            this.num = 0;
            LoaderBlockLogo.instance.set("shadow.green", String.valueOf(LoaderBlockLogo.rawShadowGreen));
        }
        if (this.drawNumSelectable(matrices, this.f_96543_ - 80, 12, 35, 15, "B: ", LoaderBlockLogo.rawShadowBlue, mouseX, mouseY, 3)) {
            LoaderBlockLogo.rawShadowBlue = this.num;
            LoaderBlockLogo.shadowBlue = (float)this.num / 255.0f;
            this.num = 0;
            LoaderBlockLogo.instance.set("shadow.blue", String.valueOf(LoaderBlockLogo.rawShadowBlue));
        }
        if (this.drawNumSelectable(matrices, this.f_96543_ - 40, 12, 35, 15, "A: ", LoaderBlockLogo.rawShadowAlpha, mouseX, mouseY, 4)) {
            LoaderBlockLogo.rawShadowAlpha = this.num;
            LoaderBlockLogo.shadowAlpha = (float)this.num / 255.0f;
            this.num = 0;
            LoaderBlockLogo.instance.set("shadow.alpha", String.valueOf(LoaderBlockLogo.rawShadowAlpha));
        }
        if (this.selectedColor == null) {
            float y = (float)(this.startY + 5) - this.leftBar.getScaledScroll(this.f_96541_);
            for (int clr : LoaderBlockLogo.validColors) {
                if (y >= (float)this.startY) {
                    this.f_96547_.m_92883_(matrices, String.valueOf(clr), 5.2f, y + 0.2f, clr ^ 0xFFFFFF);
                    this.f_96547_.m_92883_(matrices, String.valueOf(clr), 5.0f, y, clr);
                }
                if (this.didClick && mouseX >= 0 && mouseX <= this.f_96543_ / 2 && (float)mouseY > y && (float)mouseY < y + 12.0f) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)1.2f, (float)1.0f));
                    this.selectedColor = clr;
                    this.filter = Pattern.compile("");
                    if (!LoaderBlockLogo.fullColorToState.containsKey(clr)) {
                        LoaderBlockLogo.fullColorToState.put(clr, new ArrayList());
                    }
                }
                if (!((y += 12.0f) > (float)this.f_96544_)) continue;
                break;
            }
            this.leftBar.height = LoaderBlockLogo.validColors.size() * 12 + 8;
        } else {
            float y = (float)(this.startY + 5) - this.leftBar.getScaledScroll(this.f_96541_);
            for (ResourceLocation clr : this.registryBlocks) {
                if (!this.filter.matcher(clr.toString()).find()) continue;
                if (y >= (float)this.startY) {
                    this.f_96547_.m_92750_(matrices, clr.toString(), 5.0f, y, -1);
                }
                if (this.didClick && mouseX >= 0 && mouseX <= this.f_96543_ / 2 && (float)mouseY > y && (float)mouseY < y + 12.0f && y > (float)this.startY) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)1.2f, (float)1.0f));
                    List<String> l = LoaderBlockLogo.fullColorToState.get(this.selectedColor);
                    l.add(clr.toString());
                    LoaderBlockLogo.colorToState.put(this.selectedColor, () -> {
                        String block = (String)l.get(ThreadLocalRandom.current().nextInt(l.size()));
                        try {
                            return BlockStateParser.m_234700_((Registry)Registry.f_122824_, (StringReader)new StringReader(block), (boolean)false).f_234748_();
                        }
                        catch (CommandSyntaxException e) {
                            FabLog.warn(block + " is not a valid identifier");
                            return Blocks.f_50016_.m_49966_();
                        }
                    });
                    LoaderBlockLogo.instance.set("pixels." + String.format("%06x", this.selectedColor), String.join((CharSequence)" ", l));
                }
                if (!((y += 12.0f) > (float)this.f_96544_)) continue;
                break;
            }
            this.leftBar.height = this.registryBlocks.stream().filter(i -> this.filter.matcher(i.toString()).find()).count() * 12L + 8L;
            y = (float)this.startY - this.rightBar.getScaledScroll(this.f_96541_);
            List<String> blocks = LoaderBlockLogo.fullColorToState.get(this.selectedColor);
            for (int i3 = 0; i3 < blocks.size(); ++i3) {
                String clr = blocks.get(i3);
                if (!(y < (float)this.startY)) {
                    this.f_96547_.m_92750_(matrices, clr, (float)this.f_96543_ / 2.0f + 5.0f, y, -1);
                }
                if (this.didRClick && mouseX >= 0 && mouseX > this.f_96543_ / 2 && (float)mouseY > y && (float)mouseY < y + 12.0f && y > (float)this.startY) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)1.2f, (float)1.0f));
                    blocks.remove(clr);
                    if (blocks.size() < 1) {
                        LoaderBlockLogo.colorToState.remove(this.selectedColor);
                        LoaderBlockLogo.fullColorToState.get(this.selectedColor).clear();
                        LoaderBlockLogo.instance.remove("pixels." + String.format("%06x", this.selectedColor));
                    } else {
                        LoaderBlockLogo.colorToState.put(this.selectedColor, () -> {
                            String block = (String)blocks.get(ThreadLocalRandom.current().nextInt(blocks.size()));
                            try {
                                return BlockStateParser.m_234700_((Registry)Registry.f_122824_, (StringReader)new StringReader(block), (boolean)false).f_234748_();
                            }
                            catch (CommandSyntaxException e) {
                                FabLog.warn(block + " is not a valid identifier");
                                return Blocks.f_50016_.m_49966_();
                            }
                        });
                        LoaderBlockLogo.instance.set("pixels." + String.format("%06x", this.selectedColor), String.join((CharSequence)" ", blocks));
                    }
                }
                if ((y += 12.0f) > (float)this.f_96544_) break;
            }
            this.rightBar.height = blocks.size() * 12 + 8;
        }
        this.blockLogo.drawLogo(false, 0L, delta);
        if (this.didClick) {
            this.didClick = false;
        }
        if (this.didRClick) {
            this.didRClick = false;
        }
    }

    private boolean drawNumSelectable(PoseStack matrices, int x, int y, int w, int h, String text, int val, float mouseX, float mouseY, int index) {
        if (this.didRClick && mouseX >= (float)x && mouseX <= (float)(x + w) && mouseY >= (float)y && mouseY <= (float)(y + h)) {
            this.num = 0;
            this.selected = 0;
            return true;
        }
        if (this.didClick && this.selected == index) {
            if (this.num > 255) {
                this.num = 255;
            }
            if (this.num < 0) {
                this.num = 0;
            }
            this.selected = 0;
            return true;
        }
        if (this.drawToggleButton(matrices, x, y, w, h, text + (this.num == 0 || this.selected != index ? val : this.num), mouseX, mouseY, this.selected == index)) {
            this.selected = index;
            this.num = val;
            return false;
        }
        return false;
    }

    private boolean drawToggleButton(PoseStack matrices, int x, int y, int w, int h, String text, float mouseX, float mouseY, boolean toggle) {
        return FabricationConfigScreen.drawToggleButton(matrices, x, y, w, h, text, mouseX, mouseY, toggle, this.didClick, this.f_96541_);
    }

    public void m_86600_() {
        super.m_86600_();
        this.blockLogo.tick();
        this.leftBar.tick();
        this.rightBar.tick();
    }

    public void m_7333_(PoseStack matrices) {
        FabricationConfigScreen.drawBackground(this.f_96544_, this.f_96543_, this.f_96541_, this.prideFlag, 0.0f, matrices, 0, 0, 0.0f, 0, 0);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if ((double)(LoaderBlockLogo.image.m_85084_() + 90) > mouseY && mouseY > 40.0) {
                LoaderBlockLogo.reloadImage();
                this.startY = LoaderBlockLogo.image.m_85084_() + 90;
                this.blockLogo = new BlockLogoRenderer();
            }
            this.didClick = true;
        } else if (button == 1) {
            if (this.filter.pattern().length() != 0 && mouseY < 40.0 && mouseX > (double)((float)this.f_96543_ / 2.0f - 40.0f) && mouseY < (double)((float)this.f_96543_ / 2.0f + 40.0f)) {
                this.filter = Pattern.compile("");
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)1.2f, (float)1.0f));
            }
            if (this.selectedColor != null && (double)(LoaderBlockLogo.image.m_85084_() + 90) < mouseY && mouseX < (double)this.f_96543_ / 2.0) {
                this.filter = Pattern.compile("");
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)1.2f, (float)1.0f));
                this.selectedColor = null;
            }
            this.didRClick = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (mouseY >= (double)this.startY) {
            if (mouseX <= (double)this.f_96543_ / 2.0) {
                this.leftBar.scroll(amount * 20.0);
            } else {
                this.rightBar.scroll(amount * 20.0);
            }
        } else if (mouseY < 40.0 && mouseX > (double)(this.f_96543_ - 160) && this.selected != 0) {
            this.num = (int)((double)this.num + amount);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 266: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 20.0);
                break;
            }
            case 267: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -20.0);
                break;
            }
            case 265: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 2.0);
                break;
            }
            case 264: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -2.0);
            }
        }
        if (this.selected != 0) {
            if (keyCode == 259) {
                this.num = 0;
            } else if (keyCode >= 320 && keyCode <= 329) {
                this.num = this.num * 10 + keyCode - 320;
            } else if (keyCode >= 48 && keyCode <= 57) {
                this.num = this.num * 10 + keyCode - 48;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.selectedColor != null) {
            if (!this.canFilter) {
                this.canFilter = true;
            }
            if (keyCode == 259) {
                String str = this.filter.pattern();
                if (BlockLogoScreen.m_96638_() || str.length() == 1) {
                    this.filter = Pattern.compile("");
                } else if (str.length() != 0) {
                    this.filter = Pattern.compile(str.substring(0, str.length() - 1), 18);
                }
            }
        } else if (this.canFilter) {
            this.canFilter = false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.canFilter) {
            this.filter = Pattern.compile(this.filter.pattern() + chr, 18);
        }
        return super.m_5534_(chr, modifiers);
    }

    public void m_6574_(Minecraft client, int width, int height) {
        this.rightBar.displayHeight = this.leftBar.displayHeight = (float)(height - this.startY);
        super.m_6574_(client, width, height);
    }
}

