/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.FabricationModClient;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.client.BlockLogoScreen;
import com.unascribed.fabrication.client.ClassicBlockDropsScreen;
import com.unascribed.fabrication.client.FabricationSummaryScreen;
import com.unascribed.fabrication.client.OptionalFScriptScreen;
import com.unascribed.fabrication.client.OptionalPrideFlag;
import com.unascribed.fabrication.client.PrideFlagRenderer;
import com.unascribed.fabrication.client.SelectionScreen;
import com.unascribed.fabrication.client.TaggablePlayersScreen;
import com.unascribed.fabrication.client.YeetRecipesScreen;
import com.unascribed.fabrication.compat.FabricLoader;
import com.unascribed.fabrication.interfaces.GetServerConfig;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.ArrayUtils;

public class FabricationConfigScreen
extends Screen {
    private final Map<String, String> SECTION_DESCRIPTIONS = Maps.newHashMap();
    private static final ResourceLocation BG = new ResourceLocation("fabrication", "bg.png");
    private static final ResourceLocation BG_DARK = new ResourceLocation("fabrication", "bg-dark.png");
    private static final ResourceLocation BG_GRAD = new ResourceLocation("fabrication", "bg-grad.png");
    private static final ResourceLocation BG_GRAD_DARK = new ResourceLocation("fabrication", "bg-grad-dark.png");
    private static long serverLaunchId = -1L;
    private static final Set<String> newlyBannedKeysClient = Sets.newHashSet();
    private static final Set<String> newlyBannedKeysServer = Sets.newHashSet();
    private static final Set<String> newlyUnbannedKeysClient = Sets.newHashSet();
    private static final Set<String> newlyUnbannedKeysServer = Sets.newHashSet();
    private static boolean isFScriptLoaded = EarlyAgnos.isModLoaded("fscript");
    private final Screen parent;
    private final PrideFlagRenderer prideFlag;
    private float timeExisted;
    private boolean leaving = false;
    private float timeLeaving;
    private float sidebarScrollTarget;
    private float sidebarScroll;
    private float lastSidebarScroll;
    private float sidebarHeight;
    private boolean didClick;
    private boolean mouseDragging;
    private int lastDragY;
    private float selectTime;
    private String selectedSection;
    private String prevSelectedSection;
    private float selectedSectionHeight;
    private float prevSelectedSectionHeight;
    private float selectedSectionScroll;
    private float prevSelectedSectionScroll;
    private float lastSelectedSectionScroll;
    private float lastPrevSelectedSectionScroll;
    private float selectedSectionScrollTarget;
    private float prevSelectedSectionScrollTarget;
    private int tooltipBlinkTicks = 0;
    private boolean configuringServer;
    private boolean hasClonked = true;
    private boolean isSingleplayer;
    private boolean editingWorldPath;
    private float serverAnimateTime;
    private String whyCantConfigureServer = null;
    private Set<String> serverKnownConfigKeys = Sets.newHashSet();
    private boolean serverReadOnly;
    private final List<String> tabs = Lists.newArrayList();
    private final Multimap<String, String> options = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), Lists::newArrayList);
    private final Map<String, ConfigValues.Feature> optionPreviousValues = Maps.newHashMap();
    private final Map<String, Float> optionAnimationTime = Maps.newHashMap();
    private final Map<String, Float> disabledAnimationTime = Maps.newHashMap();
    private final Map<String, Float> becomeBanAnimationTime = Maps.newHashMap();
    private final Set<String> knownDisabled = Sets.newHashSet();
    private final Set<String> onlyBannableds = Sets.newHashSet();
    private final Map<String, Map<String, FeatureSubmenu>> submenus = new HashMap<String, Map<String, FeatureSubmenu>>();
    private boolean bufferTooltips = false;
    private final List<Runnable> bufferedTooltips = Lists.newArrayList();
    private int noteIndex = 0;
    private EditBox searchField;
    private Pattern queryPattern = Pattern.compile("");
    private boolean emptyQuery = true;
    private boolean searchingScriptable = false;
    private double lastMouseX;
    private double lastMouseY;

    public FabricationConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)(MixinConfigPlugin.MOD_NAME + " configuration")));
        this.parent = parent;
        this.prideFlag = OptionalPrideFlag.get();
        for (String sec : FabConf.getAllSections()) {
            this.SECTION_DESCRIPTIONS.put(sec, FeaturesFile.get((String)sec).desc);
        }
        for (String key : FabConf.getAllKeys()) {
            int dot = key.indexOf(46);
            String section = key.substring(0, dot);
            String name = key.substring(dot + 1);
            this.options.put((Object)section, (Object)name);
        }
        if (isFScriptLoaded) {
            for (Map.Entry en : FeaturesFile.getAll().entrySet()) {
                String key = (String)en.getKey();
                FeaturesFile.FeatureEntry feature = (FeaturesFile.FeatureEntry)en.getValue();
                if (feature.fscript == null && (feature.extend == null || FeaturesFile.get((String)FabConf.remap((String)feature.extend)).fscript == null)) continue;
                this.defaultedSubmenu(key).put("FScript", OptionalFScriptScreen::construct);
            }
        }
        this.defaultedSubmenu(FabConf.remap("*.block_logo")).put("Detailed Configs", BlockLogoScreen::new);
        this.defaultedSubmenu(FabConf.remap("*.yeet_recipes")).put("Detailed Configs", YeetRecipesScreen::new);
        this.defaultedSubmenu(FabConf.remap("*.taggable_players")).put("Detailed Configs", TaggablePlayersScreen::new);
        this.defaultedSubmenu(FabConf.remap("*.classic_block_drops")).put("Detailed Configs", ClassicBlockDropsScreen::new);
        this.tabs.add("search");
        this.tabs.addAll(this.options.keySet());
    }

    private Map<String, FeatureSubmenu> defaultedSubmenu(String key) {
        if (!this.submenus.containsKey(key)) {
            HashMap<String, FeatureSubmenu> map = new HashMap<String, FeatureSubmenu>();
            this.submenus.put(key, map);
            return map;
        }
        return this.submenus.get(key);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.isSingleplayer = false;
        if (this.f_96541_.f_91073_ == null) {
            if (!this.editingWorldPath) {
                FabConf.setWorldPath(null);
            }
        } else if (this.f_96541_.m_91092_() != null) {
            this.isSingleplayer = true;
        } else {
            CommandDispatcher disp = this.f_96541_.f_91074_.f_108617_.m_105146_();
            CommandNode root = disp.getRoot().getChild(MixinConfigPlugin.MOD_NAME_LOWER);
            if (root == null) {
                root = disp.getRoot().getChild(MixinConfigPlugin.MOD_NAME_LOWER_OTHER);
            }
            if (root == null) {
                this.whyCantConfigureServer = "This server doesn't have " + MixinConfigPlugin.MOD_NAME + ".";
            } else {
                ClientPacketListener cpnh = this.f_96541_.m_91403_();
                if (cpnh instanceof GetServerConfig) {
                    GetServerConfig gsc = (GetServerConfig)cpnh;
                    if (!gsc.fabrication$hasHandshook()) {
                        this.whyCantConfigureServer = "This server's version of " + MixinConfigPlugin.MOD_NAME + " is too old.";
                    } else {
                        CommandNode config = root.getChild("config");
                        this.serverReadOnly = config == null || config.getChild("set") == null;
                        this.serverKnownConfigKeys.clear();
                        this.serverKnownConfigKeys.addAll(gsc.fabrication$getServerTrileanConfig().keySet());
                        this.serverKnownConfigKeys.addAll(gsc.fabrication$getServerStringConfig().keySet());
                    }
                } else {
                    this.whyCantConfigureServer = "An internal error prevented initialization of the syncer.";
                }
            }
        }
        this.searchField = new EditBox(this.f_96547_, 131, 1, this.f_96543_ - 252, 14, this.searchField, (Component)Component.m_237113_((String)"Search"));
        if (isFScriptLoaded) {
            this.searchField.m_93674_(this.searchField.m_5711_() - 16);
        }
        this.searchField.m_94151_(s -> {
            s = s.trim();
            this.emptyQuery = s.isEmpty();
            this.queryPattern = Pattern.compile(s, 18);
        });
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.timeExisted == 0.0f && !FabConf.isEnabled("*.reduced_motion")) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12558_, (float)2.0f, (float)0.1f));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11725_, (float)1.2f));
        }
        this.timeExisted += delta;
        if (this.leaving) {
            this.timeLeaving += delta;
        }
        if ((this.leaving || this.timeExisted < 10.0f) && !FabConf.isEnabled("*.reduced_motion")) {
            float a = FabricationConfigScreen.sCurve5((this.leaving ? Math.max(0.0f, 10.0f - this.timeLeaving) : this.timeExisted) / 10.0f);
            matrices.m_85836_();
            matrices.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)this.f_96544_, 0.0);
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(a * (float)(this.leaving ? -180 : 180)));
            matrices.m_85837_((double)(-this.f_96543_ / 2), (double)(-this.f_96544_), 0.0);
            matrices.m_85836_();
            matrices.m_85837_(0.0, (double)this.f_96544_, 0.0);
            matrices.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)((float)this.f_96544_ / 2.0f), 0.0);
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            matrices.m_85837_((double)((float)(-this.f_96543_) / 2.0f), (double)((float)(-this.f_96544_) / 2.0f), 0.0);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(-this.f_96543_), (int)(-this.f_96544_), (int)(this.f_96543_ * 2), (int)0, (int)(FabConf.isEnabled("general.dark_mode") ? -14606304 : -14575885));
            matrices.m_85836_();
            this.drawBackground(matrices, -200, -200, delta, 0, 0);
            this.drawForeground(matrices, -200, -200, delta);
            matrices.m_85849_();
            matrices.m_85849_();
            matrices.m_85849_();
            if (this.parent != null) {
                PoseStack projection = new PoseStack();
                projection.m_166854_(RenderSystem.m_157192_());
                projection.m_85836_();
                projection.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)this.f_96544_, 0.0);
                projection.m_85845_(Vector3f.f_122227_.m_122240_(a * (float)(this.leaving ? -180 : 180)));
                projection.m_85837_((double)(-this.f_96543_ / 2), (double)(-this.f_96544_), 0.0);
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 0; ++y) {
                        if (x == 0 && y == 0) continue;
                        projection.m_85836_();
                        projection.m_85837_((double)(this.f_96543_ * x), (double)(this.f_96544_ * y), 0.0);
                        RenderSystem.m_157425_((Matrix4f)projection.m_85850_().m_85861_());
                        this.parent.m_96626_(0);
                        projection.m_85849_();
                    }
                }
                RenderSystem.m_157425_((Matrix4f)projection.m_85850_().m_85861_());
                this.parent.m_6305_(matrices, -200, -200, delta);
                projection.m_85849_();
                RenderSystem.m_157425_((Matrix4f)projection.m_85850_().m_85861_());
            }
        } else {
            matrices.m_85836_();
            this.drawBackground(matrices, mouseX, mouseY, delta, 0, 0);
            this.drawForeground(matrices, mouseX, mouseY, delta);
            matrices.m_85849_();
        }
        if (this.leaving && this.timeLeaving > 10.0f) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public void m_7333_(PoseStack matrices) {
        FabricationConfigScreen.drawBackground(this.f_96544_, this.f_96543_, this.f_96541_, this.prideFlag, 0.0f, matrices, 0, 0, 0.0f, 0, 0);
    }

    private void drawBackground(PoseStack matrices, int mouseX, int mouseY, float delta, int cutoffX, int cutoffY) {
        FabricationConfigScreen.drawBackground(this.f_96544_, this.f_96543_, this.f_96541_, this.prideFlag, this.selectedSection == null ? 10.0f - this.selectTime : (this.prevSelectedSection == null ? this.selectTime : 0.0f), matrices, mouseX, mouseY, delta, cutoffX, cutoffY);
    }

    public static void drawBackground(int height, int width, Minecraft client, PrideFlagRenderer prideFlag, float time, PoseStack matrices, int mouseX, int mouseY, float delta, int cutoffX, int cutoffY) {
        float cutoffV = (float)cutoffY / (float)height;
        ResourceLocation bg = FabConf.isEnabled("general.dark_mode") ? BG_DARK : BG;
        ResourceLocation bgGrad = FabConf.isEnabled("general.dark_mode") ? BG_GRAD_DARK : BG_GRAD;
        BufferBuilder bb = Tesselator.m_85913_().m_85915_();
        Matrix4f mat = matrices.m_85850_().m_85861_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69464_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)bgGrad);
        client.m_91097_().m_174784_(bgGrad);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        int startX = cutoffX == 0 ? -width : cutoffX;
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bb.m_85982_(mat, (float)startX, (float)cutoffY, 0.0f).m_7421_(0.0f, cutoffV).m_5752_();
        bb.m_85982_(mat, (float)(width * 2), (float)cutoffY, 0.0f).m_7421_(1.0f, cutoffV).m_5752_();
        bb.m_85982_(mat, (float)(width * 2), (float)height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bb.m_85982_(mat, (float)startX, (float)height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
        float ratio = 0.4648148f;
        float w = (float)height * ratio;
        float brk = Math.min((float)width - w, (float)(width * 2) / 3.0f - w / 3.0f);
        float brk2 = brk + w;
        float border = (float)(20.0 / client.m_91268_().m_85449_());
        if (brk < (float)cutoffX) {
            brk = cutoffX;
        }
        float top = 0.5277778f * (float)height;
        float bottom = 0.8342593f * (float)height;
        if ((float)cutoffY < bottom) {
            float h = bottom - top;
            float flagCutoffV = 0.0f;
            if (top < (float)cutoffY) {
                top = cutoffY;
                flagCutoffV = 1.0f - (bottom - top) / h;
            }
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            if (prideFlag != null) {
                prideFlag.render(matrices, brk, top, w, bottom - top);
            } else {
                RenderSystem.m_69472_();
                bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                float r = Mth.m_14179_((float)flagCutoffV, (float)0.298f, (float)0.475f);
                float g = Mth.m_14179_((float)flagCutoffV, (float)0.686f, (float)0.333f);
                float b = Mth.m_14179_((float)flagCutoffV, (float)0.314f, (float)0.282f);
                bb.m_85982_(mat, brk, top, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                bb.m_85982_(mat, brk2, top, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                bb.m_85982_(mat, brk2, bottom, 0.0f).m_85950_(0.475f, 0.333f, 0.282f, 1.0f).m_5752_();
                bb.m_85982_(mat, brk, bottom, 0.0f).m_85950_(0.475f, 0.333f, 0.282f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
                RenderSystem.m_69493_();
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)bg);
        client.m_91097_().m_174784_(bg);
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bb.m_85982_(mat, Math.max((float)cutoffX, border), (float)cutoffY, 0.0f).m_7421_(0.0f, cutoffV).m_5752_();
        bb.m_85982_(mat, brk, (float)cutoffY, 0.0f).m_7421_(0.0f, cutoffV).m_5752_();
        bb.m_85982_(mat, brk, (float)height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bb.m_85982_(mat, Math.max((float)cutoffX, border), (float)height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bb.m_85982_(mat, brk, (float)cutoffY, 0.0f).m_7421_(0.0f, cutoffV).m_5752_();
        bb.m_85982_(mat, brk2, (float)cutoffY, 0.0f).m_7421_(1.0f, cutoffV).m_5752_();
        bb.m_85982_(mat, brk2, (float)height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bb.m_85982_(mat, brk, (float)height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bb.m_85982_(mat, brk2, (float)cutoffY, 0.0f).m_7421_(1.0f, cutoffV).m_5752_();
        bb.m_85982_(mat, (float)width - border, (float)cutoffY, 0.0f).m_7421_(1.0f, cutoffV).m_5752_();
        bb.m_85982_(mat, (float)width - border, (float)height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bb.m_85982_(mat, brk2, (float)height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
        float a = 1.0f - (0.3f + FabricationConfigScreen.sCurve5(time / 10.0f) * 0.7f);
        if (a > 0.0f) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            RenderSystem.m_157456_((int)0, (ResourceLocation)bgGrad);
            bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bb.m_85982_(mat, (float)startX, (float)cutoffY, 0.0f).m_7421_(0.0f, cutoffV).m_5752_();
            bb.m_85982_(mat, (float)(width * 2), (float)cutoffY, 0.0f).m_7421_(1.0f, cutoffV).m_5752_();
            bb.m_85982_(mat, (float)(width * 2), (float)height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bb.m_85982_(mat, (float)startX, (float)height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int lerpColor(int from, int to, float delta) {
        float a = Mth.m_14179_((float)delta, (float)((float)(from >> 24 & 0xFF) / 255.0f), (float)((float)(to >> 24 & 0xFF) / 255.0f));
        float r = Mth.m_14179_((float)delta, (float)((float)(from >> 16 & 0xFF) / 255.0f), (float)((float)(to >> 16 & 0xFF) / 255.0f));
        float g = Mth.m_14179_((float)delta, (float)((float)(from >> 8 & 0xFF) / 255.0f), (float)((float)(to >> 8 & 0xFF) / 255.0f));
        float b = Mth.m_14179_((float)delta, (float)((float)(from >> 0 & 0xFF) / 255.0f), (float)((float)(to >> 0 & 0xFF) / 255.0f));
        int c = 0;
        c |= ((int)(a * 255.0f) & 0xFF) << 24;
        c |= ((int)(r * 255.0f) & 0xFF) << 16;
        c |= ((int)(g * 255.0f) & 0xFF) << 8;
        return c |= ((int)(b * 255.0f) & 0xFF) << 0;
    }

    private void drawForeground(PoseStack matrices, int mouseX, int mouseY, float delta) {
        Set<String> newlyUnbannedKeys;
        Set<String> newlyBannedKeys;
        float a;
        if (this.serverAnimateTime > 0.0f) {
            this.serverAnimateTime -= delta;
        }
        if (this.serverAnimateTime < 0.0f) {
            this.serverAnimateTime = 0.0f;
        }
        if (this.selectTime > 0.0f) {
            this.selectTime -= delta;
        }
        if (this.selectTime < 0.0f) {
            this.selectTime = 0.0f;
        }
        if ((double)(a = FabricationConfigScreen.sCurve5(this.serverAnimateTime / 10.0f)) <= 0.05 && !this.hasClonked) {
            this.hasClonked = true;
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11712_, (float)1.0f, (float)0.5f));
        }
        if (this.configuringServer || this.editingWorldPath) {
            a = 1.0f - a;
        }
        FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(-this.f_96543_), (int)(-this.f_96544_), (int)130, (int)this.f_96544_, (int)0x44000000);
        float scroll = this.sidebarHeight < (float)this.f_96544_ ? 0.0f : this.lastSidebarScroll + (this.sidebarScroll - this.lastSidebarScroll) * this.f_96541_.m_91296_();
        scroll = (float)(Math.floor((double)scroll * this.f_96541_.m_91268_().m_85449_()) / this.f_96541_.m_91268_().m_85449_());
        float y = 8.0f - scroll;
        int newHeight = 8;
        int i = 0;
        float selectedChoiceY = -60.0f;
        float prevSelectedChoiceY = -60.0f;
        for (String s : this.tabs) {
            float selectA;
            int thisHeight = 8;
            if (s.equals(this.selectedSection)) {
                selectA = FabricationConfigScreen.sCurve5((10.0f - this.selectTime) / 10.0f);
                selectedChoiceY = y;
            } else if (s.equals(this.prevSelectedSection)) {
                selectA = FabricationConfigScreen.sCurve5(this.selectTime / 10.0f);
                prevSelectedChoiceY = y;
            } else {
                selectA = 0.0f;
            }
            float startY = y;
            int icoY = 0;
            int size = 28;
            if ("search".equals(s)) {
                size = 12;
                icoY = -4;
            }
            ResourceLocation id = new ResourceLocation("fabrication", "category/" + s + ".png");
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            this.f_96541_.m_91097_().m_174784_(id);
            RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
            RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)id);
            matrices.m_85836_();
            matrices.m_85837_((double)(126 - size), (double)((float)icoY + y), 0.0);
            matrices.m_85845_(Vector3f.f_122227_.m_122240_(5.0f));
            FabricationConfigScreen.m_93143_((PoseStack)matrices, (int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)size, (int)Math.min(size, (int)Math.ceil((float)this.f_96544_ - y)), (int)size, (int)size);
            matrices.m_85849_();
            this.f_96547_.m_92883_(matrices, "\u00a7l" + FeaturesFile.get((String)s).shortName, 4.0f, y, -1);
            y += 12.0f;
            thisHeight += 12;
            if (!"search".equals(s)) {
                String desc = this.SECTION_DESCRIPTIONS.getOrDefault(s, "No description available");
                int x = 8;
                boolean line = false;
                for (String word : Splitter.on((CharMatcher)CharMatcher.whitespace()).split((CharSequence)desc)) {
                    int w = this.f_96547_.m_92895_(word);
                    if (x + w > 100 && !line) {
                        x = 8;
                        y += 12.0f;
                        newHeight += 12;
                        line = true;
                    }
                    x = this.f_96547_.m_92883_(matrices, word + " ", (float)x, y, -1);
                }
                y += 12.0f;
                thisHeight += 12;
            }
            if (this.didClick && mouseX >= 0 && mouseX <= 130 && (float)mouseY > startY - 4.0f && (float)mouseY < y) {
                boolean deselect = s.equals(this.selectedSection);
                if ("search".equals(s) && !deselect) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12216_, (float)1.2f, (float)1.0f));
                } else {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12210_, (float)(deselect ? 0.5f : 0.6f + (float)i * 0.1f), (float)1.0f));
                }
                this.prevSelectedSection = this.selectedSection;
                this.selectedSection = deselect ? null : s;
                this.prevSelectedSectionScroll = this.selectedSectionScroll;
                this.lastPrevSelectedSectionScroll = this.lastSelectedSectionScroll;
                this.prevSelectedSectionHeight = this.selectedSectionHeight;
                this.prevSelectedSectionScrollTarget = this.selectedSectionScrollTarget;
                this.selectedSectionScroll = 0.0f;
                this.lastSelectedSectionScroll = 0.0f;
                this.selectedSectionHeight = 0.0f;
                this.selectedSectionScrollTarget = 0.0f;
                this.selectTime = 10.0f - this.selectTime;
            }
            if (selectA > 0.0f) {
                RenderSystem.m_69464_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69472_();
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                BufferBuilder bb = Tesselator.m_85913_().m_85915_();
                Matrix4f mat = matrices.m_85850_().m_85861_();
                bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                bb.m_85982_(mat, 0.0f, y - (float)thisHeight - 8.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.2f).m_5752_();
                bb.m_85982_(mat, 130.0f * selectA, y - (float)thisHeight - 8.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.2f + (1.0f - selectA) * 0.8f).m_5752_();
                bb.m_85982_(mat, 130.0f * selectA, y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.2f + (1.0f - selectA) * 0.8f).m_5752_();
                bb.m_85982_(mat, 0.0f, y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 0.2f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
                RenderSystem.m_69493_();
            }
            y += 8.0f;
            newHeight += thisHeight;
            ++i;
        }
        this.sidebarHeight = newHeight;
        if (this.sidebarHeight >= (float)this.f_96544_) {
            float knobHeight = (float)this.f_96544_ / this.sidebarHeight * (float)this.f_96544_;
            float knobY = scroll / (this.sidebarHeight - (float)this.f_96544_) * ((float)this.f_96544_ - knobHeight);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)128, (int)((int)knobY), (int)130, (int)((int)(knobY + knobHeight)), (int)-1426063361);
        }
        this.bufferTooltips = true;
        float selectedA = FabricationConfigScreen.sCurve5((10.0f - this.selectTime) / 10.0f);
        float prevSelectedA = FabricationConfigScreen.sCurve5(this.selectTime / 10.0f);
        this.drawSection(matrices, this.selectedSection, mouseX, mouseY, selectedChoiceY, selectedA, true);
        if (!FabConf.isEnabled("general.reduced_motion") && !Objects.equal((Object)this.selectedSection, (Object)this.prevSelectedSection)) {
            this.drawSection(matrices, this.prevSelectedSection, -200.0f, -200.0f, prevSelectedChoiceY, prevSelectedA, false);
        }
        boolean searchSelected = "search".equals(this.selectedSection);
        boolean searchWasSelected = "search".equals(this.prevSelectedSection);
        if (searchSelected) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)selectedA);
            this.searchField.m_93650_(selectedA);
            this.searchField.m_6305_(matrices, mouseX, mouseY, delta);
        } else if (searchWasSelected && prevSelectedA > 0.0f) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)prevSelectedA);
            this.searchField.m_93650_(prevSelectedA);
            this.searchField.m_6305_(matrices, mouseX, mouseY, delta);
        }
        this.searchField.m_94178_(searchSelected);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.m_85836_();
        RenderSystem.m_69465_();
        FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(this.f_96543_ - 120), (int)0, (int)(this.f_96543_ * 2), (int)16, (int)0x33000000);
        matrices.m_85836_();
        matrices.m_85837_((double)(this.f_96543_ - 60), 8.0, 0.0);
        matrices.m_85836_();
        matrices.m_85845_(Vector3f.f_122227_.m_122240_(a * -180.0f));
        float h = (40.0f + a * -100.0f) / 360.0f;
        if (h < 0.0f) {
            h = 1.0f + h;
        }
        matrices.m_85836_();
        matrices.m_85841_((float)(1.0 - Math.abs(Math.sin((double)a * Math.PI)) / 2.0), 1.0f, 1.0f);
        FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)-60, (int)-8, (int)0, (int)8, (int)(Mth.m_14169_((float)h, (float)0.9f, (float)0.9f) | 0xFF000000));
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85845_(Vector3f.f_122227_.m_122240_(45.0f));
        float f = 5.656854f;
        matrices.m_85841_(f, f, 1.0f);
        FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)-1, (int)-1, (int)1, (int)1, (int)-1);
        matrices.m_85849_();
        FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)-6, (int)-1, (int)-2, (int)1, (int)-16777216);
        matrices.m_85849_();
        FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)-2, (int)-2, (int)2, (int)2, (int)-16777216);
        matrices.m_85849_();
        boolean darkMode = FabConf.isEnabled("general.dark_mode");
        this.f_96547_.m_92883_(matrices, "CLIENT", (float)(this.f_96543_ - 115), 4.0f, -16777216);
        if (this.f_96541_.f_91073_ == null || this.isSingleplayer) {
            this.f_96547_.m_92883_(matrices, "WORLD", (float)(this.f_96543_ - 40), 4.0f, -16777216);
        } else {
            this.f_96547_.m_92883_(matrices, "SERVER", (float)(this.f_96543_ - 40), 4.0f, this.whyCantConfigureServer == null ? -16777216 : (darkMode ? 0x44FFFFFF : 0x44000000));
            if (this.serverReadOnly && this.whyCantConfigureServer == null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("fabrication", "lock.png"));
                RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                FabricationConfigScreen.m_93143_((PoseStack)matrices, (int)(this.f_96543_ - 49), (int)3, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)8, (int)8);
            }
        }
        if (searchSelected && isFScriptLoaded) {
            if (this.didClick && mouseX >= this.f_96543_ - 136 && mouseX < this.f_96543_ - 120 && mouseY <= 16) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                this.searchingScriptable = !this.searchingScriptable;
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("fabrication", "fscript.png"));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(this.f_96543_ - 136), (int)0, (int)(this.f_96543_ - 120), (int)16, (int)(this.searchingScriptable ? -16080896 : 0x55000000));
            FabricationConfigScreen.m_93143_((PoseStack)matrices, (int)(this.f_96543_ - 136), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        this.drawBackground(matrices, mouseX, mouseY, delta, 130, this.f_96544_ - 20);
        ArrayList notes = Lists.newArrayList();
        boolean hasYellowNote = false;
        boolean hasRedNote = false;
        if (this.configuringServer) {
            this.checkServerData();
            newlyBannedKeys = newlyBannedKeysServer;
            newlyUnbannedKeys = newlyUnbannedKeysServer;
        } else {
            newlyBannedKeys = newlyBannedKeysClient;
            newlyUnbannedKeys = newlyUnbannedKeysClient;
        }
        if (!newlyUnbannedKeys.isEmpty()) {
            notes.add("\u00a7c" + newlyUnbannedKeys.size() + " newly unbanned option" + (newlyUnbannedKeys.size() == 1 ? "" : "s") + " will\n\u00a7cnot activate until the {} is\n\u00a7crestarted.");
            hasRedNote = true;
        }
        if (!newlyBannedKeys.isEmpty()) {
            notes.add(newlyBannedKeys.size() + " newly banned option" + (newlyBannedKeys.size() == 1 ? "" : "s") + " will be\nunloaded when the {} is\nrestarted.");
        }
        if (this.noteIndex < 0) {
            this.noteIndex = 0;
        }
        if (this.noteIndex >= notes.size()) {
            this.noteIndex = 0;
        }
        int textHeight = this.drawWrappedText(matrices, 136.0f, this.f_96544_, (hasRedNote ? "\u00a7c\u26a0 " : (hasYellowNote ? "\u00a7e" : "")) + notes.size() + " note" + (notes.size() == 1 ? "" : "s") + (String)(notes.isEmpty() ? " \u263a" : " - hover to see " + (notes.size() == 1 ? "it" : "them")), this.f_96543_ - 250, -1, true);
        if (mouseX >= 136 && mouseX <= this.f_96543_ - 100 && mouseY >= this.f_96544_ - textHeight && !notes.isEmpty()) {
            ArrayList lines = Lists.newArrayList();
            for (String s : ((String)notes.get(this.noteIndex)).replace("{}", this.configuringServer ? "server" : "client").split("\n")) {
                lines.add(Component.m_237113_((String)s));
            }
            if (notes.size() > 1) {
                lines.add(Component.m_237113_((String)"\u00a77Click to see other notes"));
            }
            this.m_96597_(matrices, lines, mouseX, mouseY);
            if (this.didClick && notes.size() > 1) {
                ++this.noteIndex;
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12491_, (float)1.0f));
            }
        }
        if (this.drawButton(matrices, this.f_96543_ - 100, this.f_96544_ - 20, 100, 20, "Done", mouseX, mouseY)) {
            this.m_7379_();
        }
        if (this.didClick) {
            this.didClick = false;
            this.lastDragY = 0;
        }
        if (this.mouseDragging) {
            this.mouseDragging = false;
        }
        super.m_6305_(matrices, mouseX, mouseY, delta);
        this.bufferTooltips = false;
        for (Runnable r : this.bufferedTooltips) {
            r.run();
        }
        this.bufferedTooltips.clear();
        if (mouseX > this.f_96543_ - 120 && mouseY < 16) {
            Object msg;
            if (this.whyCantConfigureServer != null) {
                msg = (this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "\u00a7e") + this.whyCantConfigureServer;
            } else if (this.editingWorldPath) {
                msg = "Click to unselect world";
            } else if (this.f_96541_.f_91073_ == null || this.isSingleplayer) {
                msg = "Click to select world";
            } else {
                int srv = this.serverKnownConfigKeys.size();
                int cli = FabConf.getAllKeys().size();
                msg = "\u00a7dServer has " + MixinConfigPlugin.MOD_NAME + " and is recognized.";
                if (srv != cli) {
                    msg = (String)msg + "\n\u00a7oMismatch: Server has " + srv + " options. Client has " + cli + ".";
                    if (srv > cli) {
                        msg = (String)msg + "\n\u00a7cOptions unknown to the client will not appear.";
                    } else if (cli > srv) {
                        msg = (String)msg + "\n\u00a7eOptions unknown to the server will be disabled.";
                    }
                }
            }
            if (this.serverReadOnly) {
                msg = (String)msg + "\n\u00a7fYou cannot configure this server.";
                if (this.configuringServer) {
                    msg = (String)msg + "\n\u00a7fChanges cannot be made.";
                }
            }
            if (!(this.isSingleplayer || this.serverReadOnly && this.configuringServer)) {
                msg = (String)msg + "\n\u00a7fChanges will apply to the " + (this.configuringServer ? "\u00a7dSERVER" : "\u00a76CLIENT") + "\u00a7f.";
            }
            this.m_96597_(matrices, Lists.transform((List)Lists.newArrayList((Object[])((String)msg).split("\n")), Component::m_130674_), mouseX + 10, 20 + mouseY);
        }
        matrices.m_85849_();
    }

    private void checkServerData() {
        long launchId;
        ClientPacketListener cpnh = this.f_96541_.m_91403_();
        if (cpnh != null && cpnh instanceof GetServerConfig && (launchId = ((GetServerConfig)cpnh).fabrication$getLaunchId()) != serverLaunchId) {
            newlyBannedKeysServer.clear();
            newlyUnbannedKeysServer.clear();
            serverLaunchId = launchId;
        }
    }

    private int drawWrappedText(PoseStack matrices, float x, float y, String str, int width, int color, boolean fromBottom) {
        int height = 0;
        List lines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)str), width);
        if (fromBottom) {
            y -= 12.0f;
            lines = Lists.reverse((List)lines);
        }
        for (FormattedCharSequence ot : lines) {
            this.f_96547_.m_92877_(matrices, ot, x, y, color);
            y += (float)(fromBottom ? -12 : 12);
            height += 12;
        }
        return height;
    }

    private void drawSection(PoseStack matrices, String section, float mouseX, float mouseY, float choiceY, float a, boolean selected) {
        int startY;
        if (a <= 0.0f) {
            return;
        }
        if (FabConf.isEnabled("general.reduced_motion")) {
            a = 1.0f;
        }
        matrices.m_85836_();
        matrices.m_85837_(60.0, (double)(choiceY + 16.0f), 0.0);
        matrices.m_85841_(a, a, 1.0f);
        matrices.m_85837_(-60.0, (double)(-(choiceY + 16.0f)), 0.0);
        float lastScrollOfs = selected ? this.lastSelectedSectionScroll : this.lastPrevSelectedSectionScroll;
        float scrollOfs = selected ? this.selectedSectionScroll : this.prevSelectedSectionScroll;
        float scroll = (selected ? this.selectedSectionHeight : this.prevSelectedSectionHeight) < (float)(this.f_96544_ - 36) ? 0.0f : lastScrollOfs + (scrollOfs - lastScrollOfs) * this.f_96541_.m_91296_();
        int y = startY = 16 - (int)scroll;
        if (section == null) {
            FabricationSummaryScreen screen;
            String v = this.getVersion();
            String blurb = "\u00a7l" + MixinConfigPlugin.MOD_NAME + " v" + v + " \u00a7rby unascribed and SFort\nRunning under Minecraft " + SharedConstants.m_183709_().getName() + "\n" + (String)(this.configuringServer ? "(Local version: v" + EarlyAgnos.getModVersion() + ")" : "") + "\nClick a category on the left to change settings.";
            int height = this.drawWrappedText(matrices, 140.0f, 20.0f, blurb, this.f_96543_ - 130, -1, false);
            if (!this.configuringServer && this.drawButton(matrices, 140, 20 + height + 32, 120, 20, "Reload files", mouseX, mouseY)) {
                FabConf.reload();
            }
            if (this.drawButton(matrices, 140, 42 + height + 32, 80, 20, "Summary", mouseX, mouseY) && (screen = FabricationSummaryScreen.tryCreate(this)) != null) {
                this.f_96541_.m_91152_((Screen)screen);
            }
            y += height;
            y += 44;
        } else {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("fabrication", "category/" + section + ".png"));
            RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
            RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
            matrices.m_85836_();
            matrices.m_85837_((double)(130.0f + (float)(this.f_96543_ - 130) / 2.0f), (double)((float)this.f_96544_ / 2.0f), 0.0);
            FabricationConfigScreen.m_93143_((PoseStack)matrices, (int)-80, (int)-80, (int)0, (float)0.0f, (float)0.0f, (int)160, (int)160, (int)160, (int)160);
            matrices.m_85849_();
            if ("general".equals(section)) {
                if (y > 0) {
                    this.f_96547_.m_92883_(matrices, "\u00a7lGeneral", 135.0f, (float)(y - 12), -1);
                }
                y = this.drawConfigValues(matrices, y, mouseX, mouseY, en -> !en.key.startsWith("general.category.") && en.key.startsWith("general."), new ConfigValueFlag[0]);
                this.f_96547_.m_92883_(matrices, "\u00a7lCategory Defaults", 135.0f, (float)((y += 25) - 12), -1);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                List<Map.Entry> categories = FeaturesFile.getAll().entrySet().stream().filter(en -> ((String)en.getKey()).startsWith("general.category.")).sorted(Comparator.comparing(e -> {
                    int i = this.tabs.indexOf(((String)e.getKey()).substring(17));
                    return i == -1 ? Integer.MAX_VALUE : i;
                })).toList();
                if (this.editingWorldPath) {
                    y += this.drawWrappedText(matrices, 200.0f, y, "Categories are not available in world settings", this.f_96543_ - 200, 0xFFFFFF, false) + 6;
                } else {
                    for (Map.Entry en2 : categories) {
                        FeaturesFile.FeatureEntry fe2 = (FeaturesFile.FeatureEntry)en2.getValue();
                        y = this.drawCategoryValue(matrices, (String)en2.getKey(), fe2.name, fe2.desc, y, mouseX, mouseY);
                    }
                }
            } else if ("search".equals(section)) {
                y += 4;
                Predicate<FeaturesFile.FeatureEntry> pen = "#failed".equals(this.searchField.m_94155_()) ? fe -> this.isFailed(fe.key) : en -> this.emptyQuery || this.queryPattern.matcher(en.name).find() || this.queryPattern.matcher(en.shortName).find() || this.queryPattern.matcher(en.desc).find();
                if (isFScriptLoaded && this.searchingScriptable) {
                    pen = ((Predicate<FeaturesFile.FeatureEntry>)en -> en.fscript != null).and(pen);
                }
                y = this.drawConfigValues(matrices, y, mouseX, mouseY, pen, ConfigValueFlag.SHOW_SOURCE_SECTION, this.emptyQuery ? null : ConfigValueFlag.HIGHLIGHT_QUERY_MATCH);
            } else {
                String name = FeaturesFile.get((String)section).name;
                if (y > 0) {
                    this.f_96547_.m_92883_(matrices, "\u00a7l" + name, 135.0f, (float)(y - 12), -1);
                }
                int titleY = y = this.drawConfigValues(matrices, y, mouseX, mouseY, en -> en.key.startsWith(section + ".") && !en.extra, new ConfigValueFlag[0]);
                int endY = this.drawConfigValues(matrices, y += 22, mouseX, mouseY, en -> en.key.startsWith(section + ".") && en.extra, new ConfigValueFlag[0]);
                if (endY != y && y < this.f_96544_ - 8) {
                    this.f_96547_.m_92883_(matrices, "\u00a7l" + name + " \u00a7oExtra", 135.0f, (float)(titleY + 10), -1);
                }
                y = endY;
            }
        }
        if (y == startY) {
            this.f_96547_.m_92883_(matrices, "There are no available features in this category", 136.0f, (float)(startY + 14), -1);
        }
        float h = y - startY;
        if (selected) {
            this.selectedSectionHeight = h;
        } else {
            this.prevSelectedSectionHeight = h;
        }
        int sh = this.f_96544_ - 36;
        if (h > (float)sh) {
            float knobHeight = (float)sh / h * (float)sh;
            float knobY = (selected ? this.selectedSectionScroll : this.prevSelectedSectionScroll) / (h - (float)sh) * ((float)sh - knobHeight) + 16.0f;
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(this.f_96543_ - 2), (int)Math.max(16, (int)knobY), (int)this.f_96543_, (int)Math.min(this.f_96544_ - 20, (int)(knobY + knobHeight)), (int)-1426063361);
        }
        matrices.m_85849_();
    }

    private int drawConfigValues(PoseStack matrices, int y, float mouseX, float mouseY, Predicate<FeaturesFile.FeatureEntry> pred, ConfigValueFlag ... defaultFlags) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Map.Entry en : FeaturesFile.getAll().entrySet()) {
            FeaturesFile.FeatureEntry fe = (FeaturesFile.FeatureEntry)en.getValue();
            if (fe.meta || fe.section || !pred.test(fe)) continue;
            ConfigValueFlag[] flags = defaultFlags;
            if (fe.sides == FeaturesFile.Sides.CLIENT_ONLY) {
                flags = (ConfigValueFlag[])ArrayUtils.add((Object[])flags, (Object)((Object)ConfigValueFlag.CLIENT_ONLY));
            }
            y = this.drawConfigValue(matrices, (String)en.getKey(), fe.name, fe.desc, y, mouseX, mouseY, flags);
        }
        return y;
    }

    private boolean drawButton(PoseStack matrices, int x, int y, int w, int h, String text, float mouseX, float mouseY) {
        return FabricationConfigScreen.drawButton(matrices, x, y, w, h, text, mouseX, mouseY, this.didClick, this.f_96541_);
    }

    public static boolean drawButton(PoseStack matrices, int x, int y, int w, int h, String text, float mouseX, float mouseY, boolean didClick, Minecraft client) {
        boolean click = false;
        boolean hover = mouseX >= (float)x && mouseX <= (float)(x + w) && mouseY >= (float)y && mouseY <= (float)(y + h);
        FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)(FabConf.isEnabled("general.dark_mode") ? 0x44FFFFFF : 0x55000000));
        if (hover) {
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + w), (int)(y + 1), (int)-1);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + 1), (int)(y + h), (int)-1);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)x, (int)(y + h - 1), (int)(x + w), (int)(y + h), (int)-1);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(x + w - 1), (int)y, (int)(x + w), (int)(y + h), (int)-1);
            if (didClick) {
                client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                click = true;
            }
        }
        int textWidth = client.f_91062_.m_92895_(text);
        client.f_91062_.m_92883_(matrices, text, (float)(x + (w - textWidth) / 2), (float)(y + (h - 8) / 2), -1);
        return click;
    }

    public static boolean drawToggleButton(PoseStack matrices, int x, int y, int w, int h, String text, float mouseX, float mouseY, boolean toggle, boolean didClick, Minecraft client) {
        boolean hover;
        boolean click = false;
        boolean bl = hover = mouseX >= (float)x && mouseX <= (float)(x + w) && mouseY >= (float)y && mouseY <= (float)(y + h);
        if (hover ^ toggle) {
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + w), (int)(y + 1), (int)-1);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + 1), (int)(y + h), (int)-1);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)x, (int)(y + h - 1), (int)(x + w), (int)(y + h), (int)-1);
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(x + w - 1), (int)y, (int)(x + w), (int)(y + h), (int)-1);
        }
        if (hover && didClick) {
            client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            click = true;
        }
        int textWidth = client.f_91062_.m_92895_(text);
        client.f_91062_.m_92883_(matrices, text, (float)x + (float)(w - textWidth) / 2.0f, (float)y + (float)(h - 8) / 2.0f, -1);
        return click;
    }

    private int drawCategoryValue(PoseStack matrices, String key, String title, String desc, int y, float mouseX, float mouseY) {
        matrices.m_85836_();
        matrices.m_85837_(0.0, (double)y, 0.0);
        int startY = y;
        y += this.drawWrappedText(matrices, 200.0f, 2.0f, title, this.f_96543_ - 200, -1, false) + 6;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("fabrication", "coffee_bean.png"));
        RenderSystem.m_69937_((int)3553, (int)10240, (int)9729);
        RenderSystem.m_69937_((int)3553, (int)10241, (int)9729);
        int x = 0;
        ConfigValues.Category hovered = null;
        for (ConfigValues.Category p : ConfigValues.Category.values()) {
            boolean profSel;
            block13: {
                block14: {
                    try {
                        profSel = ConfigValues.Category.parse(this.getRawValue(key)) == p;
                    }
                    catch (IllegalArgumentException e) {
                        boolean bl = profSel = p == ConfigValues.Category.GREEN;
                    }
                    if (mouseX >= (float)(134 + x) && mouseX <= (float)(134 + x + 16) && mouseY >= (float)startY && mouseY <= (float)(startY + 16)) {
                        hovered = p;
                    }
                    if (!this.didClick && !this.mouseDragging || !(mouseX >= (float)(134 + x)) || !(mouseX <= (float)(134 + x + 16)) || !(mouseY >= (float)startY) || !(mouseY <= (float)(startY + 16))) break block13;
                    if (this.didClick || !this.mouseDragging) break block14;
                    if (this.lastDragY == startY) break block13;
                    this.lastDragY = startY;
                }
                if (p == ConfigValues.Category.ASH) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12211_, (float)2.0f, (float)1.0f));
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12331_, (float)1.0f, (float)1.0f));
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12331_, (float)1.0f, (float)1.2f));
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12331_, (float)1.0f, (float)0.7f));
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12331_, (float)1.0f, (float)0.5f));
                } else if (p == ConfigValues.Category.GREEN) {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12209_, (float)0.5f, (float)1.0f));
                } else {
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12168_, (float)(0.707107f + (float)p.ordinal() * 0.22f), (float)1.0f));
                }
                this.setValue(key, p.name().toLowerCase(Locale.ROOT));
            }
            this.color(p.getColor(), profSel ? 1.0f : (hovered == p ? 0.6f : 0.3f));
            FabricationConfigScreen.m_93143_((PoseStack)matrices, (int)(134 + x), (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            x += 18;
        }
        if (mouseX >= 200.0f && mouseX <= (float)(this.f_96543_ - 200) && mouseY >= (float)startY && mouseY <= (float)(y - 6)) {
            this.renderWrappedTooltip(matrices, desc, mouseX, mouseY);
        }
        if (hovered != null) {
            this.renderWrappedTooltip(matrices, "\u00a7l" + hovered.displayName() + "\n\u00a7f" + hovered.displayDesc(), mouseX, mouseY);
        }
        matrices.m_85849_();
        return y;
    }

    private int drawConfigValue(PoseStack matrices, String key, String title, String desc, int y, float mouseX, float mouseY, ConfigValueFlag ... flags) {
        int endX;
        int startX;
        int clickedIndex;
        int trackSize;
        float da;
        boolean keyEnabled;
        ConfigValues.Feature currentValue;
        boolean noUnset;
        boolean noBan;
        float scale;
        boolean noValue;
        boolean disabled;
        boolean banned;
        String failed;
        boolean noFabricApi;
        boolean highlightQueryMatch;
        boolean showSourceSection;
        boolean requiresFabricApi;
        boolean onlyBannable;
        boolean clientOnly;
        block88: {
            block89: {
                ConfigValues.Feature prevValue;
                boolean animateDisabled;
                if (y < -12 || y > this.f_96544_ - 16) {
                    return y + 14;
                }
                clientOnly = ArrayUtils.contains((Object[])flags, (Object)((Object)ConfigValueFlag.CLIENT_ONLY));
                onlyBannable = clientOnly && this.configuringServer;
                requiresFabricApi = ArrayUtils.contains((Object[])flags, (Object)((Object)ConfigValueFlag.REQUIRES_FABRIC_API));
                showSourceSection = ArrayUtils.contains((Object[])flags, (Object)((Object)ConfigValueFlag.SHOW_SOURCE_SECTION));
                highlightQueryMatch = ArrayUtils.contains((Object[])flags, (Object)((Object)ConfigValueFlag.HIGHLIGHT_QUERY_MATCH));
                noFabricApi = !this.configuringServer && requiresFabricApi && !FabricLoader.getInstance().isModLoaded("fabric");
                failed = this.getFailed(key);
                banned = !this.configuringServer && FabricationModClient.isBannedByServer(key);
                disabled = banned || noFabricApi || this.configuringServer && this.serverReadOnly || !this.isValid(key);
                noValue = noFabricApi || this.configuringServer && clientOnly || !this.isValid(key);
                float time = this.optionAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
                float disabledTime = this.disabledAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
                float becomeBanTime = this.becomeBanAnimationTime.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
                if (onlyBannable && !this.onlyBannableds.contains(key)) {
                    becomeBanTime = this.becomeBanAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
                    this.onlyBannableds.add(key);
                } else if (!onlyBannable && this.onlyBannableds.contains(key)) {
                    becomeBanTime = this.becomeBanAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
                    this.onlyBannableds.remove(key);
                }
                boolean bl = animateDisabled = disabledTime > 0.0f;
                if (disabled && !this.knownDisabled.contains(key)) {
                    disabledTime = this.disabledAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
                    this.knownDisabled.add(key);
                } else if (!disabled && this.knownDisabled.contains(key)) {
                    disabledTime = this.disabledAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue()))).floatValue();
                    this.knownDisabled.remove(key);
                }
                if (time > 0.0f) {
                    if ((time -= this.f_96541_.m_91297_()) <= 0.0f) {
                        this.optionAnimationTime.remove(key);
                        time = 0.0f;
                    } else {
                        this.optionAnimationTime.put(key, Float.valueOf(time));
                    }
                }
                if (disabledTime > 0.0f) {
                    if ((disabledTime -= this.f_96541_.m_91297_()) <= 0.0f) {
                        this.disabledAnimationTime.remove(key);
                        disabledTime = 0.0f;
                    } else {
                        this.disabledAnimationTime.put(key, Float.valueOf(disabledTime));
                    }
                }
                if (becomeBanTime > 0.0f) {
                    if ((becomeBanTime -= this.f_96541_.m_91297_()) <= 0.0f) {
                        this.becomeBanAnimationTime.remove(key);
                        becomeBanTime = 0.0f;
                    } else {
                        this.becomeBanAnimationTime.put(key, Float.valueOf(becomeBanTime));
                    }
                }
                matrices.m_85836_();
                matrices.m_85837_(0.0, (double)y, 0.0);
                float dia = FabricationConfigScreen.sCurve5((5.0f - becomeBanTime) / 5.0f);
                scale = 1.0f;
                noBan = key.startsWith("general.");
                boolean bl2 = noUnset = noBan && !this.editingWorldPath;
                currentValue = noUnset ? (this.isEnabled(key) ? ConfigValues.Feature.TRUE : ConfigValues.Feature.FALSE) : (onlyBannable ? (this.getValue(key) == ConfigValues.Feature.BANNED ? ConfigValues.Feature.BANNED : ConfigValues.Feature.UNSET) : this.getValue(key));
                keyEnabled = this.getResolvedValue(key) == ConfigValues.ResolvedFeature.DEFAULT_TRUE;
                ConfigValues.Feature feature = prevValue = animateDisabled ? currentValue : this.optionPreviousValues.getOrDefault(key, currentValue);
                int[] xes = noUnset ? new int[]{0, 23, 0, 0} : (noBan ? new int[]{15, 30, 0, 0} : (onlyBannable ? new int[]{30, 30, 30, 0} : new int[]{30, 45, 15, 0}));
                int[] hues = new int[]{50, 130, -10, -90};
                int[] values = new int[]{90, 85, 90, 20};
                int prevX = xes[prevValue.ordinal()];
                int prevHue = hues[prevValue.ordinal()];
                int prevHSValue = values[prevValue.ordinal()];
                int curX = xes[currentValue.ordinal()];
                int curHue = hues[currentValue.ordinal()];
                int curHSValue = values[currentValue.ordinal()];
                float a = FabricationConfigScreen.sCurve5((5.0f - time) / 5.0f);
                da = FabricationConfigScreen.sCurve5((5.0f - disabledTime) / 5.0f);
                if (!disabled && failed == null) {
                    da = 1.0f - da;
                }
                int n = trackSize = noUnset || noBan ? 45 : 60;
                if (clientOnly) {
                    FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)133, (int)0, (int)(134 + trackSize + 1), (int)11, (int)-22016);
                } else {
                    FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)133, (int)0, (int)(134 + trackSize + 1), (int)11, (int)-1);
                }
                FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)134, (int)1, (int)(134 + trackSize), (int)10, (int)0x66000000);
                if (!(noUnset || onlyBannable || noBan)) {
                    FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)149, (int)1, (int)164, (int)10, (int)0x33000000);
                    FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)179, (int)1, (int)194, (int)10, (int)0x33000000);
                }
                matrices.m_85836_();
                matrices.m_85837_((double)(134.0f + ((float)prevX + (float)(curX - prevX) * a)), 0.0, 0.0);
                int knobAlpha = (int)((noValue ? 1.0f - da : 1.0f) * 255.0f) << 24;
                int selectedWidth = noUnset ? 22 : (onlyBannable ? 30 : 15);
                FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)0, (int)1, (int)selectedWidth, (int)10, (int)(Mth.m_14169_((float)((float)Math.floorMod((int)((float)prevHue + (float)(curHue - prevHue) * a), 360) / 360.0f), (float)0.9f, (float)(((float)prevHSValue + (float)(curHSValue - prevHSValue) * a) / 100.0f)) | knobAlpha));
                if (!(noUnset || !(a >= 1.0f) || currentValue != ConfigValues.Feature.UNSET && !this.editingWorldPath || onlyBannable || noBan && currentValue != ConfigValues.Feature.UNSET)) {
                    FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(keyEnabled ? selectedWidth : -1), (int)1, (int)(keyEnabled ? selectedWidth + 1 : 0), (int)10, (int)(Mth.m_14169_((float)((float)(keyEnabled ? 120 : 0) / 360.0f), (float)0.9f, (float)0.8f) | knobAlpha));
                }
                matrices.m_85849_();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("fabrication", "configvalue.png"));
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f + (1.0f - da) * 0.5f));
                RenderSystem.m_69493_();
                if (noUnset) {
                    FabricationConfigScreen.m_93133_((PoseStack)matrices, (int)137, (int)1, (float)15.0f, (float)0.0f, (int)15, (int)9, (int)60, (int)9);
                    FabricationConfigScreen.m_93133_((PoseStack)matrices, (int)160, (int)1, (float)45.0f, (float)0.0f, (int)15, (int)9, (int)60, (int)9);
                } else if (noBan) {
                    FabricationConfigScreen.m_93133_((PoseStack)matrices, (int)134, (int)1, (float)15.0f, (float)0.0f, (int)45, (int)9, (int)60, (int)9);
                } else if (onlyBannable) {
                    FabricationConfigScreen.m_93133_((PoseStack)matrices, (int)141, (int)1, (float)0.0f, (float)0.0f, (int)15, (int)9, (int)60, (int)9);
                    FabricationConfigScreen.m_93133_((PoseStack)matrices, (int)172, (int)1, (float)30.0f, (float)0.0f, (int)15, (int)9, (int)60, (int)9);
                } else {
                    FabricationConfigScreen.m_93133_((PoseStack)matrices, (int)134, (int)1, (float)0.0f, (float)0.0f, (int)60, (int)9, (int)60, (int)9);
                }
                RenderSystem.m_69472_();
                clickedIndex = (int)(mouseX - 134.0f) / (noUnset ? 22 : (onlyBannable ? 30 : 15));
                if (!this.didClick && !this.mouseDragging || !(mouseX >= 134.0f) || !(mouseX <= (float)(134 + trackSize)) || !(mouseY >= (float)(y + 1)) || !(mouseY <= (float)(y + 10))) break block88;
                if (this.didClick || !this.mouseDragging) break block89;
                if (this.lastDragY == y) break block88;
                this.lastDragY = y;
            }
            float pitch = (float)y * 0.005f;
            if (disabled) {
                this.playErrorFeedback();
            } else {
                ConfigValues.Feature newValue;
                if (noUnset) {
                    newValue = clickedIndex == 0 ? ConfigValues.Feature.FALSE : ConfigValues.Feature.TRUE;
                } else if (noBan) {
                    switch (clickedIndex) {
                        case 0: {
                            newValue = ConfigValues.Feature.FALSE;
                            break;
                        }
                        case 2: {
                            newValue = ConfigValues.Feature.TRUE;
                            break;
                        }
                        default: {
                            newValue = ConfigValues.Feature.UNSET;
                            break;
                        }
                    }
                } else if (onlyBannable) {
                    newValue = clickedIndex == 0 ? ConfigValues.Feature.BANNED : ConfigValues.Feature.UNSET;
                } else {
                    switch (clickedIndex) {
                        case 0: {
                            newValue = ConfigValues.Feature.BANNED;
                            break;
                        }
                        case 1: {
                            newValue = ConfigValues.Feature.FALSE;
                            break;
                        }
                        case 2: {
                            newValue = ConfigValues.Feature.UNSET;
                            break;
                        }
                        case 3: {
                            newValue = ConfigValues.Feature.TRUE;
                            break;
                        }
                        default: {
                            newValue = ConfigValues.Feature.UNSET;
                        }
                    }
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)(newValue == ConfigValues.Feature.BANNED ? SoundEvents.f_12208_ : (newValue == ConfigValues.Feature.FALSE ? SoundEvents.f_12209_ : (newValue == ConfigValues.Feature.UNSET ? SoundEvents.f_12168_ : SoundEvents.f_12211_))), (float)(0.6f + pitch), (float)1.0f));
                if (newValue != currentValue || this.editingWorldPath && !FabConf.doesWorldContainValue(key)) {
                    this.optionPreviousValues.put(key, currentValue);
                    this.optionAnimationTime.compute(key, (k, f) -> Float.valueOf(5.0f - (f == null ? 0.0f : f.floatValue())));
                    this.setValue(key, newValue.toString().toLowerCase(Locale.ROOT));
                }
            }
        }
        int textAlpha = (int)((0.7f + (1.0f - da) * 0.3f) * 255.0f) << 24;
        int startY = y;
        int startStartX = startX = 136 + (noUnset || noBan ? 45 : 60) + 5;
        String section = null;
        if (showSourceSection && key.contains(".")) {
            section = key.substring(0, key.indexOf(46));
            ResourceLocation id = new ResourceLocation("fabrication", "category/" + section + ".png");
            RenderSystem.m_157456_((int)0, (ResourceLocation)id);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FabricationConfigScreen.m_93133_((PoseStack)matrices, (int)(startX - 2), (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (int)12, (int)12);
            startX += 14;
        }
        Object drawTitle = title;
        String drawDesc = desc;
        if (highlightQueryMatch) {
            drawTitle = this.queryPattern.matcher((CharSequence)drawTitle).replaceAll("\u00a7e\u00a7l$0\u00a7r");
            drawDesc = this.queryPattern.matcher(drawDesc).replaceAll("\u00a7e\u00a7l$0\u00a7r");
        }
        if (failed != null) {
            drawTitle = (String)drawTitle + (failed.startsWith("Requires") || failed.startsWith("Not Ported") ? " \u00a7e " : " \u00a74 ") + failed;
        }
        int n = endX = startY == (y = (int)((float)y + (float)this.drawWrappedText(matrices, startX, 2.0f, (String)drawTitle, this.f_96543_ - startX - 6, 0xFFFFFF | textAlpha, false) * scale)) - 8 ? this.f_96543_ - 6 : startX + this.f_96547_.m_92895_(title);
        if (mouseX >= (float)(134 + trackSize) && mouseX <= (float)endX && mouseY >= (float)(startY + 1) && mouseY <= (float)(startY + 10) && this.submenus.containsKey(key)) {
            if (this.didClick) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                Map<String, FeatureSubmenu> menus = this.submenus.get(key);
                if (menus.size() == 1) {
                    this.f_96541_.m_91152_(menus.values().stream().findAny().get().construct(this, this.prideFlag, title, key));
                } else {
                    this.f_96541_.m_91152_(new SelectionScreen<Object>(this, new ArrayList<String>(menus.keySet()), s -> ((FeatureSubmenu)menus.get(s)).construct(this, this.prideFlag, title, key)));
                }
            }
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(startX - 2), (int)9, (int)endX, (int)10, (int)-1);
        }
        matrices.m_85849_();
        if ((!"search".equals(this.selectedSection) && mouseX <= (float)(this.f_96543_ - 120) || mouseY >= 16.0f) && mouseY < (float)(this.f_96544_ - 20)) {
            if (section != null && mouseX >= (float)startStartX && mouseX <= (float)startX && mouseY >= (float)startY && mouseY <= (float)y) {
                this.renderWrappedTooltip(matrices, FeaturesFile.get((String)section).shortName, mouseX, mouseY);
            } else if (mouseX >= (float)startX && mouseX <= (float)endX && mouseY >= (float)startY && mouseY <= (float)y) {
                Object prefix = "";
                if (clientOnly) {
                    prefix = (String)prefix + "\u00a76Client Only ";
                }
                if (requiresFabricApi) {
                    prefix = (String)prefix + "\u00a7bRequires Fabric API ";
                }
                if (!((String)prefix).isEmpty()) {
                    prefix = (String)prefix + "\u00a7r\n";
                }
                this.renderWrappedTooltip(matrices, (String)prefix + drawDesc, mouseX, mouseY);
            } else if (mouseX >= 134.0f && mouseX <= (float)(134 + trackSize) && mouseY >= (float)startY && mouseY <= (float)(startY + 10)) {
                if (disabled) {
                    if (noFabricApi) {
                        this.m_96602_(matrices, (Component)Component.m_237113_((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "This option requires Fabric API")), (int)mouseX, (int)mouseY);
                    } else if (noValue) {
                        this.m_96602_(matrices, (Component)Component.m_237113_((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "The server does not recognize this option")), (int)mouseX, (int)mouseY);
                    } else if (banned) {
                        this.m_96602_(matrices, (Component)Component.m_237113_((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "This feature is banned by the server")), (int)mouseX, (int)mouseY);
                    } else {
                        this.m_96602_(matrices, (Component)Component.m_237113_((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "You cannot configure this server")), (int)mouseX, (int)mouseY);
                    }
                } else if (failed != null) {
                    this.m_96602_(matrices, (Component)Component.m_237113_((String)((this.tooltipBlinkTicks / 5 % 2 == 1 ? "\u00a7c" : "") + "This feature failed to initialize, reason: " + failed)), (int)mouseX, (int)mouseY);
                } else {
                    int index = (int)((mouseX - 134.0f) / (float)(noUnset ? 22 : (onlyBannable ? 30 : 15)));
                    if (onlyBannable) {
                        if (clickedIndex == 0) {
                            this.m_96597_(matrices, Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)"\u00a77Ban"), Component.m_237113_((String)"Disallow use by clients")}), (int)mouseX, (int)mouseY);
                        } else {
                            this.m_96597_(matrices, Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)"\u00a7eUnset"), Component.m_237113_((String)"Allow use by clients")}), (int)mouseX, (int)mouseY);
                        }
                    } else if (clickedIndex == (noUnset || noBan ? 0 : 1)) {
                        this.m_96602_(matrices, (Component)Component.m_237113_((String)"\u00a7cDisable"), (int)mouseX, (int)mouseY);
                    } else if (clickedIndex == (noUnset ? -99 : (noBan ? 1 : 2))) {
                        if (currentValue == ConfigValues.Feature.UNSET) {
                            this.m_96597_(matrices, Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)"\u00a7eUse default value \u00a7f(see General > Profile)"), Component.m_237113_((String)("\u00a7rCurrent default: " + (keyEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled")))}), (int)mouseX, (int)mouseY);
                        } else {
                            this.m_96602_(matrices, (Component)Component.m_237113_((String)"\u00a7eUse default value \u00a7f(see General > Profile)"), (int)mouseX, (int)mouseY);
                        }
                    } else if (clickedIndex == 0) {
                        ArrayList li = Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)"\u00a77Ban"), Component.m_237113_((String)"Prevent feature from loading entirely")});
                        if (this.configuringServer) {
                            li.add(Component.m_237113_((String)"and disallow usage by clients"));
                        }
                        this.m_96597_(matrices, li, (int)mouseX, (int)mouseY);
                    } else {
                        this.m_96602_(matrices, (Component)Component.m_237113_((String)"\u00a7aEnable"), (int)mouseX, (int)mouseY);
                    }
                }
            }
        }
        return y + 2;
    }

    private void renderWrappedTooltip(PoseStack matrices, String str, float mouseX, float mouseY) {
        this.m_96617_(matrices, this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)str), mouseX < (float)(this.f_96543_ / 2) ? (int)((float)this.f_96543_ - mouseX - 30.0f) : (int)mouseX - 20), (int)mouseX, (int)(20.0f + mouseY));
    }

    private void playErrorFeedback() {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12169_, (float)0.8f, (float)1.0f));
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12169_, (float)0.7f, (float)1.0f));
        this.tooltipBlinkTicks = 20;
    }

    public static String formatTitleCase(String in) {
        String[] pieces = new String[]{in};
        if (in.contains(" ")) {
            pieces = in.toLowerCase().split(" ");
        } else if (in.contains("_")) {
            pieces = in.toLowerCase().split("_");
        }
        StringBuilder result = new StringBuilder();
        for (String s : pieces) {
            String t;
            if (s == null || (t = s.trim().toLowerCase()).isEmpty()) continue;
            result.append(Character.toUpperCase(t.charAt(0)));
            if (t.length() > 1) {
                result.append(t.substring(1));
            }
            result.append(" ");
        }
        return result.toString().trim();
    }

    private void color(int packed) {
        this.color(packed, (float)(packed >> 24 & 0xFF) / 255.0f);
    }

    private void color(int packed, float alpha) {
        RenderSystem.m_157429_((float)((float)(packed >> 16 & 0xFF) / 255.0f), (float)((float)(packed >> 8 & 0xFF) / 255.0f), (float)((float)(packed >> 0 & 0xFF) / 255.0f), (float)alpha);
    }

    public void m_7379_() {
        if (this.f_96541_.f_91073_ == null) {
            FabConf.setWorldPath(null);
        }
        if (!FabConf.isEnabled("*.reduced_motion") && !this.leaving) {
            this.leaving = true;
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11724_, (float)0.7f));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12350_, (float)2.0f, (float)1.0f));
        } else {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    public void m_86600_() {
        float h;
        super.m_86600_();
        if (this.sidebarHeight > (float)this.f_96544_) {
            this.lastSidebarScroll = this.sidebarScroll;
            this.sidebarScroll += (this.sidebarScrollTarget - this.sidebarScroll) / 2.0f;
            if (this.sidebarScrollTarget < 0.0f) {
                this.sidebarScrollTarget /= 2.0f;
            }
            if (this.sidebarScrollTarget > (h = this.sidebarHeight - (float)this.f_96544_)) {
                this.sidebarScrollTarget = h + (this.sidebarScrollTarget - h) / 2.0f;
            }
        }
        if (this.selectedSectionHeight > (float)(this.f_96544_ - 36)) {
            this.lastSelectedSectionScroll = this.selectedSectionScroll;
            this.selectedSectionScroll += (this.selectedSectionScrollTarget - this.selectedSectionScroll) / 2.0f;
            if (this.selectedSectionScrollTarget < 0.0f) {
                this.selectedSectionScrollTarget /= 2.0f;
            }
            if (this.selectedSectionScrollTarget > (h = this.selectedSectionHeight - (float)(this.f_96544_ - 36))) {
                this.selectedSectionScrollTarget = h + (this.selectedSectionScrollTarget - h) / 2.0f;
            }
        }
        if (this.prevSelectedSectionHeight > (float)(this.f_96544_ - 36)) {
            this.lastPrevSelectedSectionScroll = this.prevSelectedSectionScroll;
            this.prevSelectedSectionScroll += (this.prevSelectedSectionScrollTarget - this.prevSelectedSectionScroll) / 2.0f;
            if (this.prevSelectedSectionScrollTarget < 0.0f) {
                this.prevSelectedSectionScrollTarget /= 2.0f;
            }
            if (this.prevSelectedSectionScrollTarget > (h = this.prevSelectedSectionHeight - (float)(this.f_96544_ - 36))) {
                this.prevSelectedSectionScrollTarget = h + (this.prevSelectedSectionScrollTarget - h) / 2.0f;
            }
        }
        if (this.tooltipBlinkTicks > 0) {
            --this.tooltipBlinkTicks;
        }
        this.searchField.m_94120_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (mouseX <= 120.0) {
            this.sidebarScrollTarget = (float)((double)this.sidebarScrollTarget - amount * 20.0);
        } else {
            this.selectedSectionScrollTarget = (float)((double)this.selectedSectionScrollTarget - amount * 20.0);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (mouseX > (double)(this.f_96543_ - 120) && mouseY < 16.0) {
                if (this.configuringServer) {
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    this.configuringServer = false;
                    this.hasClonked = false;
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12218_, (float)0.8f, (float)1.0f));
                } else if (this.f_96541_.f_91073_ == null) {
                    this.hasClonked = false;
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12218_, (float)0.8f, (float)1.0f));
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    FabConf.setWorldPath(null);
                    if (!this.editingWorldPath) {
                        this.openWorldSelector();
                        return super.m_6375_(mouseX, mouseY, button);
                    }
                    this.editingWorldPath = false;
                } else if (this.isSingleplayer) {
                    this.hasClonked = false;
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12218_, (float)0.8f, (float)1.0f));
                    this.editingWorldPath = !this.editingWorldPath;
                } else if (this.whyCantConfigureServer == null) {
                    this.hasClonked = false;
                    this.serverAnimateTime = 10.0f - this.serverAnimateTime;
                    this.configuringServer = true;
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12218_, (float)1.2f, (float)1.0f));
                } else {
                    this.playErrorFeedback();
                }
            }
            this.didClick = true;
        }
        if ("search".equals(this.selectedSection)) {
            this.searchField.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void openWorldSelector() {
        try {
            Path savesDir = this.f_96541_.m_91392_().m_78257_();
            if (Files.isDirectory(savesDir, new LinkOption[0])) {
                List files = Arrays.stream(savesDir.toFile().listFiles()).filter(f -> {
                    if (!f.isDirectory()) {
                        return false;
                    }
                    try {
                        return !DirectoryLock.m_13642_((Path)f.toPath());
                    }
                    catch (Exception var10) {
                        return false;
                    }
                }).map(x$0 -> new DrawableSave((File)x$0)).collect(Collectors.toList());
                if (files.isEmpty()) {
                    return;
                }
                if (files.size() == 1) {
                    this.setWorldMode(((DrawableSave)files.get(0)).val());
                } else {
                    this.f_96541_.m_91152_(new SelectionScreen<File>(this, files, this::setWorldMode));
                }
            }
        }
        catch (Exception e) {
            FabLog.error("Failed to load levels", e);
        }
    }

    public void setWorldMode(Object toFile) {
        this.editingWorldPath = true;
        FabConf.setWorldPath(((File)toFile).toPath());
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if ("search".equals(this.selectedSection)) {
            this.searchField.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        } else {
            this.mouseDragging = true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if ("search".equals(this.selectedSection)) {
            this.searchField.m_94757_(mouseX, mouseY);
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if ("search".equals(this.selectedSection)) {
            this.searchField.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if ("search".equals(this.selectedSection)) {
            this.searchField.m_5534_(chr, modifiers);
        }
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 266: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 20.0);
                break;
            }
            case 267: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -20.0);
                break;
            }
            case 265: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 2.0);
                break;
            }
            case 264: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -2.0);
            }
        }
        if ("search".equals(this.selectedSection)) {
            this.searchField.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if ("search".equals(this.selectedSection)) {
            this.searchField.m_7920_(keyCode, scanCode, modifiers);
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    private String getVersion() {
        if (this.configuringServer) {
            return ((GetServerConfig)this.f_96541_.m_91403_()).fabrication$getServerVersion();
        }
        return EarlyAgnos.getModVersion();
    }

    private boolean isFailed(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.f_96541_.m_91403_()).fabrication$getServerFailedConfig().containsKey(key);
        }
        return FabConf.isFailed(key);
    }

    private String getFailed(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.f_96541_.m_91403_()).fabrication$getServerFailedConfig().get(key);
        }
        return FabConf.getFailed(key);
    }

    private boolean isValid(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.f_96541_.m_91403_()).fabrication$getServerTrileanConfig().containsKey(key) || ((GetServerConfig)this.f_96541_.m_91403_()).fabrication$getServerStringConfig().containsKey(key);
        }
        return FabConf.isValid(key);
    }

    private ConfigValues.ResolvedFeature getResolvedValue(String key) {
        if (this.configuringServer) {
            return ((GetServerConfig)this.f_96541_.m_91403_()).fabrication$getServerTrileanConfig().getOrDefault(key, ConfigValues.ResolvedFeature.DEFAULT_FALSE);
        }
        return FabConf.getResolvedValue(key, this.editingWorldPath);
    }

    private ConfigValues.Feature getValue(String key) {
        return this.getResolvedValue((String)key).feature;
    }

    private boolean isEnabled(String key) {
        return this.getResolvedValue((String)key).value;
    }

    private String getRawValue(String key) {
        if (this.configuringServer) {
            return this.getValue(key).toString().toLowerCase(Locale.ROOT);
        }
        return FabConf.getRawValue(key);
    }

    private void setValue(String key, String value) {
        Set<String> newlyUnbannedKeys;
        Set<String> newlyBannedKeys;
        if (this.configuringServer) {
            this.checkServerData();
            newlyBannedKeys = newlyBannedKeysServer;
            newlyUnbannedKeys = newlyUnbannedKeysServer;
        } else {
            newlyBannedKeys = newlyBannedKeysClient;
            newlyUnbannedKeys = newlyUnbannedKeysClient;
        }
        String oldValue = this.getRawValue(key);
        if (!(FabConf.isRuntimeConfigurable(key) || this.configuringServer && FeaturesFile.get((String)key).sides == FeaturesFile.Sides.CLIENT_ONLY || this.editingWorldPath)) {
            if (value.equals("banned")) {
                if (newlyUnbannedKeys.contains(key)) {
                    newlyUnbannedKeys.remove(key);
                } else {
                    newlyBannedKeys.add(key);
                }
            } else if (oldValue.equals("banned")) {
                if (newlyBannedKeys.contains(key)) {
                    newlyBannedKeys.remove(key);
                } else {
                    newlyUnbannedKeys.add(key);
                }
            }
        }
        if (this.configuringServer) {
            FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
            data.m_130130_(1);
            data.m_130070_(key);
            data.m_130070_(value);
            this.f_96541_.m_91403_().m_104955_((Packet)new ServerboundCustomPayloadPacket(new ResourceLocation("fabrication", "config"), data));
        } else if (this.editingWorldPath && FabConf.hasWorldPath()) {
            FabConf.worldSet(key, value);
            if (FabricationMod.isAvailableFeature(key)) {
                FabricationMod.updateFeature(key);
            }
        } else {
            FabConf.set(key, value);
            if (FabricationMod.isAvailableFeature(key)) {
                FabricationMod.updateFeature(key);
            }
        }
    }

    public static float sCurve5(float a) {
        float a3 = a * a * a;
        float a4 = a3 * a;
        float a5 = a4 * a;
        return 6.0f * a5 - 15.0f * a4 + 10.0f * a3;
    }

    /*
     * WARNING - void declaration
     */
    public void m_96617_(PoseStack matrices, List<? extends FormattedCharSequence> lines, int x, int y) {
        if (!lines.isEmpty()) {
            int n;
            if (this.bufferTooltips) {
                int yf = y;
                this.bufferedTooltips.add(() -> this.m_96617_(matrices, lines, x, yf));
                return;
            }
            if (y < 20) {
                y += 20;
            }
            int maxWidth = 0;
            for (FormattedCharSequence formattedCharSequence : lines) {
                int width = this.f_96547_.m_92724_(formattedCharSequence);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            int innerX = x + 12;
            int n2 = y - 12;
            int totalHeight = 8;
            if (lines.size() > 1) {
                totalHeight += (lines.size() - 1) * 10;
            }
            if (innerX + maxWidth > this.f_96543_) {
                innerX -= 28 + maxWidth;
            }
            if (n2 + totalHeight + 6 > this.f_96544_) {
                n = this.f_96544_ - totalHeight - 6;
            }
            matrices.m_85836_();
            FabricationConfigScreen.m_93172_((PoseStack)matrices, (int)(innerX - 3), (int)(n - 3), (int)(innerX + maxWidth + 3), (int)(n + totalHeight + 3), (int)-1442840576);
            MultiBufferSource.BufferSource vcp = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            matrices.m_85837_(0.0, 0.0, 400.0);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence line = lines.get(i);
                if (line != null) {
                    void var7_12;
                    this.f_96547_.m_92733_(line, (float)innerX, (float)var7_12, -1, false, matrices.m_85850_().m_85861_(), (MultiBufferSource)vcp, false, 0, 0xF000F0);
                }
                var7_12 += 10;
            }
            vcp.m_109911_();
            matrices.m_85849_();
        }
    }

    @FunctionalInterface
    public static interface FeatureSubmenu {
        public Screen construct(Screen var1, PrideFlagRenderer var2, String var3, String var4);
    }

    public static enum ConfigValueFlag {
        CLIENT_ONLY,
        REQUIRES_FABRIC_API,
        SHOW_SOURCE_SECTION,
        HIGHLIGHT_QUERY_MATCH;

    }

    public class DrawableSave
    implements SelectionScreen.PreciseDrawable<File> {
        final File file;
        ResourceLocation icon;

        public DrawableSave(File file) {
            this.file = file;
            File iconFile = new File(file, "icon.png");
            this.icon = new ResourceLocation("fabrication", "worlds/" + this.hashCode());
            if (iconFile.isFile()) {
                try {
                    FileInputStream inputStream = new FileInputStream(iconFile);
                    NativeImage nativeImage = NativeImage.m_85058_((InputStream)inputStream);
                    DynamicTexture nativeImageBackedTexture = new DynamicTexture(nativeImage);
                    FabricationConfigScreen.this.f_96541_.m_91097_().m_118495_(this.icon, (AbstractTexture)nativeImageBackedTexture);
                    inputStream.close();
                }
                catch (Throwable e) {
                    FabLog.error("Invalid icon for world {}", e);
                    this.icon = null;
                }
            } else {
                FabricationConfigScreen.this.f_96541_.m_91097_().m_118513_(this.icon);
                this.icon = null;
            }
        }

        @Override
        public void render(PoseStack matrices, float x, float y, float delta) {
            FabricationConfigScreen.this.f_96547_.m_92750_(matrices, this.file.getName(), 38.0f + x, y, -1);
            FabricationConfigScreen.this.f_96547_.m_92750_(matrices, this.file.getPath(), 38.0f + x, y + 20.0f, -1);
            if (this.icon != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.icon);
                matrices.m_85836_();
                matrices.m_85837_((double)(x % 1.0f), (double)(y % 1.0f), 0.0);
                GuiComponent.m_93143_((PoseStack)matrices, (int)((int)x), (int)((int)y), (int)0, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                matrices.m_85849_();
            }
        }

        @Override
        public int width() {
            return 38 + FabricationConfigScreen.this.f_96547_.m_92895_(this.file.getPath());
        }

        @Override
        public int height() {
            return 38;
        }

        @Override
        public File val() {
            return this.file;
        }
    }
}

