/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.client.FabricationConfigScreen;
import com.unascribed.fabrication.client.OptionalPrideFlag;
import com.unascribed.fabrication.client.PrideFlagRenderer;
import com.unascribed.fabrication.client.ScrollBar;
import com.unascribed.fabrication.interfaces.GetServerConfig;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FabricationSummaryScreen
extends Screen {
    PrideFlagRenderer prideFlag;
    final Screen parent;
    final List<String> features;
    final ScrollBar scrollBar;
    boolean didClick;
    double lastMouseX;
    double lastMouseY;

    public FabricationSummaryScreen(Screen parent, List<String> options) {
        super(Component.m_130674_((String)(MixinConfigPlugin.MOD_NAME + " summary")));
        this.scrollBar = new ScrollBar(this.f_96544_);
        this.didClick = false;
        this.prideFlag = OptionalPrideFlag.get();
        this.parent = parent;
        this.features = options;
    }

    public static FabricationSummaryScreen tryCreate(Screen parent) {
        GetServerConfig gsc;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null || client.m_91092_() != null) {
            ArrayList<String> features = new ArrayList<String>();
            for (String key : FabConf.getAllKeys()) {
                ConfigValues.ResolvedFeature feature = FabConf.getResolvedValue(key, true);
                if (feature == null || !feature.value) continue;
                features.add(key);
            }
            return new FabricationSummaryScreen(parent, features);
        }
        ClientPacketListener cpnh = client.m_91403_();
        if (cpnh instanceof GetServerConfig && (gsc = (GetServerConfig)cpnh).fabrication$hasHandshook()) {
            ArrayList<String> features = new ArrayList<String>();
            for (String key : gsc.fabrication$getServerTrileanConfig().keySet()) {
                ConfigValues.ResolvedFeature feature = ((GetServerConfig)client.m_91403_()).fabrication$getServerTrileanConfig().getOrDefault(key, ConfigValues.ResolvedFeature.DEFAULT_FALSE);
                if (feature == null || !feature.value) continue;
                features.add(key);
            }
            return new FabricationSummaryScreen(parent, features);
        }
        return null;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        FabricationConfigScreen.drawBackground(this.f_96544_, this.f_96543_, this.f_96541_, this.prideFlag, 0.0f, matrices, 0, 0, 0.0f, 0, 0);
        float scroll = this.scrollBar.getScaledScroll(this.f_96541_);
        this.scrollBar.height = -20.0f;
        scroll = (float)(Math.floor((double)scroll * this.f_96541_.m_91268_().m_85449_()) / this.f_96541_.m_91268_().m_85449_());
        float y = 22.0f - scroll;
        for (String key : this.features) {
            if (key.startsWith("general.category")) continue;
            FeaturesFile.FeatureEntry entry = FeaturesFile.get(key);
            float h = 0.0f;
            if (entry == null) {
                h = this.drawWrappedText(matrices, 25.0f, y, "Unknown feature: " + key, this.f_96543_ - 100, 0xFFFFFF, false) + 6;
                this.scrollBar.height += h;
                y += h;
                continue;
            }
            h = this.drawWrappedText(matrices, 25.0f, y, entry.name, this.f_96543_ - 100, 0xFFFFFF, false) + 6;
            h += (float)(this.drawWrappedText(matrices, 50.0f, y + h, entry.desc, this.f_96543_ - 100, 0xFFFFFF, false) + 6);
            this.scrollBar.height += h;
            y += h;
        }
    }

    private int drawWrappedText(PoseStack matrices, float x, float y, String str, int width, int color, boolean fromBottom) {
        int height = 0;
        List lines = this.f_96547_.m_92923_((FormattedText)Component.m_130674_((String)str), width);
        if (fromBottom) {
            y -= 12.0f;
            lines = Lists.reverse((List)lines);
        }
        for (FormattedCharSequence ot : lines) {
            this.f_96547_.m_92877_(matrices, ot, x, y, color);
            y += (float)(fromBottom ? -12 : 12);
            height += 12;
        }
        return height;
    }

    public void m_86600_() {
        super.m_86600_();
        this.scrollBar.tick();
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.scrollBar.scroll(amount * 20.0);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_94757_(double x, double y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 266: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 20.0);
                break;
            }
            case 267: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -20.0);
                break;
            }
            case 265: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 2.0);
                break;
            }
            case 264: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -2.0);
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.didClick = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6574_(Minecraft client, int width, int height) {
        this.scrollBar.displayHeight = height;
        super.m_6574_(client, width, height);
    }
}

