/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.unascribed.fabrication.client.ScrollBar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
class SelectionScreen<T>
extends Screen {
    final Screen parent;
    final List<? extends PreciseDrawable<T>> features;
    final Consumer<T> out;
    final ScrollBar scrollBar;
    boolean didClick;
    double lastMouseX;
    double lastMouseY;

    public SelectionScreen(Screen parent, List<? extends PreciseDrawable<T>> options, Consumer<T> out) {
        super(parent.m_96636_());
        this.scrollBar = new ScrollBar(this.f_96544_);
        this.didClick = false;
        this.out = out;
        this.parent = parent;
        this.features = options;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.parent.f_96544_ = this.f_96544_;
        this.parent.f_96543_ = this.f_96543_;
        this.parent.m_7333_(matrices);
        float scroll = this.scrollBar.getScaledScroll(this.f_96541_);
        this.scrollBar.height = 20.0f;
        scroll = (float)(Math.floor((double)scroll * this.f_96541_.m_91268_().m_85449_()) / this.f_96541_.m_91268_().m_85449_());
        float y = 22.0f - scroll;
        for (PreciseDrawable<T> feature : this.features) {
            feature.render(matrices, 16.0f, y, delta);
            int height = feature.height();
            if ((float)mouseY > y - 2.0f && (float)mouseY < y + (float)height) {
                SelectionScreen.m_93172_((PoseStack)matrices, (int)0, (int)((int)y + height), (int)(feature.width() + 16), (int)((int)y + height + 1), (int)-1);
                if (this.didClick) {
                    this.out.accept(feature.val());
                    this.m_7379_();
                }
            }
            this.scrollBar.height += (float)(9 + height);
            y += (float)(9 + height);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.scrollBar.tick();
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.scrollBar.scroll(amount * 20.0);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_94757_(double x, double y) {
        this.lastMouseX = x;
        this.lastMouseY = y;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 266: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 20.0);
                break;
            }
            case 267: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -20.0);
                break;
            }
            case 265: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, 2.0);
                break;
            }
            case 264: {
                this.m_6050_(this.lastMouseX, this.lastMouseY, -2.0);
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.didClick = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6574_(Minecraft client, int width, int height) {
        this.scrollBar.displayHeight = height;
        super.m_6574_(client, width, height);
    }

    public static interface PreciseDrawable<T> {
        public void render(PoseStack var1, float var2, float var3, float var4);

        public int width();

        public int height();

        public T val();
    }

    public class TextWidget<T>
    implements PreciseDrawable<T> {
        final T o;
        final String text;

        public TextWidget(T o) {
            this.o = o;
            this.text = o.toString();
        }

        @Override
        public void render(PoseStack matrices, float x, float y, float delta) {
            SelectionScreen.this.f_96547_.m_92750_(matrices, this.text, x, y, -1);
        }

        @Override
        public int width() {
            return SelectionScreen.this.f_96547_.m_92895_(this.text);
        }

        @Override
        public int height() {
            return 11;
        }

        @Override
        public T val() {
            return this.o;
        }
    }
}

