/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationClientCommands;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.features.FeatureTaggablePlayers;
import com.unascribed.fabrication.interfaces.TaggablePlayer;
import com.unascribed.fabrication.loaders.LoaderFScript;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import com.unascribed.fabrication.support.OptionalFScript;
import com.unascribed.fabrication.util.Cardinal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.RandomState;

public class FeatureFabricationCommand
implements Feature {
    @Override
    public void apply() {
        Agnos.runForCommandRegistration((dispatcher, registryAccess, dedi) -> {
            try {
                LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)MixinConfigPlugin.MOD_NAME_LOWER);
                FeatureFabricationCommand.addConfig(root, dedi);
                if (EarlyAgnos.isModLoaded("fscript")) {
                    FeatureFabricationCommand.addFScript(root, dedi);
                }
                LiteralArgumentBuilder tag = LiteralArgumentBuilder.literal((String)"tag");
                tag.requires(scs -> FabConf.isEnabled("*.taggable_players") && scs.m_6761_(2));
                LiteralArgumentBuilder add = LiteralArgumentBuilder.literal((String)"add");
                LiteralArgumentBuilder remove = LiteralArgumentBuilder.literal((String)"remove");
                LiteralArgumentBuilder get = LiteralArgumentBuilder.literal((String)"get");
                LiteralArgumentBuilder clear = LiteralArgumentBuilder.literal((String)"clear");
                LiteralArgumentBuilder push = LiteralArgumentBuilder.literal((String)"push");
                LiteralArgumentBuilder pull = LiteralArgumentBuilder.literal((String)"pull");
                for (String key : FeatureTaggablePlayers.validTags.keySet()) {
                    LiteralArgumentBuilder literalKey = Commands.m_82127_((String)key);
                    RequiredArgumentBuilder playerParameter = (RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(c -> this.addTag((CommandContext<CommandSourceStack>)c, EntityArgument.m_91477_((CommandContext)c, (String)"players"), key));
                    ((LiteralArgumentBuilder)literalKey.executes(c -> this.addTag((CommandContext<CommandSourceStack>)c, Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), key))).then((ArgumentBuilder)playerParameter);
                    add.then((ArgumentBuilder)literalKey);
                    FeatureFabricationCommand.setAltKeys(key, alt -> add.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alt).executes(literalKey.getCommand())).then((ArgumentBuilder)playerParameter)));
                    literalKey = Commands.m_82127_((String)key);
                    playerParameter = (RequiredArgumentBuilder)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(c -> this.removeTag((CommandContext<CommandSourceStack>)c, EntityArgument.m_91477_((CommandContext)c, (String)"players"), key));
                    ((LiteralArgumentBuilder)literalKey.executes(c -> this.removeTag((CommandContext<CommandSourceStack>)c, Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), key))).then((ArgumentBuilder)playerParameter);
                    remove.then((ArgumentBuilder)literalKey);
                    FeatureFabricationCommand.setAltKeys(key, alt -> remove.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alt).executes(literalKey.getCommand())).then((ArgumentBuilder)playerParameter)));
                    literalKey = Commands.m_82127_((String)key);
                    literalKey.executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0));
                    literalKey.then(Commands.m_82127_((String)"0").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0)));
                    literalKey.then(Commands.m_82127_((String)"1").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 1)));
                    literalKey.then(Commands.m_82127_((String)"2").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 2)));
                    literalKey.then(Commands.m_82127_((String)"3").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 3)));
                    literalKey.then(Commands.m_82127_((String)"tagged_players_only").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0)));
                    literalKey.then(Commands.m_82127_((String)"untagged_players_only").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 1)));
                    literalKey.then(Commands.m_82127_((String)"tagged_players").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 2)));
                    literalKey.then(Commands.m_82127_((String)"untagged_players").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 3)));
                    push.then((ArgumentBuilder)literalKey);
                    FeatureFabricationCommand.setAltKeys(key, alt -> {
                        LiteralArgumentBuilder literalKey = Commands.m_82127_((String)alt);
                        literalKey.executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0));
                        literalKey.then(Commands.m_82127_((String)"0").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0)));
                        literalKey.then(Commands.m_82127_((String)"1").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 1)));
                        literalKey.then(Commands.m_82127_((String)"2").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 2)));
                        literalKey.then(Commands.m_82127_((String)"3").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 3)));
                        literalKey.then(Commands.m_82127_((String)"tagged_players_only").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 0)));
                        literalKey.then(Commands.m_82127_((String)"untagged_players_only").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 1)));
                        literalKey.then(Commands.m_82127_((String)"tagged_players").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 2)));
                        literalKey.then(Commands.m_82127_((String)"untagged_players").executes(FeatureFabricationCommand.createPushTagCommandContextFor(key, 3)));
                        push.then((ArgumentBuilder)literalKey);
                    });
                    literalKey = Commands.m_82127_((String)key);
                    literalKey.executes(c -> {
                        ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)("TaggablePlayers removed " + key)), true);
                        FeatureTaggablePlayers.remove(key);
                        return 1;
                    });
                    pull.then((ArgumentBuilder)literalKey);
                    FeatureFabricationCommand.setAltKeys(key, alt -> pull.then(LiteralArgumentBuilder.literal((String)alt).executes(literalKey.getCommand())));
                }
                ((LiteralArgumentBuilder)get.executes(c -> this.getTags((CommandContext<CommandSourceStack>)c, ((CommandSourceStack)c.getSource()).m_81375_()))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(c -> this.getTags((CommandContext<CommandSourceStack>)c, EntityArgument.m_91474_((CommandContext)c, (String)"player"))));
                ((LiteralArgumentBuilder)clear.executes(c -> this.clearTags((CommandContext<CommandSourceStack>)c, Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_())))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(c -> this.clearTags((CommandContext<CommandSourceStack>)c, EntityArgument.m_91477_((CommandContext)c, (String)"players"))));
                tag.then((ArgumentBuilder)add);
                tag.then((ArgumentBuilder)remove);
                tag.then((ArgumentBuilder)get);
                tag.then((ArgumentBuilder)clear);
                tag.then((ArgumentBuilder)push);
                tag.then((ArgumentBuilder)pull);
                root.then((ArgumentBuilder)tag);
                LiteralArgumentBuilder analyze = LiteralArgumentBuilder.literal((String)"analyze");
                analyze.requires(scs -> scs.m_6761_(4));
                LiteralArgumentBuilder biome = Commands.m_82127_((String)"biome");
                for (Map.Entry en : BuiltinRegistries.f_123865_.m_6579_()) {
                    ResourceLocation id = ((ResourceKey)en.getKey()).m_135782_();
                    ResourceLocation b = ((ResourceKey)en.getKey()).m_135782_();
                    Command exec = c -> {
                        Level w;
                        HashSet set = Sets.newHashSet((Object[])new ResourceLocation[]{b});
                        try {
                            c.getArgument("dimension", ResourceLocation.class);
                            w = DimensionArgument.m_88808_((CommandContext)c, (String)"dimension");
                        }
                        catch (IllegalArgumentException e) {
                            w = ((CommandSourceStack)c.getSource()).m_81374_().f_19853_;
                        }
                        return this.analyzeBlockDistribution((CommandContext<CommandSourceStack>)c, w, set);
                    };
                    if (id.m_135827_().equals("minecraft")) {
                        biome.then(Commands.m_82127_((String)id.m_135815_()).executes(exec));
                    }
                    biome.then(Commands.m_82127_((String)id.toString()).executes(exec));
                }
                analyze.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"block_distribution").executes(c -> this.analyzeBlockDistribution((CommandContext<CommandSourceStack>)c, ((CommandSourceStack)c.getSource()).m_81374_().f_19853_, null))).then((ArgumentBuilder)biome)).then(Commands.m_82127_((String)"in").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then((ArgumentBuilder)biome)).executes(c -> this.analyzeBlockDistribution((CommandContext<CommandSourceStack>)c, (Level)DimensionArgument.m_88808_((CommandContext)c, (String)"dimension"), null)))));
                root.then((ArgumentBuilder)analyze);
                dispatcher.register(root);
            }
            catch (Throwable t) {
                FabricationMod.featureError(this, t, "Unknown");
            }
        });
    }

    private static Command<CommandSourceStack> createPushTagCommandContextFor(String key, int type) {
        return c -> {
            ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)("TaggablePlayers added " + key)), true);
            FeatureTaggablePlayers.add(key, type);
            return 1;
        };
    }

    private int analyzeBlockDistribution(CommandContext<CommandSourceStack> c, Level world, Set<ResourceLocation> biomesIn) {
        HashSet biomes;
        if (biomesIn != null) {
            biomes = Sets.newHashSet();
            for (ResourceLocation b : biomesIn) {
                biomes.add((Biome)((CommandSourceStack)c.getSource()).m_81377_().m_206579_().m_175515_(Registry.f_122885_).m_7745_(b));
            }
        } else {
            biomes = null;
        }
        String name = MixinConfigPlugin.MOD_NAME_LOWER + "_block_distribution_" + System.currentTimeMillis() + ".tsv";
        ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)"Starting background block distribution analysis"), false);
        ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)"This could take a while, but the server should remain usable"), false);
        ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)("Once complete a file named " + name + " will appear in the server directory")), false);
        ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)"Progress reports will go to the console"), false);
        new Thread(() -> {
            class MutableLong {
                long value = 1L;

                MutableLong() {
                }
            }
            int x = 0;
            int z = 0;
            Cardinal dir = Cardinal.WEST;
            int legLength = 0;
            int i = 0;
            int j = 0;
            int scannedChunks = 0;
            long scanned = 0L;
            long skipped = 0L;
            long goal = (biomes == null ? 8000 : 1000) * 16 * 16 * world.m_141928_();
            HashMap counts = Maps.newHashMap();
            block12: while (true) {
                ChunkAccess chunk;
                if ((chunk = world.m_6522_(x, z, ChunkStatus.f_62326_, false)) == null) {
                    try {
                        int fx = x;
                        int fz = z;
                        chunk = (ChunkAccess)world.m_7654_().m_18691_(() -> world.m_6522_(fx, fz, ChunkStatus.f_62326_, true)).get();
                    }
                    catch (Exception e) {
                        FabLog.warn("Failed to generate chunk at " + x + ", " + z + " for block distribution analysis");
                    }
                }
                if (chunk != null) {
                    ChunkAccess e = chunk;
                    synchronized (e) {
                        for (int cY = 0; cY < chunk.m_141928_(); ++cY) {
                            for (int cX = 0; cX < 16; ++cX) {
                                for (int cZ = 0; cZ < 16; ++cZ) {
                                    LevelChunkSection section;
                                    if (biomes != null) {
                                        ChunkGenerator generator = ((ServerLevel)world).m_7726_().m_8481_();
                                        RandomState noiseConfig = ((ServerLevel)world).m_7726_().m_214994_();
                                        Biome b2 = (Biome)generator.m_62218_().m_203407_(cX + chunk.m_7697_().m_45604_(), cY, cZ + chunk.m_7697_().m_45605_(), noiseConfig.m_224579_()).m_203334_();
                                        if (!biomes.contains(b2)) {
                                            if (++skipped <= goal || scanned != 0L) continue;
                                            FabLog.warn("We have skipped more blocks than our goal and found nothing matching the given biome. Giving up.");
                                            return;
                                        }
                                    }
                                    BlockState state = (section = chunk.m_7103_()[cY / 16]) != null ? section.m_62982_(cX, cY % 16, cZ) : Blocks.f_50626_.m_49966_();
                                    counts.compute(state, (bs, ml) -> {
                                        if (ml == null) {
                                            return new MutableLong();
                                        }
                                        ++ml.value;
                                        return ml;
                                    });
                                    if (++scanned < goal) continue;
                                    break block12;
                                }
                            }
                        }
                    }
                    if (++scannedChunks % 20 == 0) {
                        FabLog.info("Scanned " + scanned + "/" + goal + " blocks... (skipped " + skipped + ") " + scanned * 100L / goal + "% done");
                    }
                }
                if (i >= legLength) {
                    dir = dir.ccw();
                    i = 0;
                    if (++j % 2 == 0) {
                        ++legLength;
                    }
                }
                x += dir.xOfs();
                z += dir.yOfs();
                ++i;
            }
            FabLog.info("Scanned " + scanned + "/" + goal + " blocks (skipped " + skipped + "), 100% done. Writing file");
            FabLog.info("NOTE: " + MixinConfigPlugin.MOD_NAME + " block distribution analysis is NOT A BENCHMARK. Chunk generation speed is intentionally limited to keep servers responsive and not crashing.");
            ArrayList sorted = Lists.newArrayList(counts.entrySet());
            sorted.sort((a, b) -> Long.compare(((MutableLong)b.getValue()).value, ((MutableLong)a.getValue()).value));
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(name)), Charsets.UTF_8);){
                osw.write("blockstate\tpercentage\r\n");
                BigDecimal scannedBD = new BigDecimal(scanned);
                BigDecimal hundred = new BigDecimal(100);
                for (Map.Entry en : sorted) {
                    osw.write(Registry.f_122824_.m_7981_((Object)((BlockState)en.getKey()).m_60734_()).toString().replace("\t", "    "));
                    if (!((BlockState)en.getKey()).m_61148_().isEmpty()) {
                        osw.write("[");
                        boolean first = true;
                        for (Map.Entry stateEn : ((BlockState)en.getKey()).m_61148_().entrySet()) {
                            if (first) {
                                first = false;
                            } else {
                                osw.write(",");
                            }
                            osw.write(((Property)stateEn.getKey()).m_61708_().replace("\t", "    "));
                            osw.write("=");
                            osw.write(((Property)stateEn.getKey()).m_6940_((Comparable)stateEn.getValue()).replace("\t", "    "));
                        }
                        osw.write("]");
                    }
                    osw.write("\t");
                    osw.write(new BigDecimal(((MutableLong)en.getValue()).value).divide(scannedBD, MathContext.DECIMAL64).multiply(hundred).toString());
                    osw.write("\r\n");
                }
                FabLog.info(name + " written to disk.");
            }
            catch (IOException e) {
                FabLog.error("Failed to save block distribution data", e);
            }
        }, MixinConfigPlugin.MOD_NAME + " block analysis").start();
        return 1;
    }

    public static <T extends SharedSuggestionProvider> void addConfig(LiteralArgumentBuilder<T> root, boolean dediServer) {
        LiteralArgumentBuilder config = LiteralArgumentBuilder.literal((String)"config");
        Predicate<SharedSuggestionProvider> permissionPredicate = s -> {
            Entity e;
            if (!(s instanceof CommandSourceStack)) {
                return true;
            }
            CommandSourceStack scs = (CommandSourceStack)s;
            if (scs.m_6761_(2)) {
                return true;
            }
            return scs.m_81377_().m_129792_() && scs.m_81373_() != null && (e = scs.m_81373_()) instanceof Player && scs.m_81377_().m_7779_(((Player)e).m_36316_());
        };
        LiteralArgumentBuilder get = LiteralArgumentBuilder.literal((String)"get");
        for (String s2 : FabConf.getAllKeys()) {
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s2);
            key.executes(c -> {
                String value = FabConf.getRawValue(s2);
                if (value.isEmpty()) {
                    value = "unset";
                }
                boolean def = FabConf.getDefault(s2);
                MutableComponent txt = Component.m_237113_((String)(s2 + " = " + value + " (default " + def + ")"));
                if (!FabConf.isEnabled(s2)) {
                    throw new CommandRuntimeException((Component)txt.m_130940_(ChatFormatting.WHITE));
                }
                FeatureFabricationCommand.sendFeedback((CommandContext<? extends SharedSuggestionProvider>)c, txt, false);
                return 1;
            });
            get.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s2, alt -> get.then(LiteralArgumentBuilder.literal((String)alt).executes(key.getCommand())));
        }
        config.then((ArgumentBuilder)get);
        LiteralArgumentBuilder set = LiteralArgumentBuilder.literal((String)"set");
        for (String s3 : FabConf.getAllKeys()) {
            if (dediServer && FeaturesFile.get((String)s3).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s3);
            String[] values = s3.startsWith("general.") ? (s3.startsWith("general.category") ? ConfigValues.Category.vals : ConfigValues.Feature.vals_true_false) : ConfigValues.Feature.vals_unset_true_false_banned;
            for (String v : values) {
                LiteralArgumentBuilder value = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)v).executes(c -> {
                    FeatureFabricationCommand.setKeyWithFeedback((CommandContext<? extends SharedSuggestionProvider>)c, s3, v, false);
                    return 1;
                });
                key.then((ArgumentBuilder)value);
            }
            set.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s3, alt -> {
                LiteralArgumentBuilder short_key = LiteralArgumentBuilder.literal((String)alt);
                for (CommandNode arg : key.getArguments()) {
                    short_key.then(arg);
                }
                set.then((ArgumentBuilder)short_key);
            });
        }
        set.requires(permissionPredicate);
        config.then((ArgumentBuilder)set);
        LiteralArgumentBuilder setWorld = LiteralArgumentBuilder.literal((String)"setWorld");
        for (String s4 : FabConf.getAllKeys()) {
            String[] values;
            if (dediServer && FeaturesFile.get((String)s4).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s4);
            if (s4.startsWith("general.")) {
                if (s4.startsWith("general.category")) continue;
                values = ConfigValues.Feature.vals_unset_true_false;
            } else {
                values = ConfigValues.Feature.vals_unset_true_false_banned;
            }
            for (String v : values) {
                key.then(LiteralArgumentBuilder.literal((String)v).executes(c -> {
                    FeatureFabricationCommand.setKeyWithFeedback((CommandContext<? extends SharedSuggestionProvider>)c, s4, v, true);
                    return 1;
                }));
            }
            setWorld.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s4, alt -> {
                LiteralArgumentBuilder short_key = LiteralArgumentBuilder.literal((String)alt);
                for (CommandNode arg : key.getArguments()) {
                    short_key.then(arg);
                }
                setWorld.then((ArgumentBuilder)short_key);
            });
        }
        setWorld.requires(permissionPredicate);
        config.then((ArgumentBuilder)setWorld);
        config.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").requires(permissionPredicate)).executes(c -> {
            FabConf.reload();
            if (c.getSource() instanceof CommandSourceStack) {
                FabricationMod.sendConfigUpdate(((CommandSourceStack)c.getSource()).m_81377_(), null);
            }
            FeatureFabricationCommand.sendFeedback((CommandContext<? extends SharedSuggestionProvider>)c, Component.m_237113_((String)(MixinConfigPlugin.MOD_NAME + " configuration reloaded")), true);
            FeatureFabricationCommand.sendFeedback((CommandContext<? extends SharedSuggestionProvider>)c, Component.m_237113_((String)"\u00a7eYou may need to restart the game for the changes to take effect."), false);
            return 1;
        }));
        root.then((ArgumentBuilder)config);
    }

    public static <T extends SharedSuggestionProvider> void addFScript(LiteralArgumentBuilder<T> root, boolean dediServer) {
        LiteralArgumentBuilder script = LiteralArgumentBuilder.literal((String)"fscript");
        LiteralArgumentBuilder get = LiteralArgumentBuilder.literal((String)"get");
        for (String s2 : OptionalFScript.predicateProviders.keySet()) {
            if (dediServer && FeaturesFile.get((String)s2).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)s2).executes(c -> {
                FeatureFabricationCommand.sendFeedback((CommandContext<? extends SharedSuggestionProvider>)c, Component.m_237113_((String)(s2 + ": " + LoaderFScript.get(s2))), false);
                return 1;
            });
            get.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s2, alt -> get.then(LiteralArgumentBuilder.literal((String)alt).executes(key.getCommand())));
        }
        script.then((ArgumentBuilder)get);
        LiteralArgumentBuilder set = LiteralArgumentBuilder.literal((String)"set");
        for (String s3 : OptionalFScript.predicateProviders.keySet()) {
            if (dediServer && FeaturesFile.get((String)s3).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = LiteralArgumentBuilder.literal((String)s3);
            RequiredArgumentBuilder value = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"script", (ArgumentType)StringArgumentType.string()).executes(c -> {
                OptionalFScript.set((CommandContext<? extends SharedSuggestionProvider>)c, s3, (String)c.getArgument("script", String.class));
                return 1;
            });
            key.then((ArgumentBuilder)value);
            set.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s3, alt -> set.then(LiteralArgumentBuilder.literal((String)alt).then((ArgumentBuilder)value)));
        }
        set.requires(s -> s.m_6761_(2));
        script.then((ArgumentBuilder)set);
        LiteralArgumentBuilder unset = LiteralArgumentBuilder.literal((String)"unset");
        for (String s4 : OptionalFScript.predicateProviders.keySet()) {
            if (dediServer && FeaturesFile.get((String)s4).sides == FeaturesFile.Sides.CLIENT_ONLY) continue;
            LiteralArgumentBuilder key = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)s4).executes(c -> {
                OptionalFScript.restoreDefault(s4);
                FeatureFabricationCommand.sendFeedback((CommandContext<? extends SharedSuggestionProvider>)c, Component.m_237113_((String)("Restored default behaviour for " + s4)), true);
                return 1;
            });
            unset.then((ArgumentBuilder)key);
            FeatureFabricationCommand.setAltKeys(s4, alt -> unset.then(LiteralArgumentBuilder.literal((String)alt).executes(key.getCommand())));
        }
        unset.requires(s -> s.m_6761_(2));
        script.then((ArgumentBuilder)unset);
        script.then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reload").requires(s -> s.m_6761_(2))).executes(c -> {
            LoaderFScript.reload();
            OptionalFScript.reload();
            FeatureFabricationCommand.sendFeedback((CommandContext<? extends SharedSuggestionProvider>)c, Component.m_237113_((String)"Fabrication fscript reloaded"), true);
            return 1;
        }));
        root.then((ArgumentBuilder)script);
    }

    public static void sendFeedback(CommandContext<? extends SharedSuggestionProvider> c, MutableComponent text, boolean broadcast) {
        if (c.getSource() instanceof CommandSourceStack) {
            ((CommandSourceStack)c.getSource()).m_81354_((Component)text, broadcast);
        } else {
            FeatureFabricationCommand.sendFeedbackClient(c, text);
        }
    }

    private static void sendFeedbackClient(CommandContext<? extends SharedSuggestionProvider> c, MutableComponent text) {
        FabricationClientCommands.sendFeedback((Component)text);
    }

    private int clearTags(CommandContext<CommandSourceStack> c, Collection<ServerPlayer> players) {
        for (ServerPlayer spe : players) {
            ((TaggablePlayer)spe).fabrication$clearTags();
            ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)"Cleared tags for ").m_7220_(spe.m_5446_()), true);
        }
        return 1;
    }

    private int getTags(CommandContext<CommandSourceStack> c, ServerPlayer player) {
        MutableComponent lt = Component.m_237113_((String)"Tags: ");
        Set<String> tags = ((TaggablePlayer)player).fabrication$getTags();
        if (tags.isEmpty()) {
            lt.m_130946_("none");
        } else {
            lt.m_130946_(Joiner.on((String)", ").join(tags));
        }
        ((CommandSourceStack)c.getSource()).m_81354_((Component)lt, false);
        return 1;
    }

    private int addTag(CommandContext<CommandSourceStack> c, Collection<ServerPlayer> players, String key) {
        if (!FabConf.isEnabled(key)) {
            ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)(key + " has to be enabled for this tag to work")), true);
        }
        if (!FeatureTaggablePlayers.activeTags.containsKey(key)) {
            ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)("Automatically switched " + key + " to TaggablePlayers because a player was tagged with it")), true);
            FeatureTaggablePlayers.add(key, 0);
        }
        for (ServerPlayer spe : players) {
            ((TaggablePlayer)spe).fabrication$setTag(key.substring(key.lastIndexOf(46) + 1), true);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)("Added tag " + key + " to ")).m_7220_(spe.m_5446_()), true);
        }
        return 1;
    }

    private int removeTag(CommandContext<CommandSourceStack> c, Collection<ServerPlayer> players, String pt) {
        for (ServerPlayer spe : players) {
            ((TaggablePlayer)spe).fabrication$setTag(pt.substring(pt.lastIndexOf(46) + 1), false);
            ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)("Removed tag " + pt + " from ")).m_7220_(spe.m_5446_()), true);
        }
        return 1;
    }

    private static void setKeyWithFeedback(CommandContext<? extends SharedSuggestionProvider> c, String key, String value, boolean local) {
        String oldValue = FabConf.getRawValue(key);
        boolean def = FabConf.getDefault(key);
        if (!local && value.equals(oldValue) || local && FabConf.doesWorldContainValue(key, value)) {
            FeatureFabricationCommand.sendFeedback(c, Component.m_237113_((String)(key + " is already set to " + value + " (default " + def + ")")), false);
        } else {
            if (local) {
                FabConf.worldSet(key, value);
            } else {
                FabConf.set(key, value);
            }
            if (c.getSource() instanceof CommandSourceStack) {
                FabricationMod.sendConfigUpdate(((CommandSourceStack)c.getSource()).m_81377_(), key);
            }
            FeatureFabricationCommand.sendFeedback(c, Component.m_237113_((String)(key + " is now set to " + value + " (default " + def + ")" + (local ? " for this world" : ""))), true);
            if (FabricationMod.isAvailableFeature(key) && FabricationMod.updateFeature(key)) {
                return;
            }
        }
    }

    public static void setAltKeys(String key, Consumer<String> set) {
        if (!key.contains(".")) {
            return;
        }
        int i = key.indexOf(46);
        while (i != -1) {
            set.accept("*" + key.substring(i));
            i = key.indexOf(46, i + 1);
        }
        if (key.lastIndexOf(46) != key.indexOf(46)) {
            set.accept(key.substring(0, key.indexOf(46)) + key.substring(key.lastIndexOf(46)));
        }
    }

    @Override
    public boolean undo() {
        return false;
    }

    @Override
    public String getConfigKey() {
        return null;
    }
}

