/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Feature;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.DifficultyCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.ServerLevelData;

@EligibleIf(configAvailable="*.legacy_command_syntax")
public class FeatureLegacyCommandSyntax
implements Feature {
    private boolean applied = false;

    @Override
    public void apply() {
        if (this.applied) {
            return;
        }
        this.applied = true;
        Agnos.runForCommandRegistration((dispatcher, registryAccess, dedi) -> {
            try {
                LiteralArgumentBuilder gmCmd = (LiteralArgumentBuilder)Commands.m_82127_((String)"gamemode").requires(scs -> FabConf.isEnabled("*.legacy_command_syntax") && scs.m_6761_(2));
                for (GameType mode : GameType.values()) {
                    gmCmd.then(((LiteralArgumentBuilder)Commands.m_82127_((String)Integer.toString(mode.m_46392_())).executes(c -> FabRefl.gameModeExecute((CommandContext<CommandSourceStack>)c, Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), mode))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(c -> FabRefl.gameModeExecute((CommandContext<CommandSourceStack>)c, EntityArgument.m_91477_((CommandContext)c, (String)"target"), mode))));
                }
                dispatcher.register(gmCmd);
                LiteralArgumentBuilder diffCmd = (LiteralArgumentBuilder)Commands.m_82127_((String)"difficulty").requires(scs -> FabConf.isEnabled("*.legacy_command_syntax") && scs.m_6761_(2));
                for (Difficulty difficulty : Difficulty.values()) {
                    diffCmd.then(Commands.m_82127_((String)Integer.toString(difficulty.m_19028_())).executes(c -> DifficultyCommand.m_136944_((CommandSourceStack)((CommandSourceStack)c.getSource()), (Difficulty)difficulty)));
                }
                dispatcher.register(diffCmd);
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"experience").requires(scs -> FabConf.isEnabled("*.legacy_command_syntax") && scs.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(c -> FeatureLegacyCommandSyntax.addExperience((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), IntegerArgumentType.getInteger((CommandContext)c, (String)"amount"), false))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(c -> FeatureLegacyCommandSyntax.addExperience((CommandSourceStack)c.getSource(), EntityArgument.m_91477_((CommandContext)c, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)c, (String)"amount"), false))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"lvlAmount", (ArgumentType)StringArgumentType.word()).executes(c -> FeatureLegacyCommandSyntax.addExperience((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), StringArgumentType.getString((CommandContext)c, (String)"lvlAmount")))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(c -> FeatureLegacyCommandSyntax.addExperience((CommandSourceStack)c.getSource(), EntityArgument.m_91477_((CommandContext)c, (String)"targets"), StringArgumentType.getString((CommandContext)c, (String)"lvlAmount"))))));
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"toggledownfall").requires(scs -> FabConf.isEnabled("*.legacy_command_syntax") && scs.m_6761_(2))).executes(c -> {
                    ServerLevel world = ((CommandSourceStack)c.getSource()).m_81372_();
                    ServerLevelData props = FabRefl.getWorldProperties(world);
                    if (props.m_6533_()) {
                        world.m_8606_(12000, 0, false, props.m_6534_());
                    } else {
                        world.m_8606_(0, 12000, true, props.m_6534_());
                    }
                    ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)"Toggled downfall"), true);
                    return 1;
                }));
            }
            catch (Throwable t) {
                FabricationMod.featureError(this, t, "Unknown");
            }
        });
    }

    private static int addExperience(CommandSourceStack source, Collection<? extends ServerPlayer> targets, int amount, boolean areLevels) {
        String string;
        for (ServerPlayer serverPlayer : targets) {
            if (areLevels) {
                serverPlayer.m_6749_(amount);
                continue;
            }
            serverPlayer.m_6756_(amount);
        }
        String string2 = string = areLevels ? "levels" : "points";
        if (targets.size() == 1) {
            source.m_81354_((Component)Component.m_237110_((String)("commands.experience.add." + string + ".success.single"), (Object[])new Object[]{amount, ((ServerPlayer)Iterables.getOnlyElement(targets)).m_5446_()}), true);
        } else {
            source.m_81354_((Component)Component.m_237110_((String)("commands.experience.add." + string + ".success.multiple"), (Object[])new Object[]{amount, targets.size()}), true);
        }
        return targets.size();
    }

    private static int addExperience(CommandSourceStack source, Collection<? extends ServerPlayer> targets, String amount) throws CommandSyntaxException {
        Integer i;
        if ((amount.endsWith("l") || amount.endsWith("L")) && (i = Ints.tryParse((String)amount.substring(0, amount.length() - 1))) != null) {
            return FeatureLegacyCommandSyntax.addExperience(source, targets, i, true);
        }
        throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Invalid XP amount")).create();
    }

    @Override
    public boolean undo() {
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.legacy_command_syntax";
    }
}

