/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.compat.FabricLoader;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.SpecialEligibility;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

@EligibleIf(configAvailable="*.mods_command", specialConditions={SpecialEligibility.NOT_FORGE})
public class FeatureModsCommandFabric
implements Feature {
    private boolean applied = false;

    @Override
    public void apply() {
        if (this.applied) {
            return;
        }
        this.applied = true;
        Agnos.runForCommandRegistration((dispatcher, registryAccess, dedi) -> {
            try {
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"mods").requires(s -> FabConf.isEnabled("*.mods_command"))).then(LiteralArgumentBuilder.literal((String)"all").executes(c -> {
                    this.sendMods((CommandContext<CommandSourceStack>)c, true);
                    return 1;
                }))).executes(c -> {
                    this.sendMods((CommandContext<CommandSourceStack>)c, false);
                    return 1;
                }));
                try {
                    Class.forName("org.bukkit.Bukkit");
                }
                catch (Throwable t) {
                    dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"plugins").executes(c -> {
                        ((CommandSourceStack)c.getSource()).m_81354_((Component)Component.m_237113_((String)"\u00a7cThis ain't no Bukkit!\nTry /mods"), false);
                        return 1;
                    }));
                }
            }
            catch (Throwable t) {
                FabricationMod.featureError(this, t, "Unknown");
            }
        });
    }

    @Override
    public boolean undo() {
        return true;
    }

    private void sendMods(CommandContext<CommandSourceStack> c, boolean all) {
        MutableComponent mt = Component.m_237113_((String)"Mods: ");
        boolean first = true;
        for (ModContainer mc : FabricLoader.getInstance().getAllMods()) {
            ModMetadata mm = mc.getMetadata();
            if (mm.getId().equals("minecraft") || mm.getId().startsWith("fabric-") && !all) continue;
            if (!first) {
                mt.m_7220_((Component)Component.m_237113_((String)", ").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RESET)));
            } else {
                first = false;
            }
            StringBuilder desc = new StringBuilder(mm.getDescription().replace("\r", ""));
            if (desc.length() > 0) {
                desc.append("\n\n");
            }
            if (!mm.getAuthors().isEmpty()) {
                desc.append("Authors: ");
                boolean firstAuthor = true;
                for (Person p : mm.getAuthors()) {
                    if (!firstAuthor) {
                        desc.append(", ");
                    } else {
                        firstAuthor = false;
                    }
                    desc.append(p.getName());
                }
                desc.append("\n");
            }
            desc.append("ID: ");
            desc.append(mm.getId());
            MutableComponent lt = Component.m_237113_((String)mm.getName());
            Style s = Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)desc.toString())));
            if (mm.getContact() != null && mm.getContact().get("homepage").isPresent()) {
                s = s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, (String)mm.getContact().get("homepage").get()));
            }
            lt.m_6270_(s);
            mt.m_7220_((Component)lt);
        }
        ((CommandSourceStack)c.getSource()).m_81354_((Component)mt, false);
    }

    @Override
    public String getConfigKey() {
        return "*.mods_command";
    }
}

