/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.mojang.blaze3d.platform.NativeImage;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.client.SpriteLava;
import com.unascribed.fabrication.client.SpriteLavaFlow;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;

@EligibleIf(anyConfigAvailable={"*.old_lava", "*.old_lava_scaling"}, envMatches=Env.CLIENT)
public class FeatureOldLava
implements Feature {
    public static void onLoaded(TextureAtlas atlas, TextureAtlas.Preparations data) {
        try {
            if (FabConf.isAnyEnabled("*.old_lava") && atlas.m_118330_().toString().equals("minecraft:textures/atlas/blocks.png")) {
                int lavaFlowHeight;
                int lavaFlowWidth;
                int lavaHeight;
                int lavaWidth;
                ResourceLocation still = new ResourceLocation("block/lava_still");
                ResourceLocation flow = new ResourceLocation("block/lava_flow");
                TextureAtlasSprite originalLava = atlas.m_118316_(still);
                TextureAtlasSprite originalLavaFlow = atlas.m_118316_(flow);
                if (FabConf.isEnabled("*.old_lava_scaling")) {
                    lavaWidth = originalLava.m_118405_();
                    lavaHeight = originalLava.m_118408_();
                    lavaFlowWidth = originalLavaFlow.m_118405_();
                    lavaFlowHeight = originalLavaFlow.m_118408_();
                } else {
                    lavaHeight = 16;
                    lavaWidth = 16;
                    lavaFlowHeight = 32;
                    lavaFlowWidth = 32;
                }
                SpriteLava newLava = new SpriteLava(atlas, new TextureAtlasSprite.Info(still, lavaWidth, lavaHeight, AnimationMetadataSection.f_119012_), FabRefl.Client.getMaxLevel(data), FabRefl.Client.getWidth(data), FabRefl.Client.getHeight(data), FabRefl.Client.getX(originalLava), FabRefl.Client.getY(originalLava), new NativeImage(lavaWidth, lavaHeight, false));
                SpriteLavaFlow newLavaFlow = new SpriteLavaFlow(atlas, new TextureAtlasSprite.Info(flow, lavaFlowWidth, lavaFlowHeight, AnimationMetadataSection.f_119012_), FabRefl.Client.getMaxLevel(data), FabRefl.Client.getWidth(data), FabRefl.Client.getHeight(data), FabRefl.Client.getX(originalLavaFlow), FabRefl.Client.getY(originalLavaFlow), new NativeImage(lavaFlowWidth, lavaFlowHeight, false));
                FabRefl.Client.getSprites(atlas).put(still, newLava);
                FabRefl.Client.getSprites(atlas).put(flow, newLavaFlow);
                int origIdx = FabRefl.Client.getAnimatedSprites(atlas).indexOf(originalLava);
                int origFlowIdx = FabRefl.Client.getAnimatedSprites(atlas).indexOf(originalLavaFlow);
                if (origIdx != -1) {
                    FabRefl.Client.getAnimatedSprites(atlas).set(origIdx, newLava);
                } else {
                    FabRefl.Client.getAnimatedSprites(atlas).add(newLava);
                }
                if (origFlowIdx != -1) {
                    FabRefl.Client.getAnimatedSprites(atlas).set(origFlowIdx, newLavaFlow);
                } else {
                    FabRefl.Client.getAnimatedSprites(atlas).add(newLavaFlow);
                }
                for (int i = 0; i < 100; ++i) {
                    newLava.tickAnimation();
                    newLavaFlow.tickAnimation();
                }
                newLavaFlow.m_7673_();
                newLava.m_7673_();
            }
        }
        catch (Throwable t) {
            FabricationMod.featureError(FeatureOldLava.class, "*.old_lava", t, "Unknown");
        }
    }

    @Override
    public void apply() {
        if (Minecraft.m_91087_().m_91098_() != null) {
            Minecraft.m_91087_().m_91391_();
        }
    }

    @Override
    public boolean undo() {
        this.apply();
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.old_lava";
    }

    public static void mip(NativeImage[] images) {
        if (images.length <= 1) {
            return;
        }
        for (int i = 1; i <= images.length - 1; ++i) {
            NativeImage src = images[i - 1];
            NativeImage mip = images[i];
            int w = mip.m_84982_();
            int h = mip.m_85084_();
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    mip.m_84988_(x, y, FabRefl.Client.MipmapHelper_blend(src.m_84985_(x * 2 + 0, y * 2 + 0), src.m_84985_(x * 2 + 1, y * 2 + 0), src.m_84985_(x * 2 + 0, y * 2 + 1), src.m_84985_(x * 2 + 1, y * 2 + 1), false));
                }
            }
        }
    }
}

