/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.client.FabricationConfigScreen;
import com.unascribed.fabrication.features.FeatureCrawling;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.util.Locale;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

@EligibleIf(configAvailable="*.toggle_stance", envMatches=Env.CLIENT)
public class FeatureToggleStance
implements Feature {
    public static KeyMapping keybind;
    public static Stance currentStance;
    public static int toggleTime;
    public static int lastAge;

    @Override
    public void apply() {
        keybind = new KeyMapping("[" + MixinConfigPlugin.MOD_NAME + "] Toggle Stance", InputConstants.f_84822_.m_84873_(), "key.categories.movement"){

            public void m_7249_(boolean pressed) {
                if (EarlyAgnos.isForge() && pressed && Minecraft.m_91087_().f_91080_ != null) {
                    return;
                }
                if (!pressed && Minecraft.m_91087_().m_91403_() == null) {
                    currentStance = Stance.STANDING;
                }
                if (!this.m_90857_() && pressed) {
                    Stance prev = currentStance;
                    currentStance = currentStance.next();
                    if (prev.crawling != FeatureToggleStance.currentStance.crawling) {
                        FeatureCrawling.setCrawling(FeatureToggleStance.currentStance.crawling, FeatureToggleStance.currentStance.crawling);
                    }
                    toggleTime = 0;
                }
                super.m_7249_(pressed);
            }
        };
        Agnos.registerKeyBinding(keybind);
        Agnos.runForHudRender((ms, d) -> {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer p = mc.f_91074_;
            if (p == null) {
                return;
            }
            if (toggleTime < 40) {
                Window w = mc.m_91268_();
                float a = FabricationConfigScreen.sCurve5(1.0f - (float)toggleTime / 40.0f);
                ResourceLocation tex = new ResourceLocation("fabrication", "textures/stance/" + currentStance.name().toLowerCase(Locale.ROOT) + ".png");
                RenderSystem.m_69453_();
                RenderSystem.m_69478_();
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)tex);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
                GuiComponent.m_93143_((PoseStack)ms, (int)(w.m_85445_() / 2 - 48), (int)((w.m_85446_() - 32) / 2), (int)0, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69461_();
            }
            if (p.f_19797_ != lastAge) {
                lastAge = p.f_19797_;
                ++toggleTime;
            }
        });
    }

    @Override
    public boolean undo() {
        return false;
    }

    @Override
    public String getConfigKey() {
        return "*.toggle_stance";
    }

    static {
        currentStance = Stance.STANDING;
        toggleTime = 1000;
        lastAge = 0;
    }

    public static enum Stance {
        STANDING(false, false),
        SNEAKING(true, false),
        CRAWLING(false, true);

        public final boolean sneaking;
        public final boolean crawling;

        private Stance(boolean sneaking, boolean crawling) {
            this.sneaking = sneaking;
            this.crawling = crawling;
        }

        public Stance next() {
            switch (this) {
                case STANDING: {
                    return SNEAKING;
                }
                case SNEAKING: {
                    return FabConf.isEnabled("*.crawling") ? CRAWLING : STANDING;
                }
                case CRAWLING: {
                    return STANDING;
                }
            }
            throw new AssertionError((Object)("missing case for " + this));
        }
    }
}

