/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.loaders;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.support.ConfigLoader;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import org.jetbrains.annotations.Nullable;

public class LoaderDimensionalTools
implements ConfigLoader {
    public static final SetMultimap<ResourceLocation, MohsIdentifier> blockAssociations = HashMultimap.create();
    public static final SetMultimap<ResourceLocation, MohsIdentifier> blockTagAssociations = HashMultimap.create();
    public static final SetMultimap<ResourceLocation, MohsIdentifier> toolAssociations = HashMultimap.create();
    public static final SetMultimap<ResourceLocation, MohsIdentifier> toolTagAssociations = HashMultimap.create();
    public static final SetMultimap<ResourceLocation, @Nullable MohsIdentifier> ingredientAssociations = HashMultimap.create();
    public static final SetMultimap<ResourceLocation, @Nullable MohsIdentifier> ingredientTagAssociations = HashMultimap.create();
    public static final Set<ResourceLocation> substitutableItems = Sets.newHashSet();
    public static final Set<ResourceLocation> substitutableItemTags = Sets.newHashSet();
    public static final List<NameSubstitution> nameSubstitutions = Lists.newArrayList();
    public static final Table<MohsIdentifier, ResourceLocation, Integer> oneToOneDamageFactors = HashBasedTable.create();
    public static final Map<ResourceLocation, Integer> foreignOnNativeDamageFactors = Maps.newHashMap();
    public static final Map<ResourceLocation, Integer> foreignHardOnNativeDamageFactors = Maps.newHashMap();
    public static final Map<MohsIdentifier, Integer> nativeOnForeignDamageFactors = Maps.newHashMap();

    public static int getDamageFactor(@Nullable MohsIdentifier tool, @Nullable ResourceLocation block) {
        if (tool != null) {
            if (oneToOneDamageFactors.contains((Object)tool, (Object)block)) {
                return (Integer)oneToOneDamageFactors.get((Object)tool, (Object)block);
            }
            MohsIdentifier toolSoft = tool.asSoft();
            if (tool.isHard() && oneToOneDamageFactors.contains((Object)toolSoft, (Object)block)) {
                return (Integer)oneToOneDamageFactors.get((Object)toolSoft, (Object)block);
            }
            if (!tool.getId().equals((Object)block)) {
                if (nativeOnForeignDamageFactors.containsKey(tool)) {
                    return nativeOnForeignDamageFactors.get(tool);
                }
                if (tool.isHard() && nativeOnForeignDamageFactors.containsKey(toolSoft)) {
                    return nativeOnForeignDamageFactors.get(toolSoft);
                }
            }
        }
        if (tool == null || !tool.getId().equals((Object)block)) {
            if (tool != null && tool.isHard() && foreignHardOnNativeDamageFactors.containsKey(block)) {
                return foreignHardOnNativeDamageFactors.get(block);
            }
            if (foreignOnNativeDamageFactors.containsKey(block)) {
                return foreignOnNativeDamageFactors.get(block);
            }
        }
        return 1;
    }

    public static Set<MohsIdentifier> getAssociatedDimensionsForTool(ItemStack stack) {
        HashSet dims = LoaderDimensionalTools.processTags(toolAssociations.get((Object)Registry.f_122827_.m_7981_((Object)stack.m_41720_())), toolTagAssociations, Registry.f_122904_, stack.m_41720_().m_204114_());
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128471_("fabrication:ActLikeGold")) {
                dims = Sets.newHashSet(dims);
                dims.add(new MohsIdentifier(true, BuiltinDimensionTypes.f_223543_));
            }
            if (stack.m_41783_().m_128425_("fabrication:HonoraryDimensions", 9)) {
                dims = Sets.newHashSet((Iterable)dims);
                ListTag li = stack.m_41783_().m_128437_("fabrication:HonoraryDimensions", 8);
                for (int i = 0; i < li.size(); ++i) {
                    try {
                        dims.add(MohsIdentifier.parse(li.m_128778_(i)));
                        continue;
                    }
                    catch (ResourceLocationException e) {
                        FabLog.warn("Bad honorary dimension " + li.m_128778_(i) + " in stack " + Registry.f_122827_.m_7981_((Object)stack.m_41720_()) + stack.m_41783_());
                    }
                }
            }
        }
        return dims;
    }

    public static Set<MohsIdentifier> getAssociatedDimensionsForIngredient(ItemStack stack) {
        return LoaderDimensionalTools.processTags(ingredientAssociations.get((Object)Registry.f_122827_.m_7981_((Object)stack.m_41720_())), ingredientTagAssociations, Registry.f_122904_, stack.m_41720_().m_204114_());
    }

    public static Set<MohsIdentifier> getAssociatedDimensions(Block block) {
        return LoaderDimensionalTools.processTags(blockAssociations.get((Object)Registry.f_122824_.m_7981_((Object)block)), blockTagAssociations, Registry.f_122901_, block.m_204297_());
    }

    private static <T, U> Set<U> processTags(Set<U> out, SetMultimap<ResourceLocation, U> assoc, ResourceKey<? extends Registry<T>> key, Holder<T> entry) {
        boolean cloned = false;
        for (Map.Entry en : assoc.entries()) {
            TagKey tag = TagKey.m_203882_(key, (ResourceLocation)((ResourceLocation)en.getKey()));
            if (!entry.m_203656_(tag)) continue;
            if (!cloned) {
                out = Sets.newHashSet(out);
                cloned = true;
            }
            out.add(en.getValue());
        }
        return out;
    }

    public static boolean isSubstitutable(Item item) {
        if (substitutableItems.contains(Registry.f_122827_.m_7981_((Object)item))) {
            return true;
        }
        for (ResourceLocation id : substitutableItemTags) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)id);
            if (!item.m_204114_().m_203656_(tag)) continue;
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void load(Path configDir, QDIni config, boolean loadError) {
        LoaderDimensionalTools.blockAssociations.clear();
        LoaderDimensionalTools.blockTagAssociations.clear();
        LoaderDimensionalTools.toolAssociations.clear();
        LoaderDimensionalTools.toolTagAssociations.clear();
        LoaderDimensionalTools.ingredientAssociations.clear();
        LoaderDimensionalTools.ingredientTagAssociations.clear();
        LoaderDimensionalTools.substitutableItems.clear();
        LoaderDimensionalTools.substitutableItemTags.clear();
        LoaderDimensionalTools.nameSubstitutions.clear();
        LoaderDimensionalTools.oneToOneDamageFactors.clear();
        LoaderDimensionalTools.foreignOnNativeDamageFactors.clear();
        LoaderDimensionalTools.foreignHardOnNativeDamageFactors.clear();
        LoaderDimensionalTools.nativeOnForeignDamageFactors.clear();
        for (Object key : config.keySet()) {
            block30: {
                block33: {
                    block32: {
                        block31: {
                            block29: {
                                realKey = key;
                                defaultNamespace = "minecraft";
                                colon = key.indexOf(58);
                                if (colon != -1) {
                                    dot = key.indexOf(46);
                                    defaultNamespace = key.substring(dot + 1, colon);
                                    key = key.substring(0, dot + 1) + key.substring(colon + 1);
                                }
                                starValid = false;
                                tagTargetMohs = null;
                                targetMohs = null;
                                tagTarget = null;
                                target = null;
                                setTagTarget = null;
                                setTarget = null;
                                if (!key.startsWith("blocks.")) break block29;
                                key = key.substring(7);
                                targetMohs = LoaderDimensionalTools.blockAssociations;
                                tagTargetMohs = LoaderDimensionalTools.blockTagAssociations;
                                break block30;
                            }
                            if (!key.startsWith("tools.")) break block31;
                            key = key.substring(6);
                            targetMohs = LoaderDimensionalTools.toolAssociations;
                            tagTargetMohs = LoaderDimensionalTools.toolTagAssociations;
                            break block30;
                        }
                        if (!key.startsWith("materials.")) break block32;
                        key = key.substring(10);
                        targetMohs = LoaderDimensionalTools.ingredientAssociations;
                        tagTargetMohs = LoaderDimensionalTools.ingredientTagAssociations;
                        starValid = true;
                        break block30;
                    }
                    if (!key.startsWith("substitutable.")) break block33;
                    key = key.substring(14);
                    setTarget = LoaderDimensionalTools.substitutableItems;
                    setTagTarget = LoaderDimensionalTools.substitutableItemTags;
                    break block30;
                }
                if (key.startsWith("name_substitutions.")) {
                    slash = (key = key.substring(19)).indexOf(47);
                    if (slash == -1) {
                        FabLog.warn((String)key + " is not a valid substitution at " + config.getBlame(realKey, 0));
                        continue;
                    }
                    dim = key.substring(0, slash);
                    find = key.substring(slash + 1);
                    try {
                        dimId = FabricationMod.createIdWithCustomDefault(defaultNamespace, dim);
                    }
                    catch (ResourceLocationException e) {
                        FabLog.warn((String)key + " is not a valid identifier at " + config.getBlame(realKey, 0));
                        continue;
                    }
                    for (String replace : config.getAll(realKey)) {
                        LoaderDimensionalTools.nameSubstitutions.add(new NameSubstitution(dimId, find, replace));
                    }
                    continue;
                }
                if (!key.startsWith("damage_factors.")) break block30;
                angle = (key = key.substring(15)).indexOf(62);
                if (angle == -1) {
                    FabLog.warn((String)key + " is not a valid damage factor mapping at " + config.getBlame(realKey));
                    continue;
                }
                tool = key.substring(0, angle);
                toolHard = tool.endsWith("!");
                if (toolHard) {
                    tool = tool.substring(0, tool.length() - 1);
                }
                toolId = "*".equals(tool) != false ? null : FabricationMod.createIdWithCustomDefault(defaultNamespace, tool);
                dim = key.substring(angle + 1);
                v0 = dimId = "*".equals(dim) != false ? null : FabricationMod.createIdWithCustomDefault(defaultNamespace, dim);
                if (toolId == null && dimId == null) {
                    FabLog.warn((String)key + " is not a valid damage factor mapping at " + config.getBlame(realKey));
                    continue;
                }
                valueOpt = config.getInt(realKey);
                if (valueOpt.isPresent()) ** GOTO lbl94
                if ("Infinity".equals(config.get(realKey))) {
                    value = 0x7FFFFFFF;
                } else {
                    FabLog.warn(config.get(realKey) + " is not a valid damage factor value at " + config.getBlame(realKey));
                    continue;
lbl94:
                    // 1 sources

                    value = valueOpt.get();
                }
                if (toolId == null) {
                    (toolHard != false ? LoaderDimensionalTools.foreignHardOnNativeDamageFactors : LoaderDimensionalTools.foreignOnNativeDamageFactors).put(dimId, value);
                    continue;
                }
                if (dimId == null) {
                    LoaderDimensionalTools.nativeOnForeignDamageFactors.put(new MohsIdentifier(toolHard, toolId), value);
                    continue;
                }
                LoaderDimensionalTools.oneToOneDamageFactors.put((Object)new MohsIdentifier(toolHard, toolId), (Object)dimId, (Object)value);
                continue;
            }
            if (targetMohs != null || target != null || setTarget != null) {
                tag = key.startsWith("#");
                if (tag) {
                    key = key.substring(1);
                }
                try {
                    keyId = FabricationMod.createIdWithCustomDefault(defaultNamespace, (String)key);
                }
                catch (ResourceLocationException e) {
                    FabLog.warn((String)key + " is not a valid identifier at " + config.getBlame(realKey, 0));
                    continue;
                }
                if (targetMohs != null) {
                    i = 0;
                    for (String s : config.getAll(realKey)) {
                        hard = s.endsWith("!");
                        if (hard && targetMohs == null) {
                            FabLog.warn(s + " is not a valid identifier at " + config.getBlame(realKey, i));
                            continue;
                        }
                        if (hard) {
                            s = s.substring(0, s.length() - 1);
                        }
                        wrapper = targetMohs != null ? (Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$load$0(boolean net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;)((boolean)hard) : (Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$load$1(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;)();
                        if (tag) {
                            tgt = targetMohs != null ? tagTargetMohs : tagTarget;
                        } else {
                            v1 /* !! */  = tgt = targetMohs != null ? targetMohs : tagTarget;
                        }
                        if (s.equals("*")) {
                            if (!starValid) {
                                FabLog.warn(s + " is not a valid identifier at " + config.getBlame(realKey, i));
                                continue;
                            }
                            tgt.put((Object)keyId, null);
                            continue;
                        }
                        try {
                            valueId = FabricationMod.createIdWithCustomDefault(defaultNamespace, s);
                            tgt.put((Object)keyId, wrapper.apply((Object)valueId));
                        }
                        catch (ResourceLocationException e) {
                            FabLog.warn(s + " is not a valid identifier at " + config.getBlame(realKey, i));
                            continue;
                        }
                        ++i;
                    }
                    continue;
                }
                if (setTarget == null || !config.getBoolean(realKey).orElse(false).booleanValue()) continue;
                (tag != false ? setTagTarget : setTarget).add(keyId);
                continue;
            }
            for (i = 0; i < config.getAll(realKey).size(); ++i) {
                FabLog.warn("Don't know what to do with " + config.getBlame(realKey, i));
            }
        }
    }

    @Override
    public String getConfigName() {
        return "dimensional_tools";
    }

    private static /* synthetic */ Object lambda$load$1(ResourceLocation id) {
        return id;
    }

    private static /* synthetic */ Object lambda$load$0(boolean hard, ResourceLocation id) {
        return new MohsIdentifier(hard, id);
    }

    public static final class MohsIdentifier {
        private final boolean hard;
        private final ResourceLocation id;

        public MohsIdentifier(boolean hard, ResourceLocation id) {
            this.hard = hard;
            this.id = id;
        }

        public static MohsIdentifier createHard(ResourceLocation id) {
            return new MohsIdentifier(true, id);
        }

        public static MohsIdentifier createSoft(ResourceLocation id) {
            return new MohsIdentifier(false, id);
        }

        public static MohsIdentifier parse(String s) {
            boolean hard = s.endsWith("!");
            if (hard) {
                s = s.substring(0, s.length() - 1);
            }
            return new MohsIdentifier(hard, new ResourceLocation(s));
        }

        public MohsIdentifier asSoft() {
            if (!this.hard) {
                return this;
            }
            return new MohsIdentifier(false, this.id);
        }

        public boolean isHard() {
            return this.hard;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public String getPath() {
            return this.id.m_135815_();
        }

        public String getNamespace() {
            return this.id.m_135827_();
        }

        public String toString() {
            return this.id.toString() + (this.hard ? "!" : "");
        }

        public int hashCode() {
            return Objects.hash(this.id, this.hard);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MohsIdentifier that = (MohsIdentifier)obj;
            if (this.hard != that.hard) {
                return false;
            }
            return Objects.equals(this.id, that.id);
        }
    }

    public static final class NameSubstitution {
        public final ResourceLocation dimId;
        public final String find;
        public final String replace;

        private NameSubstitution(ResourceLocation dimId, String find, String replace) {
            this.dimId = dimId;
            this.find = find;
            this.replace = replace;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface DimensionId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface ItemTagId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface ItemId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface BlockTagId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    private static @interface BlockId {
    }
}

