/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.loaders;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.features.FeatureTaggablePlayers;
import com.unascribed.fabrication.support.ConfigLoader;
import java.nio.file.Path;
import java.util.Optional;

public class LoaderTaggablePlayers
implements ConfigLoader {
    public static final LoaderTaggablePlayers instance = new LoaderTaggablePlayers();

    public void set(String key, int val) {
        switch (val) {
            case 0: {
                this.set(key, "tagged_players_only");
                break;
            }
            case 1: {
                this.set(key, "untagged_players_only");
                break;
            }
            case 2: {
                this.set(key, "tagged_players");
                break;
            }
            case 3: {
                this.set(key, "untagged_players");
                break;
            }
            default: {
                this.set(key, String.valueOf(val));
            }
        }
    }

    @Override
    public void load(Path configDir, QDIni config, boolean loadError) {
        for (String key : config.keySet()) {
            if (!FabConf.isValid(key)) {
                FabLog.error("TaggablePlayers config contains invalid key: " + key);
                continue;
            }
            Optional<String> val = config.get(key);
            if (val.isPresent()) {
                try {
                    FeatureTaggablePlayers.add(key, Integer.parseInt(val.get()), false);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            int i = 0;
            switch (val.orElse("").trim()) {
                case "untagged_players_only": {
                    i = 1;
                    break;
                }
                case "tagged_players": {
                    i = 2;
                    break;
                }
                case "untagged_players": {
                    i = 3;
                }
            }
            FeatureTaggablePlayers.add(key, i, false);
        }
    }

    @Override
    public String getConfigName() {
        return "taggable_players";
    }
}

