/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.logic;

import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class PingPrivacyPersistentState
extends SavedData {
    private static final String name = "fabrication_ping_privacy";
    private final Map<InetAddress, Long> knownIps = Maps.newHashMap();
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();

    public static PingPrivacyPersistentState get(ServerLevel world) {
        return (PingPrivacyPersistentState)world.m_8895_().m_164861_(PingPrivacyPersistentState::fromNbt, PingPrivacyPersistentState::new, name);
    }

    public void addKnownIp(InetAddress addr) {
        try {
            this.rwl.writeLock().lock();
            this.knownIps.put(addr, System.currentTimeMillis());
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.m_77762_();
    }

    public boolean isKnownAndRecent(InetAddress addr) {
        try {
            this.rwl.readLock().lock();
            boolean bl = PingPrivacyPersistentState.isRecent(this.knownIps.getOrDefault(addr, 0L));
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private static boolean isRecent(long time) {
        return System.currentTimeMillis() - time < TimeUnit.DAYS.toMillis(7L);
    }

    public static PingPrivacyPersistentState fromNbt(CompoundTag tag) {
        PingPrivacyPersistentState rtrn = new PingPrivacyPersistentState();
        ListTag li = tag.m_128437_("KnownIPs", 10);
        for (int i = 0; i < li.size(); ++i) {
            InetAddress addr;
            CompoundTag c = li.m_128728_(i);
            long time = c.m_128454_("Time");
            if (!PingPrivacyPersistentState.isRecent(time)) continue;
            try {
                addr = InetAddress.getByAddress(c.m_128463_("IP"));
            }
            catch (UnknownHostException e) {
                continue;
            }
            rtrn.knownIps.put(addr, time);
        }
        return rtrn;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag li = new ListTag();
        for (Map.Entry<InetAddress, Long> en : this.knownIps.entrySet()) {
            CompoundTag c = new CompoundTag();
            c.m_128382_("IP", en.getKey().getAddress());
            c.m_128356_("Time", en.getValue().longValue());
            li.add((Object)c);
        }
        tag.m_128365_("KnownIPs", (Tag)li);
        return tag;
    }
}

