/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.logic;

import com.google.common.collect.ImmutableSet;
import com.unascribed.fabrication.FabConf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class WaterFillsOnBreak {
    private static final ImmutableSet<Direction> CHECK_DIRECTIONS = ImmutableSet.of((Object)Direction.UP, (Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.SOUTH, (Object)Direction.WEST);

    public static boolean shouldFill(Level world, BlockPos pos) {
        int countWater = 0;
        int countAir = 0;
        BlockPos lastWater = null;
        for (Direction d : CHECK_DIRECTIONS) {
            BlockState bs;
            BlockPos p = pos.m_121945_(d);
            FluidState fluid = world.m_6425_(p);
            if (fluid.m_205070_(FluidTags.f_13131_) && fluid.m_76170_()) {
                lastWater = p;
                ++countWater;
                continue;
            }
            if (d == Direction.UP || !(bs = world.m_8055_(p)).m_60795_()) continue;
            ++countAir;
        }
        if (!FabConf.isEnabled("*.water_fills_on_break_strict") || countWater != 1) {
            return countWater > countAir;
        }
        for (Direction d : Direction.values()) {
            FluidState fluid = world.m_6425_(lastWater.m_121945_(d));
            if (!fluid.m_205070_(FluidTags.f_13131_) || !fluid.m_76170_()) continue;
            return true;
        }
        return false;
    }
}

