/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.a_fixes.stable_cacti;

import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import com.unascribed.fabrication.support.injection.FabModifyVariable;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(anyConfigAvailable={"*.stable_cacti", "*.stable_cacti_break_vanilla_compat"})
@Mixin(value={CactusBlock.class})
public class MixinCactusBlock
extends Block {
    public MixinCactusBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @FabModifyVariable(at=@At(value="STORE"), method={"canPlaceAt(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/WorldView;Lnet/minecraft/util/math/BlockPos;)Z"})
    public Iterator<Direction> returnEmptyIter(Iterator<Direction> old) {
        if (FabConf.isAnyEnabled("*.stable_cacti")) {
            return Collections.emptyIterator();
        }
        return old;
    }

    @FabInject(at={@At(value="HEAD")}, method={"getStateForNeighborUpdate(Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/Direction;Lnet/minecraft/block/BlockState;Lnet/minecraft/world/WorldAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"})
    public void getStateForNeighborUpdate(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom, CallbackInfoReturnable<BlockState> ci) {
        if (!FabConf.isAnyEnabled("*.stable_cacti")) {
            return;
        }
        if (direction == Direction.UP && state.m_60734_() == this && (Integer)state.m_61143_((Property)CactusBlock.f_51131_) > 0 && newState.m_60734_() == this && (Integer)newState.m_61143_((Property)CactusBlock.f_51131_) == 0) {
            boolean shouldBreak = false;
            for (Direction d : Direction.Plane.HORIZONTAL) {
                BlockPos p = posFrom.m_121945_(d);
                BlockState bs = world.m_8055_(p);
                Material m = bs.m_60767_();
                if (bs.m_60734_() == this || !m.m_76333_() && !world.m_6425_(p).m_205070_(FluidTags.f_13132_)) continue;
                shouldBreak = true;
                break;
            }
            if (shouldBreak && !FabConf.isEnabled("*.stable_cacti_break_vanilla_compat")) {
                world.m_46961_(posFrom, true);
            }
        }
    }
}

