/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.repackage.io.github.queerbric.pride;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Matrix4f;
import com.unascribed.fabrication.repackage.io.github.queerbric.pride.PrideFlagShape;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PrideFlagShapes {
    private static final Map<ResourceLocation, PrideFlagShape> registry = new HashMap<ResourceLocation, PrideFlagShape>();

    public static PrideFlagShape get(ResourceLocation id) {
        return registry.get(id);
    }

    public static void register(ResourceLocation id, PrideFlagShape shape) {
        registry.put(id, shape);
    }

    private PrideFlagShapes() {
    }

    static {
        final PrideFlagShape horzStripes = new PrideFlagShape(){

            @Override
            public void render(IntList colors, PoseStack matrices, float x, float y, float w, float h) {
                float sh = h / (float)colors.size();
                RenderSystem.m_69472_();
                Matrix4f mat = matrices.m_85850_().m_85861_();
                Tesselator t = Tesselator.m_85913_();
                BufferBuilder bb = t.m_85915_();
                bb.method_1328(7, DefaultVertexFormat.f_85815_);
                for (int i = 0; i < colors.size(); ++i) {
                    int color = colors.getInt(i);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    bb.m_85982_(mat, x, y + sh, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    bb.m_85982_(mat, x + w, y + sh, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    bb.m_85982_(mat, x + w, y, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    bb.m_85982_(mat, x, y, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    y += sh;
                }
                t.m_85914_();
                RenderSystem.m_69493_();
            }
        };
        PrideFlagShapes.register(new ResourceLocation("pride", "horizontal_stripes"), horzStripes);
        PrideFlagShapes.register(new ResourceLocation("pride", "vertical_stripes"), new PrideFlagShape(){

            @Override
            public void render(IntList colors, PoseStack matrices, float x, float y, float w, float h) {
                float sw = w / (float)colors.size();
                RenderSystem.m_69472_();
                Matrix4f mat = matrices.m_85850_().m_85861_();
                Tesselator t = Tesselator.m_85913_();
                BufferBuilder bb = t.m_85915_();
                bb.method_1328(7, DefaultVertexFormat.f_85815_);
                for (int i = 0; i < colors.size(); ++i) {
                    int color = colors.getInt(i);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    bb.m_85982_(mat, x, y + h, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    bb.m_85982_(mat, x + sw, y + h, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    bb.m_85982_(mat, x + sw, y, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    bb.m_85982_(mat, x, y, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    x += sw;
                }
                t.m_85914_();
                RenderSystem.m_69493_();
            }
        });
        PrideFlagShapes.register(new ResourceLocation("pride", "circle"), new PrideFlagShape(){

            @Override
            public void render(IntList colors, PoseStack matrices, float x, float y, float w, float h) {
                RenderSystem.m_69472_();
                Matrix4f mat = matrices.m_85850_().m_85861_();
                Tesselator tess = Tesselator.m_85913_();
                BufferBuilder bb = tess.m_85915_();
                int color = colors.getInt(0);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color >> 0 & 0xFF) / 255.0f;
                bb.method_1328(7, DefaultVertexFormat.f_85815_);
                bb.m_85982_(mat, x, y + h, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                bb.m_85982_(mat, x + w, y + h, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                bb.m_85982_(mat, x + w, y, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                bb.m_85982_(mat, x, y, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                tess.m_85914_();
                bb.method_1328(6, DefaultVertexFormat.f_85815_);
                float br = Math.min(w, h) * 0.3f;
                float cx = x + w / 2.0f;
                float cy = y + h / 2.0f;
                for (int p = 0; p < 2; ++p) {
                    float rd = p == 0 ? br : br * 0.8f;
                    int color2 = p == 0 ? colors.getInt(1) : colors.getInt(0);
                    float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
                    float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
                    float b2 = (float)(color2 >> 0 & 0xFF) / 255.0f;
                    bb.m_85982_(mat, cx, cy, 0.0f).m_85950_(r2, g2, b2, 1.0f).m_5752_();
                    for (int i = 0; i < 65; ++i) {
                        float t = (float)i / 64.0f;
                        float TAU = (float)Math.PI * 2;
                        bb.m_85982_(mat, cx + Mth.m_14031_((float)(t * ((float)Math.PI * 2))) * rd, cy + Mth.m_14089_((float)(t * ((float)Math.PI * 2))) * rd, 0.0f).m_85950_(r2, g2, b2, 1.0f).m_5752_();
                    }
                }
                tess.m_85914_();
                RenderSystem.m_69493_();
            }
        });
        PrideFlagShapes.register(new ResourceLocation("pride", "arrow"), new PrideFlagShape(){

            @Override
            public void render(IntList colors, PoseStack matrices, float x, float y, float w, float h) {
                float s = Math.min(w, h) / 2.0f;
                float cy = y + h / 2.0f;
                horzStripes.render(colors.subList(1, colors.size()), matrices, x, y, w, h);
                RenderSystem.m_69472_();
                Matrix4f mat = matrices.m_85850_().m_85861_();
                Tesselator t = Tesselator.m_85913_();
                BufferBuilder bb = t.m_85915_();
                bb.method_1328(4, DefaultVertexFormat.f_85815_);
                int color = colors.getInt(0);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color >> 0 & 0xFF) / 255.0f;
                bb.m_85982_(mat, x, cy + s, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                bb.m_85982_(mat, x + s * 1.5f, cy, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                bb.m_85982_(mat, x, cy - s, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                t.m_85914_();
                RenderSystem.m_69493_();
            }
        });
        IntArrayList progressBg = new IntArrayList(new int[]{13895174, 15637504, 14941952, 442112, 6808, 7733385});
        PrideFlagShapes.register(new ResourceLocation("pride", "progress"), new PrideFlagShape((IntList)progressBg){
            final /* synthetic */ IntList val$progressBg;
            {
                this.val$progressBg = intList;
            }

            @Override
            public void render(IntList colors, PoseStack matrices, float x, float y, float w, float h) {
                float hm = Math.min(w, h) / 2.0f;
                float cy = y + h / 2.0f;
                Matrix4f mat = matrices.m_85850_().m_85861_();
                Tesselator t = Tesselator.m_85913_();
                BufferBuilder bb = t.m_85915_();
                horzStripes.render(this.val$progressBg, matrices, x, y, w, h);
                RenderSystem.m_69472_();
                bb.method_1328(4, DefaultVertexFormat.f_85815_);
                int[] triangleColors = new int[]{0, 6305811, 7657452, 16756679, 16513525};
                float s = hm;
                for (int color : triangleColors) {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    bb.m_85982_(mat, x, cy + s, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    bb.m_85982_(mat, x + s * 1.1f, cy, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    bb.m_85982_(mat, x, cy - s, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
                    s -= hm / 6.0f;
                }
                t.m_85914_();
                RenderSystem.m_69493_();
            }
        });
    }
}

