/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support;

import com.google.common.collect.ImmutableMap;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ConfigPredicates {
    private static final Map<String, AtomicReference<Predicate<?>>> active;
    private static final Map<String, Feature> idle;
    public static final ImmutableMap<String, Predicate<?>> defaults;

    public static <T> Predicate<T> getFinalPredicate(String configKey) {
        configKey = FabConf.remap(configKey);
        AtomicReference<Predicate<?>> ref = ConfigPredicates.getOrCreateActive(configKey);
        return test -> {
            Predicate p = (Predicate)ref.get();
            if (p == null) {
                return true;
            }
            try {
                return p.test(test);
            }
            catch (Exception e) {
                FabLog.error("ConfigPredicates failed to cast predicate", e);
                return true;
            }
        };
    }

    public static synchronized AtomicReference<Predicate<?>> getOrCreateActive(String configKey) {
        AtomicReference<Predicate<Object>> ret = active.get(configKey);
        if (ret != null) {
            return ret;
        }
        ret = new AtomicReference();
        active.put(configKey, ret);
        return ret;
    }

    public static void put(String configKey, Predicate<?> predicate) {
        ConfigPredicates.put(configKey, predicate, 0);
    }

    public static void put(String configKey, Predicate<?> predicate, int level) {
        if (!idle.containsKey(configKey = FabConf.remap(configKey))) {
            idle.put(configKey, new Feature());
        }
        if (idle.get(configKey).add(predicate, level)) {
            ConfigPredicates.getOrCreateActive(configKey).set(predicate);
        }
    }

    public static void remove(String configKey) {
        ConfigPredicates.remove(configKey, 0);
    }

    public static void remove(String configKey, int level) {
        if (idle.containsKey(configKey = FabConf.remap(configKey))) {
            AtomicReference<Predicate<?>> ref = ConfigPredicates.getOrCreateActive(configKey);
            Predicate rtrn = idle.get(configKey).remove(level, ref.get());
            ref.set(rtrn == null ? (Predicate)defaults.get((Object)configKey) : rtrn);
        }
    }

    static {
        idle = new HashMap<String, Feature>();
        HashMap<String, Predicate<Object>> defaultsMap = new HashMap<String, Predicate<Object>>();
        defaultsMap.put(FabConf.remap("*.no_sprint"), entity -> !entity.m_5842_());
        defaultsMap.put(FabConf.remap("*.swap_conflicting_enchants"), Entity::m_20163_);
        defaultsMap.put(FabConf.remap("*.velocity_based_fall_damage_reset"), entity -> !(entity instanceof LivingEntity) || !((LivingEntity)entity).m_6147_());
        defaultsMap.put(FabConf.remap("*.cactus_walk_doesnt_hurt_with_boots"), livingEntity -> !livingEntity.m_6844_(EquipmentSlot.FEET).m_41619_());
        defaultsMap.put(FabConf.remap("*.cactus_brush_doesnt_hurt_with_chest"), livingEntity -> !livingEntity.m_6844_(EquipmentSlot.CHEST).m_41619_());
        defaultsMap.put(FabConf.remap("*.creepers_explode_when_on_fire"), livingEntity -> livingEntity.m_20094_() > 0 && !livingEntity.m_21023_(MobEffects.f_19607_));
        defaultsMap.put(FabConf.remap("*.cactus_punching_hurts"), serverPlayerEntity -> serverPlayerEntity.m_21205_().m_41619_());
        defaultsMap.put(FabConf.remap("*.feather_falling_five"), livingEntity -> EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44967_, (ItemStack)livingEntity.m_6844_(EquipmentSlot.FEET)) >= 5);
        defaultsMap.put(FabConf.remap("*.feather_falling_five_damages_boots"), livingEntity -> EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44967_, (ItemStack)livingEntity.m_6844_(EquipmentSlot.FEET)) >= 5);
        defaults = ImmutableMap.copyOf(defaultsMap);
        active = defaults.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new AtomicReference<Predicate>((Predicate)e.getValue())));
    }

    private static class Feature {
        Integer i = Integer.MIN_VALUE;
        Map<Integer, Predicate<?>> map = new HashMap();

        private Feature() {
        }

        public boolean add(Predicate<?> predicate, int level) {
            this.map.put(level, predicate);
            if (this.i <= level) {
                this.i = level;
                return true;
            }
            return false;
        }

        public Predicate<?> remove(int level, Predicate<?> defaultVal) {
            this.map.remove(level);
            if (this.map.isEmpty()) {
                this.i = Integer.MIN_VALUE;
                return null;
            }
            if (this.i <= level) {
                this.i = this.map.keySet().stream().max(Comparator.comparingInt(i -> i)).get();
                return this.map.get(this.i);
            }
            return defaultVal;
        }
    }
}

